/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import java.math.BigInteger;
import uibk.mtk.geom.geom2d.Punkt2D;

public final class MathUtil {
    private MathUtil() {
    }

    public static double max(double[] t) {
        double maximum = t[0];
        int i = 1;
        while (i < t.length) {
            if (t[i] > maximum) {
                maximum = t[i];
            }
            ++i;
        }
        return maximum;
    }

    public static double min(double[] t) {
        double minimum = t[0];
        int i = 1;
        while (i < t.length) {
            if (t[i] < minimum) {
                minimum = t[i];
            }
            ++i;
        }
        return minimum;
    }

    public static double interpolate(double a, double b, double valuea, double valueb, double x) {
        if (b - a <= 0.0) {
            return valuea;
        }
        double k = (b - x) / (b - a);
        double l = (x - a) / (b - a);
        return k * valuea + l * valueb;
    }

    public static double norm1(double[] t) {
        double norm = 0.0;
        int i = 0;
        while (i < t.length) {
            norm += Math.abs(t[i]);
            ++i;
        }
        return norm;
    }

    public static double interpolate(Punkt2D a, Punkt2D b, double valuea, double valueb, Punkt2D p) {
        double lenght = (b.x - a.x) * (b.x - a.x) + (b.y - a.y) * (b.y - a.y);
        if (lenght == 0.0) {
            return valuea;
        }
        double dist = Math.sqrt(((p.x - a.x) * (p.x - a.x) + (p.y - a.y) * (p.y - a.y)) / lenght);
        return valuea * (1.0 - dist) + valueb * dist;
    }

    public static double sign(double x) {
        if (Double.isNaN(x)) {
            return Double.NaN;
        }
        if (x < 0.0) {
            return -1.0;
        }
        if (x > 0.0) {
            return 1.0;
        }
        return 0.0;
    }

    public static double hypot(double a, double b) {
        double r;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        } else {
            r = 0.0;
        }
        return r;
    }

    public static double gamma(double a) {
        if (a <= 0.0) {
            throw new IllegalArgumentException("");
        }
        if ((double)((int)a) - a == 0.0) {
            return MathUtil.fac((int)a - 1).doubleValue();
        }
        if ((double)((int)(a - 0.5)) - (a - 0.5) == 0.0) {
            if (a > 0.5) {
                double ret = 1.0;
                a -= 1.0;
                while (a > 0.5) {
                    ret *= a;
                    a -= 1.0;
                }
                return ret *= 0.5 * Math.sqrt(Math.PI);
            }
            return Math.sqrt(Math.PI);
        }
        return Math.sqrt(Math.PI * 2) * Math.pow(a, a - 0.5) / Math.exp(a - 1.0 / (12.0 * a));
    }

    public static BigInteger fac(int t) {
        if (t < 0) {
            throw new IllegalArgumentException("");
        }
        BigInteger ret = BigInteger.ONE;
        while (t > 0) {
            ret = ret.multiply(BigInteger.valueOf(t));
            --t;
        }
        return ret;
    }
}

