/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.lang;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import uibk.mtk.lang.Clickable;
import uibk.mtk.lang.Dragable;
import uibk.mtk.lang.Drawable;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.lang.Options;
import uibk.mtk.lang.Reporter;
import uibk.mtk.lang.ToolTipable;
import uibk.mtk.swing.base.MPanel;

public abstract class MathPanel
extends MPanel
implements ComponentListener {
    protected boolean repaintrequested = false;
    protected Highlightable highlighted = null;
    private HighlightListening highlightListener = new HighlightListening();
    private MyMouseDragListening mouseListenerDrag = new MyMouseDragListening();
    private MyMouseClickListening mouseListenerClicks = new MyMouseClickListening();
    private MyMouseMotionListening mouseMotionListener = new MyMouseMotionListening();
    boolean highlighting_enabled = false;
    private static final Color BACKGROUND = Color.white;
    Dragable dragged = null;
    boolean listenforclicks = false;
    boolean listenForDrags = false;
    protected BufferedImage framebuffer;
    private boolean autoRepaint = true;
    protected Vector drawItems = new Vector();
    private Reporter reporter = null;
    protected Options options;
    Vector clickactions = new Vector();
    Vector dragactions = new Vector();
    Vector highlightactions = new Vector();

    public MathPanel() {
        this.setBackground(BACKGROUND);
        this.addComponentListener(this);
    }

    public void delete(Drawable drawable) {
        Iterator it = this.drawItems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != drawable) continue;
            it.remove();
            this.requestRecompute();
            return;
        }
    }

    public void delete(Class tclass) {
        ListIterator it = this.drawItems.listIterator();
        while (it.hasNext()) {
            Object obj = it.next();
            Class<?> c = obj.getClass();
            while (c != null) {
                if (c == tclass) {
                    it.remove();
                }
                c = c.getSuperclass();
            }
        }
    }

    public ListIterator get(Class tclass) {
        ListIterator it = this.drawItems.listIterator();
        Vector v = new Vector();
        while (it.hasNext()) {
            Object obj = it.next();
            Class<?> c = obj.getClass();
            while (c != null) {
                if (c == tclass) {
                    v.add(obj);
                }
                c = c.getSuperclass();
            }
        }
        return v.listIterator();
    }

    public void enableHighLighting(boolean enable) {
        if (this.highlighting_enabled == enable) {
            return;
        }
        this.highlighting_enabled = enable;
        if (this.highlighting_enabled) {
            this.addMouseMotionListener(this.highlightListener);
        } else {
            this.removeMouseMotionListener(this.highlightListener);
        }
    }

    public void setHighlightable(Highlightable high) {
        this.highlighted = high;
    }

    public Highlightable getHighLighted() {
        return this.highlighted;
    }

    public void requestRecompute() {
        if (this.autoRepaint) {
            this.repaintrequested = true;
        }
    }

    public void requestRecompute(boolean b) {
        this.repaintrequested = b;
    }

    public void repaint() {
        if (this.autoRepaint) {
            this.repaintrequested = true;
            super.repaint();
        }
    }

    public String getToolTipText(MouseEvent event) {
        int ct = this.drawItems.size();
        int i = 0;
        while (i < ct) {
            if (this.drawItems.elementAt(i) instanceof ToolTipable && ((ToolTipable)this.drawItems.elementAt(i)).isToolTipEnabled() && ((ToolTipable)this.drawItems.elementAt(i)).tooltipcontains(event.getX(), event.getY())) {
                return ((ToolTipable)this.drawItems.elementAt(i)).getToolTipText(event);
            }
            ++i;
        }
        return null;
    }

    public void componentShown(ComponentEvent ev) {
    }

    public void componentHidden(ComponentEvent ev) {
    }

    public void componentMoved(ComponentEvent ev) {
    }

    public void componentResized(ComponentEvent ev) {
        this.repaint();
    }

    public void report(String message) {
        this.reporter.report(message);
    }

    public void reportError(Exception ex) {
        this.reportError(ex.getMessage());
    }

    public void reportError(Exception ex, Component parentComponent) {
        this.reporter.reportError(ex.getMessage(), parentComponent);
    }

    public void reportError(String title, Exception ex, Component parentComponent) {
        this.reporter.reportError(String.valueOf(title) + ": " + ex.getMessage(), parentComponent);
    }

    public void reportError(String massage, Component parentComponent) {
        this.reporter.reportError(massage, parentComponent);
    }

    public void reportWarning(String title, Exception ex, Component parentComponent) {
        this.reporter.reportWarning(String.valueOf(title) + ": " + ex.getMessage(), parentComponent);
    }

    public void reportWarning(Exception ex, Component parentComponent) {
        this.reporter.reportWarning(ex.getMessage(), parentComponent);
    }

    public void reportWarning(String massage, Component parentComponent) {
        this.reporter.reportWarning(massage, parentComponent);
    }

    public void reportError(String title, Exception ex) {
        this.reportError(String.valueOf(title) + ": " + ex.getMessage());
    }

    public void reportError(String message) {
        this.reporter.reportError(message);
    }

    public void reportSuccess(String message) {
        this.reporter.reportSuccess(message);
    }

    public void reportSuccess(String message, Component parentComponent) {
        this.reporter.reportSuccess(message, parentComponent);
    }

    public void setReporter(Reporter rep) {
        this.reporter = rep;
    }

    public void setOptions(Options options) {
        this.options = options;
    }

    public Options getOptions() {
        return this.options;
    }

    public void add(Object obj) {
        if (obj == null || !(obj instanceof Drawable)) {
            throw new IllegalArgumentException("");
        }
        if (!this.drawItems.contains(obj)) {
            Drawable draw = (Drawable)obj;
            this.drawItems.addElement(draw);
        }
    }

    public void addClickListener(ActionListener listener) {
        this.clickactions.add(listener);
    }

    public void addDragListener(ActionListener listener) {
        this.dragactions.add(listener);
    }

    public void removeAllDragListener() {
        this.dragactions.removeAllElements();
    }

    public void addHighlightListener(ActionListener listener) {
        this.highlightactions.add(listener);
    }

    private void informClickListeners(Object obj) {
        Iterator it = this.clickactions.iterator();
        while (it.hasNext()) {
            ActionEvent ev = new ActionEvent(obj, 0, "click");
            ((ActionListener)it.next()).actionPerformed(ev);
        }
    }

    private void informDragListeners(Object obj) {
        Iterator it = this.dragactions.iterator();
        while (it.hasNext()) {
            ActionEvent ev = new ActionEvent(obj, 0, "drag");
            ((ActionListener)it.next()).actionPerformed(ev);
        }
    }

    private void informHighlightListeners(Object obj) {
        Iterator it = this.highlightactions.iterator();
        while (it.hasNext()) {
            ActionEvent ev = new ActionEvent(obj, 0, "highlight");
            ((ActionListener)it.next()).actionPerformed(ev);
        }
    }

    public void setListenForClicks(boolean listen) {
        if (this.listenforclicks == listen) {
            return;
        }
        this.listenforclicks = listen;
        if (this.listenforclicks) {
            this.addMouseListener(this.mouseListenerClicks);
        } else {
            this.removeMouseListener(this.mouseListenerClicks);
        }
    }

    public void setListenForDragAndDrop(boolean listenForDrags) {
        if (listenForDrags == this.listenForDrags) {
            return;
        }
        this.listenForDrags = listenForDrags;
        if (listenForDrags) {
            this.addMouseListener(this.mouseListenerDrag);
            this.addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.removeMouseListener(this.mouseListenerDrag);
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    protected void preparebuffer() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.framebuffer != null && (this.framebuffer.getWidth() != w || this.framebuffer.getHeight() != h)) {
            this.requestRecompute();
        }
        if (this.framebuffer == null || w > this.framebuffer.getWidth() || h > this.framebuffer.getHeight()) {
            this.framebuffer = (BufferedImage)this.createImage(w, h);
        }
    }

    public synchronized void paint(Graphics g) {
        super.paint(g);
        if (!this.isVisible() || this.getWidth() < 100 || this.getHeight() < 100) {
            return;
        }
        this.preparebuffer();
        Graphics2D g2 = this.framebuffer.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.framebuffer.getWidth(), this.framebuffer.getHeight());
        this.drawDrawables(this.framebuffer, g2);
        g.drawImage(this.framebuffer, 0, 0, null);
    }

    public void background(Drawable drawable) {
        Iterator it = this.drawItems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != drawable) continue;
            it.remove();
            this.drawItems.add(0, drawable);
            this.requestRecompute();
            return;
        }
    }

    public void foreground(Drawable drawable) {
        Iterator it = this.drawItems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != drawable) continue;
            it.remove();
            this.drawItems.add(drawable);
            this.requestRecompute();
            return;
        }
    }

    public BufferedImage getBufferedImage() {
        return this.framebuffer;
    }

    public abstract void drawDrawables(BufferedImage var1, Graphics2D var2);

    public void setAutoRepaint(boolean b) {
        this.autoRepaint = b;
    }

    protected class HighlightListening
    extends MouseMotionAdapter {
        protected HighlightListening() {
        }

        public void mouseMoved(MouseEvent ev) {
            Iterator it = MathPanel.this.drawItems.iterator();
            Highlightable old = MathPanel.this.highlighted;
            MathPanel.this.highlighted = null;
            while (it.hasNext()) {
                Object d = it.next();
                if (!(d instanceof Highlightable) || !((Highlightable)d).highlightcontains(ev.getX(), ev.getY())) continue;
                MathPanel.this.highlighted = (Highlightable)d;
                MathPanel.this.informHighlightListeners(d);
            }
            if (old != MathPanel.this.highlighted) {
                MathPanel.this.repaint();
            }
        }
    }

    protected class MyMouseClickListening
    extends MouseAdapter {
        protected MyMouseClickListening() {
        }

        public void mousePressed(MouseEvent ev) {
            int i = MathPanel.this.drawItems.size() - 1;
            while (i >= 0) {
                if (MathPanel.this.drawItems.elementAt(i) instanceof Clickable && ((Clickable)MathPanel.this.drawItems.elementAt(i)).clickcontains(ev.getX(), ev.getY())) {
                    ((Clickable)MathPanel.this.drawItems.elementAt(i)).click(ev);
                    MathPanel.this.informClickListeners(MathPanel.this.drawItems.elementAt(i));
                }
                --i;
            }
        }
    }

    protected class MyMouseDragListening
    extends MouseAdapter {
        protected MyMouseDragListening() {
        }

        public void mousePressed(MouseEvent ev) {
            int i = MathPanel.this.drawItems.size() - 1;
            while (i >= 0) {
                if (MathPanel.this.drawItems.elementAt(i) instanceof Dragable && ((Dragable)MathPanel.this.drawItems.elementAt(i)).dragcontains(ev.getX(), ev.getY())) {
                    MathPanel.this.dragged = (Dragable)MathPanel.this.drawItems.elementAt(i);
                    MathPanel.this.drawItems.remove(i);
                    MathPanel.this.drawItems.add(MathPanel.this.dragged);
                }
                --i;
            }
        }

        public void mouseReleased(MouseEvent ev) {
            MathPanel.this.dragged = null;
        }
    }

    protected class MyMouseMotionListening
    extends MouseMotionAdapter {
        protected MyMouseMotionListening() {
        }

        public void mouseDragged(MouseEvent ev) {
            if (MathPanel.this.dragged == null || !MathPanel.this.dragged.isDragEnabled()) {
                return;
            }
            MathPanel.this.dragged.drag(ev);
            MathPanel.this.informDragListeners(MathPanel.this.dragged);
            MathPanel.this.repaint();
        }
    }
}

