/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.geom.geom2d;

import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.math.Rounder;

public class CoordinateRect2D
implements Cloneable {
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;
    public static final int ROUND_X = 1;
    public static final int ROUND_Y = 2;
    public static final int ROUND_XY = 3;
    public static final int AREA_UPPERRIGHT = 1;
    public static final int AREA_UPPERLEFT = 2;
    public static final int AREA_LOWERLEFT = 4;
    public static final int AREA_LOWERRIGHT = 8;
    public static final int AREA_UPPER = 3;
    public static final int AREA_LOWER = 18;
    public static final int AREA_RIGHT = 9;
    public static final int AREA_LEFT = 6;
    public static final int AREA_ALL = 21;

    public CoordinateRect2D(double xmin, double xmax, double ymin, double ymax) {
        if (xmax < xmin || ymax < ymin) {
            throw new IllegalArgumentException("");
        }
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public CoordinateRect2D() {
        this(-1.0, 1.0, -1.0, 1.0);
    }

    public boolean xcontains(double x) {
        return x <= this.xmax && x >= this.xmin;
    }

    public boolean ycontains(double y) {
        return y <= this.ymax && y >= this.ymin;
    }

    public boolean contains(CoordinateRect2D rect) {
        return !(rect.xmin < this.xmin || rect.ymin < this.ymin || rect.xmax > this.xmax) && !(rect.ymax > this.ymax);
    }

    public boolean contains(Punkt2D p) {
        return this.xcontains(p.x) && this.ycontains(p.y);
    }

    public boolean contains(double x, double y) {
        return this.xcontains(x) && this.ycontains(y);
    }

    public double getXRange() {
        return this.xmax - this.xmin;
    }

    public double getYRange() {
        return this.ymax - this.ymin;
    }

    public String toString() {
        return "[xmin=" + this.xmin + ", xmax=" + this.xmax + ", ymin=" + this.ymin + ", ymax=" + this.ymax + "]";
    }

    public Object clone() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public CoordinateRect2D combine(CoordinateRect2D rect) {
        double newxmin = this.xmin < rect.xmin ? this.xmin : rect.xmin;
        double newxmax = this.xmax > rect.xmax ? this.xmax : rect.xmax;
        double newymin = this.ymin < rect.ymin ? this.ymin : rect.ymin;
        double newymax = this.ymax > rect.ymax ? this.ymax : rect.ymax;
        return new CoordinateRect2D(newxmin, newxmax, newymin, newymax);
    }

    public void roundCoords(double percent, int adjust) {
        double newymin = this.ymin;
        double newymax = this.ymax;
        double newxmin = this.xmin;
        double newxmax = this.xmax;
        double distx = Math.abs((this.xmax - this.xmin) / 100.0 * percent);
        double disty = Math.abs((this.ymax - this.ymin) / 100.0 * percent);
        if ((adjust & 2) == 2) {
            newymax = Rounder.getUpperRoundValue(this.ymax, disty);
            newymin = Rounder.getLowerRoundValue(this.ymin, disty);
        }
        if ((adjust & 1) == 1) {
            newxmax = Rounder.getUpperRoundValue(this.xmax, distx);
            newxmin = Rounder.getLowerRoundValue(this.xmin, distx);
        }
        if ((adjust & 2) == 2) {
            if (this.ymin > 0.0 && this.ymin - disty < 0.0) {
                newymin = 0.0;
            }
            if (this.ymax < 0.0 && this.ymax + disty > 0.0) {
                newymax = 0.0;
            }
        }
        if ((adjust & 1) == 1) {
            if (this.xmin > 0.0 && this.xmin - distx < 0.0) {
                newxmin = 0.0;
            }
            if (this.xmax < 0.0 && this.xmax + distx > 0.0) {
                newxmax = 0.0;
            }
        }
        this.ymin = newymin;
        this.ymax = newymax;
        this.xmin = newxmin;
        this.xmax = newxmax;
    }

    public int getArea() {
        if (this.ymin >= 0.0) {
            if (this.xmin >= 0.0) {
                return 1;
            }
            if (this.xmax <= 0.0) {
                return 2;
            }
            return 3;
        }
        if (this.ymax <= 0.0) {
            if (this.xmin >= 0.0) {
                return 8;
            }
            if (this.xmax <= 0.0) {
                return 4;
            }
            return 18;
        }
        if (this.xmax <= 0.0) {
            return 6;
        }
        if (this.xmin >= 0.0) {
            return 9;
        }
        return 21;
    }

    public CoordinateRect2D mult(double x) {
        double x1 = -this.getXRange() / 2.0 * (x - 1.0) + this.xmin;
        double x2 = this.getXRange() / 2.0 * (x - 1.0) + this.xmax;
        double y1 = -this.getYRange() / 2.0 * (x - 1.0) + this.ymin;
        double y2 = this.getYRange() / 2.0 * (x - 1.0) + this.ymax;
        CoordinateRect2D mult = new CoordinateRect2D(x1, x2, y1, y2);
        return mult;
    }
}

