/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.geom.geom2d.CoordinateRect2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class PointPlot2D
extends Graph2D
implements ToolTipable {
    protected Color linecolor = Color.blue;
    protected int pointradius;
    protected boolean tooltipenabled;
    protected Stroke strokecolumns;
    boolean connectpoints = false;
    boolean columns = false;
    protected boolean histogramm = false;
    private boolean pointVisible = true;
    private double minX;
    private double maxX;
    private boolean kum;

    public void connectPoints(boolean enable) {
        this.connectpoints = enable;
    }

    public void columns(boolean enable) {
        this.columns = enable;
        this.histogramm = !enable;
        this.kum = !enable;
        this.pointradius = 0;
    }

    public void setPointRadius(int pointradius) {
        this.pointradius = pointradius;
        int i = 0;
        while (i < this.points.size()) {
            ((MathPoint2D)this.points.elementAt(i)).setRadius(pointradius);
            ++i;
        }
    }

    public void setLineColor(Color linecolor) {
        this.linecolor = linecolor;
    }

    public void setColor(Color pointcolor) {
        super.setColor(pointcolor);
        int i = 0;
        while (i < this.points.size()) {
            ((MathPoint2D)this.points.elementAt(i)).setColor(pointcolor);
            ++i;
        }
    }

    public boolean tooltipcontains(int x, int y) {
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getToolTipText(MouseEvent ev) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(ev.getX(), ev.getY())) {
                return "(" + p.getX() + "," + p.getY() + ")";
            }
            ++i;
        }
        return null;
    }

    public void setToolTipText(String tooltip) {
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean enabled) {
        this.tooltipenabled = enabled;
    }

    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            ((Drawable2D)this.points.elementAt(i)).setMathPanel2D(panel);
            ++i;
        }
    }

    public PointPlot2D() {
        this.color = Color.red;
        this.pointradius = 2;
        this.stroke = new BasicStroke(1.0f);
        this.strokecolumns = new BasicStroke(4.0f);
        this.tooltipenabled = true;
    }

    public Vector setPoints(double[] x, double[] y) {
        this.points.clear();
        int i = 0;
        while (i < x.length) {
            this.addMathPoint(x[i], y[i]);
            ++i;
        }
        this.limitsdirty = true;
        return this.points;
    }

    private void addMathPoint(double x, double y) {
        MathPoint2D mp = new MathPoint2D(x, y);
        mp.setMathPanel2D(this.panel);
        mp.setRadius(this.pointradius);
        mp.setColor(this.color);
        mp.setVisible(this.pointVisible);
        this.points.add(mp);
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (this.points == null || this.points.size() == 0) {
            return;
        }
        int size = this.points.size();
        int x = 0;
        int width = 10;
        Double xd = new Double(0.0);
        Double widthd = new Double(0.0);
        Vector<MathPoint2D> kumSum = new Vector<MathPoint2D>();
        kumSum.add(new MathPoint2D(this.minX, 0.0));
        int i = 0;
        while (i < size) {
            Drawable2D d = (Drawable2D)this.points.elementAt(i);
            if (i < size - 1) {
                MathPoint2D start = (MathPoint2D)this.points.elementAt(i);
                MathPoint2D end = (MathPoint2D)this.points.elementAt(i + 1);
                if (this.histogramm || this.kum) {
                    g2.setColor(this.linecolor);
                    if (i == 0) {
                        xd = this.minX;
                        x = this.scene2d.xToPixel(this.minX);
                        if (size == 1) {
                            widthd = this.maxX - this.minX;
                            width = this.scene2d.xToPixel(this.maxX) - this.scene2d.xToPixel(this.minX);
                        } else {
                            widthd = (end.x + start.x) / 2.0 - xd;
                            width = this.scene2d.xToPixel((end.x + start.x) / 2.0) - x;
                        }
                    } else if (size != 1) {
                        widthd = (end.x + start.x) / 2.0 - xd;
                        width = this.scene2d.xToPixel((end.x + start.x) / 2.0) - x;
                    }
                    if (this.histogramm) {
                        g2.setColor(this.color);
                        g2.fillRect(x, this.scene2d.yToPixel(start.y), width, -this.scene2d.yToPixel(start.y) + this.scene2d.yToPixel(0.0));
                        g2.setColor(this.linecolor);
                        g2.drawRect(x, this.scene2d.yToPixel(start.y), width, -this.scene2d.yToPixel(start.y) + this.scene2d.yToPixel(0.0));
                    }
                    start.setRadius(width / 2);
                    xd = xd + widthd;
                    x += width;
                    if (this.kum) {
                        kumSum.add(new MathPoint2D(this.scene2d.pixelToX(x), ((MathPoint2D)kumSum.lastElement()).y + widthd * start.y));
                    }
                }
                if (d.isVisible()) {
                    g2.setColor(this.linecolor);
                    g2.setStroke(this.stroke);
                    if (this.connectpoints) {
                        g2.drawLine(this.scene2d.xToPixel(start.getX()), this.scene2d.yToPixel(start.getY()), this.scene2d.xToPixel(end.getX()), this.scene2d.yToPixel(end.getY()));
                    }
                    if (this.columns) {
                        g2.setStroke(this.strokecolumns);
                        g2.drawLine(this.scene2d.xToPixel(start.getX()), this.scene2d.yToPixel(start.getY()), this.scene2d.xToPixel(start.getX()), this.scene2d.yToPixel(0.0));
                    }
                }
            }
            if (d.isVisible()) {
                d.draw(framebuffer, g2);
            }
            ++i;
        }
        MathPoint2D point = (MathPoint2D)this.points.elementAt(size - 1);
        if (this.columns) {
            g2.setStroke(this.strokecolumns);
            g2.drawLine(this.scene2d.xToPixel(point.getX()), this.scene2d.yToPixel(point.getY()), this.scene2d.xToPixel(point.getX()), this.scene2d.yToPixel(0.0));
        }
        if (this.histogramm) {
            width = this.scene2d.xToPixel(this.maxX) - x;
            point.setRadius(this.scene2d.xToPixel(width / 2));
            g2.setColor(this.color);
            g2.fillRect(x, this.scene2d.yToPixel(point.y), width, this.scene2d.yToPixel(0.0) - this.scene2d.yToPixel(point.y));
            g2.setColor(this.linecolor);
            g2.drawRect(x, this.scene2d.yToPixel(point.y), width, this.scene2d.yToPixel(0.0) - this.scene2d.yToPixel(point.y));
        }
        if (this.kum) {
            widthd = this.maxX - xd;
            kumSum.add(new MathPoint2D(this.maxX, ((MathPoint2D)kumSum.lastElement()).y + widthd * point.y));
            g2.setColor(this.linecolor);
            g2.setStroke(this.stroke);
            int i2 = 0;
            while (i2 < size) {
                g2.drawLine(this.scene2d.xToPixel(((MathPoint2D)kumSum.get((int)i2)).x), this.scene2d.yToPixel(((MathPoint2D)kumSum.get((int)i2)).y / ((MathPoint2D)kumSum.lastElement()).y), this.scene2d.xToPixel(((MathPoint2D)kumSum.get((int)(i2 + 1))).x), this.scene2d.yToPixel(((MathPoint2D)kumSum.get((int)(i2 + 1))).y / ((MathPoint2D)kumSum.lastElement()).y));
                ++i2;
            }
        }
    }

    public void setPoints(Vector points) {
        this.points.clear();
        int i = 0;
        while (i < points.size()) {
            if (points.get(i) instanceof Punkt2D) {
                this.addPoint((Punkt2D)points.get(i));
            } else if (points.get(i) instanceof MathPoint2D) {
                this.points.add(points.get(i));
            } else {
                throw new IllegalArgumentException("");
            }
            ++i;
        }
        this.limitsdirty = true;
    }

    public void addPoint(Punkt2D p) {
        this.addMathPoint(p.x, p.y);
        this.limitsdirty = true;
    }

    public void addPoint(double x, double y) {
        this.points.add(new Punkt2D(x, y));
        this.limitsdirty = true;
    }

    protected void recalcLimits() {
        this.limits = this.points != null && this.points.size() > 0 ? PointPlot2D.getLimits(this.points) : new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public static CoordinateRect2D getLimits(Vector points) {
        double maximumx = Double.NEGATIVE_INFINITY;
        double maximumy = Double.NEGATIVE_INFINITY;
        double minimumx = Double.POSITIVE_INFINITY;
        double minimumy = Double.POSITIVE_INFINITY;
        int i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).x > maximumx) {
                maximumx = ((MathPoint2D)points.elementAt((int)i)).x;
            }
            ++i;
        }
        i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).y > maximumy) {
                maximumy = ((MathPoint2D)points.elementAt((int)i)).y;
            }
            ++i;
        }
        i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).x < minimumx) {
                minimumx = ((MathPoint2D)points.elementAt((int)i)).x;
            }
            ++i;
        }
        i = 0;
        while (i < points.size()) {
            if (points.elementAt(i) != null && ((MathPoint2D)points.elementAt((int)i)).y < minimumy) {
                minimumy = ((MathPoint2D)points.elementAt((int)i)).y;
            }
            ++i;
        }
        return new CoordinateRect2D(minimumx, maximumx, minimumy, maximumy);
    }

    public void setHistogramm(boolean histogramm) {
        this.histogramm = histogramm;
        this.columns = !histogramm;
        this.kum = !histogramm;
    }

    public void setPointVisible(boolean point) {
        this.pointVisible = point;
    }

    public void setMinX(double minX) {
        this.minX = minX;
    }

    public void setMaxX(double maX) {
        this.maxX = maX;
    }

    public void setKum(boolean kum) {
        this.histogramm = !kum;
        this.columns = !kum;
        this.kum = kum;
    }
}

