/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.event.MouseEvent;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.objects.PointPlot2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.MathUtil;

public class GraphSequence
extends PointPlot2D {
    private String strFormula;
    static final String BUNDLE_NAME = "uibk.mtk.draw2d.object.messages";

    public void setFormula(String formula) {
        this.strFormula = formula;
    }

    public String getToolTipText(MouseEvent ev) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(ev.getX(), ev.getY())) {
                String str = this.columns || this.histogramm ? "(" + String.valueOf(p.getX()) + "," + String.valueOf(p.getY()) + ")" : (p.getX() == 0.0 || p.getX() == (double)(size - 1) ? String.valueOf(Messages.getString(BUNDLE_NAME, "GraphSequence.0")) + this.strFormula + "</b><br>a(" + (int)p.getX() + ")=" + String.valueOf(p.getY()) : "a(" + String.valueOf((int)p.getX()) + ")=" + String.valueOf(p.getY()));
                return str;
            }
            ++i;
        }
        return null;
    }

    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            ((Drawable2D)this.points.elementAt(i)).setMathPanel2D(panel);
            ++i;
        }
    }

    public GraphSequence() {
        this.linecolor = Color.blue;
        this.color = Color.red;
        this.pointradius = 2;
        this.connectpoints = true;
        this.tooltipenabled = true;
    }

    public void setSequence(double[] a, int startIndex, int endIndex) {
        this.points.clear();
        this.limits.ymax = MathUtil.max(a);
        this.limits.ymin = MathUtil.min(a);
        this.limits.xmin = startIndex;
        this.limits.xmax = endIndex;
        int index = startIndex;
        int i = 0;
        while (i < a.length) {
            MathPoint2D temp = new MathPoint2D(index, a[i]);
            temp.setMathPanel2D(this.panel);
            temp.setRadius(this.pointradius);
            temp.setColor(this.color);
            this.points.add(temp);
            ++index;
            ++i;
        }
    }

    public void setStrokecolumns(BasicStroke basicStroke) {
        this.strokecolumns = basicStroke;
    }
}

