/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.axes2d.Axis;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.geom2d.Punkt2D;

class YAxis
extends Axis {
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private Scene2D coords2d;

    YAxis(Axes2D axes) {
        super(axes);
    }

    void compute(Punkt2D start, Punkt2D end, Punkt2D axisIntersection, int tickAndLabelPos, Graphics2D g2, Scene2D coords2d) {
        this.coords2d = coords2d;
        if (this.style != 2) {
            Vector tickPositions = this.axes.computeTickPositions(start.y, end.y);
            if (tickPositions != null && tickPositions.size() > 0) {
                this.ticks = this.axes.createTicks(tickPositions, tickAndLabelPos, coords2d.getYPixelScale() / 10.0, start.x, this.axes.formaty);
            }
            if (this.ticks != null) {
                int i = 0;
                while (i < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(i)).compute(g2, coords2d);
                    ++i;
                }
            }
        }
        this.startX = coords2d.xToPixel(start.x);
        this.startY = coords2d.yToPixel(start.y);
        this.endX = coords2d.xToPixel(end.x);
        this.endY = coords2d.yToPixel(end.y);
        if (this.axes.directiony == 1) {
            this.arrowUp();
        } else if (this.axes.directiony == 2) {
            this.arrowDown();
        } else if (axisIntersection != null && Math.abs(start.y - axisIntersection.y) > Math.abs(end.y - axisIntersection.y)) {
            this.arrowDown();
        } else {
            this.arrowUp();
        }
        FontMetrics metrics = g2.getFontMetrics();
        int height = metrics.getHeight();
        int length = metrics.stringWidth(this.caption);
        this.captionpos.y = this.endPix.y + height / 4;
        this.captionpos.x = tickAndLabelPos == 0 ? this.endPix.x + 4 : this.endPix.x - length - 4;
        coords2d.requestSpaceRight(this.startPix.x + OFFSETWINGS);
        coords2d.requestSpaceLeft(this.startPix.x - OFFSETWINGS);
    }

    void draw(Graphics2D g2, Scene2D coords2d) {
        g2.setColor(this.axes.coloryaxes);
        if (this.axes.style == 1) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.axes.strokeyaxes);
            if (this.startPix.y > this.endPix.y) {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 2);
            } else {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 3);
            }
            g2.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
            g2.setStroke(oldStroke);
        }
        if (this.ticks != null && this.style != 2) {
            boolean drawLabels = this.style == 1;
            int i = 0;
            while (i < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(i)).draw(g2, coords2d, drawLabels);
                ++i;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("") && this.axes.style != 0) {
            Font oldFont = g2.getFont();
            if (this.captionSize > 0) {
                Font font = new Font(oldFont.getName(), oldFont.getStyle(), this.captionSize);
                g2.setFont(font);
            }
            g2.drawString(this.caption, this.captionpos.x, this.captionpos.y);
            g2.setFont(oldFont);
        }
    }

    private void arrowDown() {
        this.startPix.x = this.endX;
        this.startPix.y = this.endY;
        this.endPix.x = this.startX;
        this.endPix.y = this.startY;
        this.coords2d.requestSpaceBottom(this.endPix.y + ARROWLENGTH);
        if (this.axes.area == 21 || this.axes.area == 9 || this.axes.area == 6) {
            this.startPix.y -= ARROWLENGTH;
            this.coords2d.requestSpaceTop(this.startPix.y);
        }
    }

    private void arrowUp() {
        this.startPix.x = this.startX;
        this.startPix.y = this.startY;
        this.endPix.x = this.endX;
        this.endPix.y = this.endY;
        this.coords2d.requestSpaceTop(this.endPix.y - ARROWLENGTH);
        if (this.axes.area == 21 || this.axes.area == 9 || this.axes.area == 6) {
            this.startPix.y += ARROWLENGTH;
            this.coords2d.requestSpaceBottom(this.startPix.y);
        }
    }
}

