/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.base.Scene2D;

class Tick {
    static final int TL_LEFT = 0;
    static final int TL_RIGHT = 1;
    static final int TL_TOP = 2;
    static final int TL_BOTTOM = 3;
    static final int LABEL_CENTER = 0;
    static final int LABEL_MOVEUP = 1;
    static final int LABEL_MOVEDOWN = 2;
    static final int LABEL_MOVERIGHT = 3;
    static final int LABEL_MOVELEFT = 4;
    boolean bigTick;
    Point2D.Double tickpos = new Point2D.Double();
    Point labelpos = new Point();
    int labelPos;
    int pos;
    String label;
    private static final int LENGTHBIGTICK = 6;
    private static final int LENGTHSMALLTICK = 3;
    Axes2D axes;
    private static final int SPACE = 10;

    Tick(int pos, double tickPosX, double tickPosY, boolean bigTick, String label, int labelPos, Axes2D axes) {
        this.pos = pos;
        this.tickpos.x = tickPosX;
        this.tickpos.y = tickPosY;
        this.bigTick = bigTick;
        this.labelPos = labelPos;
        this.label = label;
        this.axes = axes;
    }

    public void compute(Graphics2D g2, Scene2D coords2d) {
        if (!this.bigTick) {
            return;
        }
        int x = coords2d.xToPixel(this.tickpos.x);
        int y = coords2d.yToPixel(this.tickpos.y);
        Font oldFont = g2.getFont();
        if (this.axes.font != null) {
            g2.setFont(this.axes.font);
        }
        FontMetrics metrics = g2.getFontMetrics();
        int length = metrics.stringWidth(this.label);
        int height = metrics.getHeight();
        g2.setFont(oldFont);
        switch (this.pos) {
            case 0: {
                switch (this.labelPos) {
                    case 1: {
                        this.labelpos.y = y - 3;
                        break;
                    }
                    case 2: {
                        this.labelpos.y = y + height / 2 + 3;
                        break;
                    }
                    default: {
                        this.labelpos.y = y + height / 4;
                    }
                }
                this.labelpos.x = x - length - 10;
                coords2d.requestSpaceLeft(this.labelpos.x);
                break;
            }
            case 1: {
                this.labelpos.x = x + 10;
                this.labelpos.y = y + height / 4;
                coords2d.requestSpaceRight(this.labelpos.x + length);
                break;
            }
            case 2: {
                this.labelpos.x = x - length / 2;
                this.labelpos.y = y - 10;
                coords2d.requestSpaceRight(this.labelpos.x + length);
                coords2d.requestSpaceLeft(this.labelpos.x);
                coords2d.requestSpaceTop(this.labelpos.y);
                break;
            }
            case 3: {
                switch (this.labelPos) {
                    case 3: {
                        this.labelpos.x = x + 3;
                        break;
                    }
                    case 4: {
                        this.labelpos.x = x - length - 3;
                        break;
                    }
                    default: {
                        this.labelpos.x = x - length / 2;
                    }
                }
                this.labelpos.y = y + 10 + height / 2;
                coords2d.requestSpaceRight(this.labelpos.x + length);
                coords2d.requestSpaceLeft(this.labelpos.x);
                coords2d.requestSpaceBottom(this.labelpos.y);
            }
        }
    }

    public void drawTick(Graphics2D g2, Scene2D coords2d) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(0.5f));
        int length = this.bigTick ? 6 : 3;
        int x = coords2d.xToPixel(this.tickpos.x);
        int y = coords2d.yToPixel(this.tickpos.y);
        switch (this.pos) {
            case 0: {
                g2.drawLine(x - length, y, x, y);
                break;
            }
            case 1: {
                g2.drawLine(x + length, y, x, y);
                break;
            }
            case 2: {
                g2.drawLine(x, y - length, x, y);
                break;
            }
            case 3: {
                g2.drawLine(x, y + length, x, y);
                break;
            }
        }
        g2.setStroke(oldStroke);
    }

    public void drawLabel(Graphics2D g2) {
        if (!this.bigTick) {
            return;
        }
        Font oldFont = g2.getFont();
        if (this.axes.font != null) {
            g2.setFont(this.axes.font);
        }
        if (this.label != null) {
            g2.drawString(this.label, this.labelpos.x, this.labelpos.y);
        }
        g2.setFont(oldFont);
    }

    public void draw(Graphics2D g2, Scene2D coords2d, boolean drawLabels) {
        this.drawLabel(g2);
        if (drawLabels) {
            this.drawTick(g2, coords2d);
        }
    }
}

