/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.UIManager;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.axes2d.XAxis;
import uibk.mtk.draw2d.axes2d.YAxis;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.PrepaintComputable;
import uibk.mtk.math.Rounder;
import uibk.mtk.text.Formatter;

public class Axes2D
extends Drawable2D
implements PrepaintComputable {
    int style = 1;
    int directionx = 3;
    int directiony = 3;
    public static final int MODE_BOX = 0;
    public static final int MODE_INTELLIGENT = 1;
    Color colorxaxes = Color.black;
    Color coloryaxes = Color.black;
    Stroke strokexaxes = new BasicStroke(1.5f);
    Stroke strokeyaxes = new BasicStroke(1.5f);
    DecimalFormat formatx;
    DecimalFormat formaty;
    public static final int AXES_STYLE_TICKS = 0;
    public static final int AXES_STYLE_TICKS_AND_LABELS = 1;
    public static final int AXES_STYLE_NOTICKS = 2;
    public static final int AXES_STYLE_NOTICKS_AND_LABELS = 3;
    Font font;
    int area;
    private XAxis xaxis = new XAxis(this);
    private YAxis yaxis = new YAxis(this);
    private boolean visibilityXAxis = true;
    private boolean visibilityYAxis = true;
    private int numTicks;
    private Punkt2D pointAxesIntersect;
    private Formatter formatter = new Formatter();
    private Color edgecolor = UIManager.getColor("Panel.background");

    public void setDecimalFormatXAxes(DecimalFormat df) {
        this.formatx = df;
    }

    public void setDecimalFormatYAxes(DecimalFormat df) {
        this.formaty = df;
    }

    public void setCaptionSize(int sizeX, int sizeY) {
        this.xaxis.setCaptionSize(sizeX);
        this.yaxis.setCaptionSize(sizeY);
    }

    public Axes2D() {
        this.setStyleXAxis(1);
        this.setStyleYAxis(1);
        this.numTicks = 11;
    }

    public void setAxesStyle(int style) {
        this.style = style;
    }

    public int getAxesStyle() {
        return this.style;
    }

    public void setVisibilityXAxis(boolean visible) {
        this.visibilityXAxis = visible;
    }

    public void setVisibilityYAxis(boolean visible) {
        this.visibilityYAxis = visible;
    }

    public void setStyleXAxis(int style) {
        this.xaxis.setStyle(style);
    }

    public void setDirectionXAxis(int style) {
        this.directionx = style;
    }

    public void setDirectionYAxis(int style) {
        this.directiony = style;
    }

    public void setStyleYAxis(int style) {
        this.yaxis.setStyle(style);
    }

    public void setNumTicks(int numTicks) {
        this.numTicks = numTicks;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setEdgeColor(Color color) {
        this.edgecolor = color;
    }

    private void colorEdge(Graphics2D g2) {
        g2.setColor(this.edgecolor);
        Insets insets = this.scene2d.getInsets();
        int edge = this.scene2d.getEdge();
        g2.fillRect(0, 0, insets.left + edge, this.panel.getHeight());
        g2.fillRect(0, 0, this.panel.getWidth(), insets.top + edge);
        g2.fillRect(0, this.panel.getHeight() - insets.top - edge, this.panel.getWidth(), insets.top + edge);
        g2.fillRect(this.panel.getWidth() - edge - insets.right, 0, this.panel.getWidth(), this.panel.getHeight());
    }

    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (this.style == 0) {
            this.colorEdge(g2);
        }
        if (this.xAxisVisible()) {
            this.xaxis.draw(g2, this.scene2d);
        }
        if (this.yAxisVisible()) {
            this.yaxis.draw(g2, this.scene2d);
        }
        if (this.style == 0) {
            g2.setColor(Color.black);
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(new BasicStroke(1.5f));
            int xmin = this.scene2d.xToPixel(this.scene2d.getXmin());
            int xmax = this.scene2d.xToPixel(this.scene2d.getXmax());
            int ymin = this.scene2d.yToPixel(this.scene2d.getYmin());
            int ymax = this.scene2d.yToPixel(this.scene2d.getYmax());
            g2.drawLine(xmin, ymin, xmax, ymin);
            g2.drawLine(xmin, ymin, xmin, ymax);
            g2.drawLine(xmax, ymin, xmax, ymax);
            g2.drawLine(xmin, ymax, xmax, ymax);
            g2.setStroke(oldStroke);
        }
    }

    private boolean xAxisVisible() {
        return this.visibilityXAxis;
    }

    private boolean yAxisVisible() {
        return this.visibilityYAxis;
    }

    public void prepaintcompute() {
        double xmax = this.scene2d.getXmax();
        double xmin = this.scene2d.getXmin();
        double ymax = this.scene2d.getYmax();
        double ymin = this.scene2d.getYmin();
        this.pointAxesIntersect = new Punkt2D();
        this.area = this.scene2d.getCoordinates().getArea();
        Punkt2D pointXAxesStart = new Punkt2D();
        Punkt2D pointXAxesEnd = new Punkt2D();
        Punkt2D pointYAxesStart = new Punkt2D();
        Punkt2D pointYAxesEnd = new Punkt2D();
        int tickPosX = 0;
        int tickPosY = 0;
        if (this.style == 0) {
            this.area = 1;
        }
        switch (this.area) {
            case 1: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymin;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymin;
                pointYAxesStart.x = xmin;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmin;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmin;
                this.pointAxesIntersect.y = ymin;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 9: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = 0.0;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = 0.0;
                pointYAxesStart.x = xmin;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmin;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmin;
                this.pointAxesIntersect.y = 0.0;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 8: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymax;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymax;
                pointYAxesStart.x = xmin;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmin;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmin;
                this.pointAxesIntersect.y = ymax;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 3: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymin;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymin;
                pointYAxesStart.x = 0.0;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = 0.0;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = ymin;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 21: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = 0.0;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = 0.0;
                pointYAxesStart.x = 0.0;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = 0.0;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = 0.0;
                tickPosX = 3;
                tickPosY = 0;
                break;
            }
            case 6: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = 0.0;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = 0.0;
                pointYAxesStart.x = xmax;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmax;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmax;
                this.pointAxesIntersect.y = 0.0;
                tickPosX = 3;
                tickPosY = 1;
                break;
            }
            case 2: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymin;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymin;
                pointYAxesStart.x = xmax;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmax;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmax;
                this.pointAxesIntersect.y = ymin;
                tickPosX = 3;
                tickPosY = 1;
                break;
            }
            case 4: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymax;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymax;
                pointYAxesStart.x = xmax;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = xmax;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = xmax;
                this.pointAxesIntersect.y = ymax;
                tickPosX = 2;
                tickPosY = 1;
                break;
            }
            case 18: {
                pointXAxesStart.x = xmin;
                pointXAxesStart.y = ymax;
                pointXAxesEnd.x = xmax;
                pointXAxesEnd.y = ymax;
                pointYAxesStart.x = 0.0;
                pointYAxesStart.y = ymin;
                pointYAxesEnd.x = 0.0;
                pointYAxesEnd.y = ymax;
                this.pointAxesIntersect.x = 0.0;
                this.pointAxesIntersect.y = ymax;
                tickPosX = 2;
                tickPosY = 0;
                break;
            }
        }
        if (!this.xAxisVisible() || !this.yAxisVisible()) {
            this.pointAxesIntersect = null;
        }
        if (this.xAxisVisible()) {
            this.xaxis.compute(pointXAxesStart, pointXAxesEnd, this.pointAxesIntersect, tickPosX, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
        if (this.yAxisVisible()) {
            this.yaxis.compute(pointYAxesStart, pointYAxesEnd, this.pointAxesIntersect, tickPosY, (Graphics2D)this.panel.getGraphics(), this.scene2d);
        }
    }

    public void setCaptionXAxis(String label) {
        this.xaxis.caption = label;
    }

    public void setCaptionYAxis(String label) {
        this.yaxis.caption = label;
    }

    Vector computeTickPositions(double min, double max) {
        Vector<TickPosition> tickPos = new Vector<TickPosition>();
        switch (this.style) {
            case 1: {
                if (max > 0.0 && min < 0.0) {
                    boolean bigTick;
                    tickPos.add(new TickPosition(0.0, true));
                    double maximum = Math.abs(max) >= Math.abs(min) ? Math.abs(max) : Math.abs(min);
                    double step = Rounder.roundDownToLeadingDec(Math.abs(maximum)) / (double)(this.numTicks - 1);
                    int i = 1;
                    double pos = step;
                    while (pos <= max + step / 2.0) {
                        bigTick = i % 5 == 0;
                        tickPos.add(new TickPosition(pos, bigTick));
                        pos = step * (double)(++i);
                    }
                    bigTick = i % 5 == 0;
                    tickPos.add(new TickPosition(max, bigTick));
                    pos = -step;
                    i = 1;
                    while (pos >= min - step / 2.0) {
                        bigTick = i % 5 == 0;
                        tickPos.add(new TickPosition(pos, bigTick));
                        pos = -step * (double)(++i);
                    }
                    bigTick = i % 5 == 0;
                    tickPos.add(new TickPosition(min, bigTick));
                    break;
                }
                if (max > 0.0 && min >= 0.0) {
                    tickPos.add(new TickPosition(min, true));
                    double step = Rounder.roundDownToLeadingDec(Math.abs(max - min)) / (double)(this.numTicks - 1);
                    double pos = min + step;
                    int i = 1;
                    while (pos < max + step / 2.0) {
                        boolean bigTick = i % 5 == 0;
                        tickPos.add(new TickPosition(pos, bigTick));
                        pos = min + step * (double)(++i);
                    }
                } else {
                    double step = Rounder.roundDownToLeadingDec(Math.abs(max - min)) / (double)(this.numTicks - 1);
                    tickPos.add(new TickPosition(max, true));
                    double pos = max - step;
                    int i = 1;
                    while (pos > min - step / 2.0) {
                        boolean bigTick = i % 5 == 0;
                        tickPos.add(new TickPosition(pos, bigTick));
                        pos = max - step * (double)(++i);
                    }
                }
                break;
            }
            case 0: {
                tickPos.add(new TickPosition(min, true));
                double step = (max - min) / (double)(this.numTicks - 1);
                double pos = min + step;
                int i = 1;
                while (pos < max - step / 2.0) {
                    boolean bigTick = i % 5 == 0;
                    tickPos.add(new TickPosition(pos, bigTick));
                    pos = min + step * (double)(++i);
                }
                tickPos.add(new TickPosition(max, true));
                break;
            }
        }
        return tickPos;
    }

    Vector createTicks(Vector tickPositions, int tickDrawPos, double roundingDiff, double axisPos, DecimalFormat format) {
        Vector<Tick> ticks = new Vector<Tick>();
        int i = 0;
        while (i < tickPositions.size()) {
            Tick tick;
            double posy;
            TickPosition t = (TickPosition)tickPositions.elementAt(i);
            double posx = tickDrawPos == 0 || tickDrawPos == 1 ? axisPos : t.position;
            double d = posy = tickDrawPos == 0 || tickDrawPos == 1 ? t.position : axisPos;
            if (t.maintick) {
                boolean add = true;
                int movedir = 0;
                if (this.pointAxesIntersect != null) {
                    if (this.area == 21 && posy == this.pointAxesIntersect.y && posx == this.pointAxesIntersect.x) {
                        add = false;
                    }
                    if ((tickDrawPos == 0 || tickDrawPos == 1) && posy == this.pointAxesIntersect.y) {
                        movedir = this.moveLabel(tickDrawPos);
                    }
                    if ((tickDrawPos == 2 || tickDrawPos == 3) && posx == this.pointAxesIntersect.x) {
                        movedir = this.moveLabel(tickDrawPos);
                    }
                }
                if (add) {
                    if (this.directiony == 2 && (tickDrawPos == 0 || tickDrawPos == 1)) {
                        double d2 = t.position = t.position == 0.0 ? 0.0 : -t.position;
                    }
                    if (this.directionx == 2 && (tickDrawPos == 2 || tickDrawPos == 3)) {
                        t.position = t.position == 0.0 ? 0.0 : -t.position;
                    }
                    String str = format == null ? this.formatter.format(t.position, roundingDiff) : format.format(t.position);
                    tick = new Tick(tickDrawPos, posx, posy, t.maintick, str, movedir, this);
                    ticks.add(tick);
                }
            } else {
                tick = new Tick(tickDrawPos, posx, posy, t.maintick, null, 0, this);
                ticks.add(tick);
            }
            ++i;
        }
        return ticks;
    }

    private int moveLabel(int tickDrawPos) {
        if (this.area == 9 && tickDrawPos == 3) {
            return 3;
        }
        if (this.area == 8 && tickDrawPos == 3) {
            return 3;
        }
        if (this.area == 3 && tickDrawPos == 0) {
            return 1;
        }
        if (this.area == 18 && tickDrawPos == 0) {
            return 2;
        }
        if (this.area == 6 && tickDrawPos == 3) {
            return 4;
        }
        return 0;
    }

    private static class TickPosition {
        double position;
        boolean maintick;

        TickPosition(double position, boolean bigTick) {
            this.position = position;
            this.maintick = bigTick;
        }
    }
}

