/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.anpassungstests;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.doublealgo.Statistic;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import hep.aida.IAxis;
import hep.aida.IHistogram1D;
import hep.aida.bin.DynamicBin1D;
import hep.aida.ref.FixedAxis;
import hep.aida.ref.Histogram1D;
import hep.aida.ref.VariableAxis;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.util.Collections;
import java.util.Vector;
import uibk.applets.anpassungstests.AppletAnpassung;
import uibk.applets.anpassungstests.GraphHighlight;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.GraphSequence;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.lang.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.util.IntervalIterator;
import umontreal.iro.lecuyer.gof.FDist;
import umontreal.iro.lecuyer.gof.GofStat;
import umontreal.iro.lecuyer.probdist.ChiSquareDist;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.ExponentialDist;
import umontreal.iro.lecuyer.probdist.ExtremeValueDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.LognormalDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.probdist.ParetoDist;
import umontreal.iro.lecuyer.probdist.UniformDist;
import umontreal.iro.lecuyer.probdist.WeibullDist;

public class InteractionControl
implements ActionListener,
AdjustmentListener {
    AppletAnpassung main;
    String var;
    DynamicBin1D binAxis;
    ContinuousDistribution distr;
    Vector<Punkt2D> pointsDiscrete = new Vector();
    private double[] valueKS = new double[2];
    private double[] valueChi2 = new double[2];
    private double abstandMax;
    private IHistogram1D histog;
    private FixedAxis axis;
    private double[] param;
    private IHistogram1D histogChi2;
    private VariableAxis axesChi2;
    private Vector<String> paramString = new Vector();
    private int n;

    public InteractionControl(AppletAnpassung main) {
        this.main = main;
    }

    private boolean getVar() throws Exception {
        String str = this.main.panelanpassung.getText().trim();
        if (str == null || str.equals("")) {
            this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.4"), this.main);
            throw new Exception();
        }
        int[] indices = null;
        indices = Misc.parseVarsIndices(",", "x", str);
        if (indices == null || indices.length == 0) {
            this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.4"), this.main);
            throw new Exception();
        }
        if (indices.length > 1) {
            this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.8"), this.main);
            throw new Exception();
        }
        this.main.spalte = indices[0];
        if (this.main.spalte > this.main.table.getColumnCount() - 1 || this.main.spalte == 0) {
            this.main.report.reportError(String.valueOf(Messages.getString("uibk.applets.anpassungstests.messages", "Control.7")) + this.main.spalte, this.main);
            throw new Exception();
        }
        this.var = "x" + this.main.spalte;
        return true;
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("compute")) {
            if (!this.main.ready) {
                this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.19"), this.main);
                return;
            }
            if (this.main.anpassung.length == 0 || this.main.anpassung == null) {
                this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.19"), this.main);
                return;
            }
            try {
                this.getVert();
                int i = 0;
                while (i < this.param.length) {
                    if (Double.isInfinite(this.param[i])) {
                        throw new Exception();
                    }
                    ++i;
                }
            }
            catch (Exception e1) {
                this.main.report.reportWarning(Messages.getString("uibk.applets.anpassungstests.messages", "Control.21"), this.main);
                return;
            }
            this.KSTest();
            try {
                this.Chi2Test();
            }
            catch (Exception e1) {
                this.main.report.reportWarning(Messages.getString("uibk.applets.anpassungstests.messages", "Control.20"), this.main);
            }
            this.compute();
            this.main.panelOutput.createOutput(this.main.panelplot.getDistr(), this.param, this.paramString, this.valueKS, this.valueChi2, this.n);
        }
        if (e.getActionCommand().equals("lade")) {
            try {
                this.getVar();
            }
            catch (Exception e1) {
                return;
            }
            try {
                this.lade();
            }
            catch (IllegalStateException e1) {
            }
            catch (Exception e1) {
                this.main.graphSequence.get(0).clearpoints();
                this.main.graphSequence.get(1).clearpoints();
                this.main.mathpanel[0].repaint();
                this.main.mathpanel[1].repaint();
                this.setSliderEnabled(false);
                return;
            }
            this.setSliderEnabled(true);
            this.main.panelOutput.clear();
            for (GraphHighlight graphs : this.main.graphH) {
                graphs.clearpoints();
            }
            this.main.graphH.clear();
            this.main.mathpanel[2].repaint();
            this.main.mathpanel[3].repaint();
        }
        if (e.getActionCommand().equals("klasse")) {
            this.main.panelanpassung.setValue(Integer.parseInt(this.main.panelanpassung.getTextField()));
            this.main.numClass = Integer.parseInt(this.main.panelanpassung.getTextField());
            try {
                this.lade();
                this.setSliderEnabled(true);
            }
            catch (Exception e1) {
                this.setSliderEnabled(false);
            }
        }
    }

    private void getVert() {
        this.paramString.clear();
        this.param = new double[3];
        switch (this.main.panelplot.getDistr()) {
            case 1: {
                this.distr = NormalDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((NormalDist)this.distr).getMu();
                this.param[1] = ((NormalDist)this.distr).getSigma();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.11"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.6"));
                break;
            }
            case 2: {
                this.distr = WeibullDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((WeibullDist)this.distr).getAlpha();
                this.param[1] = ((WeibullDist)this.distr).getDelta();
                this.param[2] = ((WeibullDist)this.distr).getLambda();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.4"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.10"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.3"));
                break;
            }
            case 3: {
                this.distr = LognormalDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((LognormalDist)this.distr).getMu();
                this.param[1] = ((LognormalDist)this.distr).getSigma();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.11"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.6"));
                break;
            }
            case 4: {
                this.distr = ParetoDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((ParetoDist)this.distr).getAlpha();
                this.param[1] = ((ParetoDist)this.distr).getBeta();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.8"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.9"));
                break;
            }
            case 5: {
                this.distr = ExtremeValueDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((ExtremeValueDist)this.distr).getAlpha();
                this.param[1] = ((ExtremeValueDist)this.distr).getLambda();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.4"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.3"));
                break;
            }
            case 6: {
                this.distr = ChiSquareDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((ChiSquareDist)this.distr).getN();
                this.paramString.add("N");
                break;
            }
            case 7: {
                this.distr = ExponentialDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((ExponentialDist)this.distr).getLambda();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.3"));
                break;
            }
            case 8: {
                this.distr = GammaDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((GammaDist)this.distr).getAlpha();
                this.param[1] = ((GammaDist)this.distr).getLambda();
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.4"));
                this.paramString.add(Messages.getString("uibk.applets.anpassungstests.messages", "Label.3"));
                break;
            }
            case 9: {
                this.distr = UniformDist.getInstanceFromMLE(this.main.anpassung, this.main.anpassung.length);
                this.param[0] = ((UniformDist)this.distr).getA();
                this.param[1] = ((UniformDist)this.distr).getB();
                this.paramString.add("a");
                this.paramString.add("b");
                break;
            }
        }
    }

    private void compute() {
        double min = this.binAxis.min();
        double max = this.binAxis.max();
        Graph2D graphf = new Graph2D();
        IntervalIterator it = new IntervalIterator(min, max, 400);
        while (it.hasNext()) {
            double t = it.nextdouble();
            graphf.addPoint(new Punkt2D(t, this.distr.density(t)));
        }
        graphf.setColor(Colors.getColor(this.main.panelplot.getDistr()));
        Graph2D graphF = new Graph2D();
        it = new IntervalIterator(min, max, 400);
        while (it.hasNext()) {
            double t = it.nextdouble();
            graphF.addPoint(new Punkt2D(t, this.distr.cdf(t)));
        }
        graphF.setColor(Colors.getColor(this.main.panelplot.getDistr()));
        GraphHighlight graphHigh = new GraphHighlight(graphf, Messages.getString("uibk.applets.anpassungstests.messages", "PanelPlot." + Integer.toString(this.main.panelplot.getDistr())));
        graphHigh.setHighlightradius(2);
        this.main.graphH.add(graphHigh);
        this.main.mathpanel[2].add(graphHigh);
        graphHigh = new GraphHighlight(graphF, Messages.getString("uibk.applets.anpassungstests.messages", "PanelPlot." + Integer.toString(this.main.panelplot.getDistr())));
        graphHigh.setHighlightradius(2);
        this.main.graphH.add(graphHigh);
        this.main.mathpanel[3].add(graphHigh);
        if (this.main.graphH.size() == 2) {
            this.main.mathpanel[2].getScene2d().setLimits(graphf.getLimits());
            this.main.mathpanel[3].getScene2d().setLimits(graphF.getLimits());
        } else {
            this.main.mathpanel[2].getScene2d().ensureLimits(graphf.getLimits());
            this.main.mathpanel[3].getScene2d().ensureLimits(graphF.getLimits());
        }
        this.main.mathpanel[2].repaint();
        this.main.mathpanel[3].repaint();
    }

    private void lade() throws Exception {
        if (this.main.spalte == 0) {
            return;
        }
        this.pointsDiscrete = new Vector();
        if (this.main.table.isEmpty()) {
            this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.13"), this.main);
            throw new Exception();
        }
        this.main.ready = true;
        this.main.anpassung = this.main.table.getDataCol(this.main.spalte);
        if (this.main.anpassung.length == 0) {
            this.main.report.reportError(Messages.getString("uibk.applets.anpassungstests.messages", "Control.14"), this.main);
            throw new Exception();
        }
        this.binAxis = new DynamicBin1D();
        this.binAxis.addAllOf(new DoubleArrayList(this.main.anpassung));
        this.axis = new FixedAxis(this.main.numClass, this.binAxis.min(), this.binAxis.max() + 1.0);
        Histogram1D histo = new Histogram1D("title", this.axis);
        this.histog = Statistic.histogram(histo, new DenseDoubleMatrix1D(this.main.anpassung));
        int i = 0;
        while (i < this.main.numClass) {
            this.pointsDiscrete.add(new Punkt2D(this.axis.binCentre(i), this.histog.binHeight(i)));
            ++i;
        }
        i = 0;
        while (i < 2) {
            this.setGraphSequence(i, this.axis);
            ++i;
        }
    }

    private void setGraphSequence(int i, IAxis axis) {
        GraphSequence graph = this.main.graphSequence.get(i);
        Scene2D scene = this.main.mathpanel[i].getScene2d();
        graph.clearpoints();
        graph.setPoints(this.pointsDiscrete);
        if (i == 1 || i == 3) {
            scene.setLimits(axis.lowerEdge(), axis.upperEdge(), 0.0, 1.0);
        } else {
            scene.setLimits(axis.lowerEdge(), axis.upperEdge(), 0.0, graph.getLimits().ymax);
        }
        graph.setMinX(axis.lowerEdge());
        graph.setMaxX(axis.upperEdge());
        graph.setVisible(i <= 1);
        this.main.mathpanel[i].repaint();
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        this.main.panelanpassung.setTextField("" + this.main.panelanpassung.getValue());
        this.main.numClass = this.main.panelanpassung.getValue();
        try {
            this.lade();
            this.setSliderEnabled(true);
        }
        catch (Exception e1) {
            this.setSliderEnabled(false);
        }
    }

    private void setSliderEnabled(boolean b) {
        this.main.panelanpassung.setSliderEnabled(b);
    }

    private void KSTest() {
        this.abstandMax = 0.0;
        double cdF = 0.0;
        Vector<Double> anpassung = new Vector<Double>();
        int i = 0;
        while (i < this.main.anpassung.length) {
            anpassung.add(new Double(this.main.anpassung[i]));
            ++i;
        }
        Collections.sort(anpassung);
        double N = this.main.anpassung.length;
        int i2 = 0;
        while ((double)i2 < N) {
            double I = i2;
            cdF = this.distr.cdf((Double)anpassung.get(i2));
            this.abstandMax = Math.max(this.abstandMax, Math.abs(cdF - I / N));
            this.abstandMax = Math.max(this.abstandMax, Math.abs(cdF - (I + 1.0) / N));
            ++i2;
        }
        this.valueKS[0] = this.abstandMax;
        this.valueKS[1] = 1.0 - FDist.kolmogorovSmirnov(this.main.anpassung.length, this.abstandMax);
    }

    private void Chi2Test() throws Exception {
        double[] entries = new double[this.histog.xAxis().bins()];
        int i = 0;
        while (i < entries.length) {
            entries[i] = this.histog.binHeight(i);
            ++i;
        }
        GofStat.OutcomeCategoriesChi2 regroup = new GofStat.OutcomeCategoriesChi2(entries);
        try {
            regroup.regroupCategories(4.0);
        }
        catch (Exception exception) {
            // empty catch block
        }
        int k = 0;
        double[] edges = new double[regroup.nbCategories + 1];
        edges[0] = this.axis.binLowerEdge(regroup.smin);
        int i2 = 0;
        while (i2 < regroup.loc.length) {
            if (regroup.loc[i2] == i2) {
                edges[++k] = this.axis.binUpperEdge(i2);
            } else if (regroup.loc[i2] < i2) {
                edges[k] = this.axis.binUpperEdge(i2);
            }
            ++i2;
        }
        if (k - this.param.length - 2 < 1) {
            edges = new double[3 + this.param.length];
            edges[0] = this.axis.binLowerEdge(regroup.smin);
            Vector<Double> data = new Vector<Double>();
            int i3 = 0;
            while (i3 < this.main.anpassung.length) {
                data.add(new Double(this.main.anpassung[i3]));
                ++i3;
            }
            Collections.sort(data);
            i3 = 1;
            while (i3 < 2 + this.param.length) {
                edges[i3] = ((Double)data.get(Math.round(i3 * data.size() / (2 + this.param.length))) + (Double)data.get(Math.round(1 + i3 * data.size() / (2 + this.param.length)))) / 2.0;
                ++i3;
            }
            edges[2 + this.param.length] = (Double)data.lastElement() + 1.0;
        }
        this.axesChi2 = new VariableAxis(edges);
        this.histogChi2 = Statistic.histogram(new Histogram1D("title", this.axesChi2), new DenseDoubleMatrix1D(this.main.anpassung));
        double[] expObs = new double[this.histogChi2.xAxis().bins()];
        int[] obs = new int[expObs.length];
        int N = this.main.anpassung.length;
        int i4 = 0;
        while (i4 < expObs.length) {
            expObs[i4] = (this.distr.cdf(this.axesChi2.binUpperEdge(i4)) - this.distr.cdf(this.axesChi2.binLowerEdge(i4))) * (double)N;
            obs[i4] = this.histogChi2.binEntries(i4);
            ++i4;
        }
        this.n = this.histogChi2.xAxis().bins() - 1 - this.paramString.size();
        this.valueChi2[0] = GofStat.chi2(expObs, obs, 0, this.n);
        this.valueChi2[1] = 1.0 - ChiSquareDist.cdf(this.n, 100, this.valueChi2[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Colors {
        Blau("#00", "#33", "#99"),
        Rot("#ff", "#01", "#01"),
        Dunkelgruen("#01", "#95", "#84"),
        Dunkelblau("#01", "#63", "#84"),
        Rosa("#ff", "#01", "#84"),
        Magenta("#ff", "#01", "#ff"),
        Violett("#95", "#01", "#8c"),
        DarkBlau("#01", "#01", "#8c"),
        Braun("#84", "#95", "#7c"),
        Grau("#ad", "#74", "#84");

        private Color value = Color.BLACK;

        private Colors(String i, String j, String k) {
            this.value = new Color(Integer.decode(i), Integer.decode(j), Integer.decode(k));
        }

        public static Color getColor(int i) {
            int j = 0;
            while (j < Colors.values().length) {
                if (Colors.values()[i].ordinal() == i) {
                    return Colors.values()[i].value;
                }
                ++j;
            }
            return Color.BLACK;
        }
    }
}

