/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.anpassungstests;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.geom.geom2d.Punkt2D;
import uibk.mtk.geom.util.GeomUtil;
import uibk.mtk.lang.Highlightable;
import uibk.mtk.lang.ToolTipable;

public class GraphHighlight
extends Graph2D
implements Highlightable,
ToolTipable {
    private Color highColor = Color.RED;
    private int highlightradius;
    private String title;
    private boolean toolTip = true;

    public GraphHighlight(Graph2D src, String title) {
        this.points = src.getPoints();
        this.color = src.getColor();
        this.title = title;
    }

    public void highlight(BufferedImage framebuffer, Graphics2D g2) {
        BasicStroke stroke = new BasicStroke(4.0f);
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(stroke);
        g2.setColor(this.highColor);
        int i = 0;
        while (i < this.points.size() - 1) {
            Punkt2D start = (Punkt2D)this.points.elementAt(i);
            Punkt2D end = (Punkt2D)this.points.elementAt(i + 1);
            if (start != null && end != null) {
                int startx = this.scene2d.xToPixel(start.x);
                int starty = this.scene2d.yToPixel(start.y);
                int endx = this.scene2d.xToPixel(end.x);
                int endy = this.scene2d.yToPixel(end.y);
                g2.drawLine(startx, starty, endx, endy);
            }
            ++i;
        }
        g2.setStroke(oldStroke);
        this.draw(framebuffer, g2);
    }

    public boolean highlightcontains(int x, int y) {
        int i = 0;
        while (i < this.points.size() - 1) {
            double p2y;
            double p2x;
            double p1y;
            Punkt2D p1 = (Punkt2D)this.points.get(i);
            Punkt2D p2 = (Punkt2D)this.points.get(i + 1);
            double p1x = this.scene2d.xToPixel(p1.x);
            double distquad = GeomUtil.distPointLine(x, y, p1x, p1y = (double)this.scene2d.yToPixel(p1.y), p2x = (double)this.scene2d.xToPixel(p2.x), p2y = (double)this.scene2d.yToPixel(p2.y));
            if (distquad <= (double)(this.highlightradius * this.highlightradius)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setHighLightColor(Color color) {
        this.highColor = color;
    }

    public Color getHighLightColor() {
        return this.highColor;
    }

    public int getHighlightradius() {
        return this.highlightradius;
    }

    public void setHighlightradius(int highlightradius) {
        this.highlightradius = highlightradius;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void enableToolTip(boolean b) {
        this.toolTip = b;
    }

    public String getToolTipText(MouseEvent ev) {
        return this.title;
    }

    public boolean isToolTipEnabled() {
        return this.toolTip;
    }

    public void setToolTipText(String tip) {
        this.title = tip;
    }

    public boolean tooltipcontains(int x, int y) {
        return this.highlightcontains(x, y);
    }
}

