/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math;

import java.util.Hashtable;
import java.util.Vector;
import uibk.mtk.lang.ComputationException;
import uibk.mtk.lang.InputException;
import uibk.mtk.math.Messages;
import uibk.mtk.parser.realparser.Expr;
import uibk.mtk.parser.realparser.Variable;

public class Sequence {
    Hashtable variables = new Hashtable();
    private double[] initial;
    Expr formula;
    int startindex;
    int endindex;
    int maxlengthsequence = 1000;
    public static final int RECURSIVE = 0;
    public static final int EXPLICIT = 1;
    private Vector rekindices;
    private int sequencedepth;

    public Sequence(Hashtable variables, Expr formula, Vector rekindices, int depth) {
        this.variables = variables;
        this.formula = formula;
        this.sequencedepth = depth;
        this.rekindices = rekindices;
    }

    public void setMaxSequenceLength(int maxlength) {
        this.maxlengthsequence = maxlength;
    }

    public void setInitialValues(double[] initialvalues) {
        this.initial = initialvalues;
    }

    public int getStartIndex() {
        return this.startindex;
    }

    public int getEndIndex() {
        return this.endindex;
    }

    private void check() throws Exception {
        if (this.variables == null || this.formula == null) {
            throw new InputException(Messages.getString("Sequence.0"));
        }
        if (this.endindex < 0) {
            throw new InputException(Messages.getString("Sequence.1"));
        }
        if (this.startindex < 0) {
            throw new InputException(Messages.getString("Sequence.2"));
        }
        if (this.endindex < this.startindex) {
            throw new Exception(Messages.getString("Sequence.3"));
        }
        if (this.getType() == 0) {
            if (this.initial == null) {
                throw new InputException(Messages.getString("Sequence.4"));
            }
            if (this.initial.length < this.sequencedepth && this.sequencedepth > 1) {
                throw new InputException(String.valueOf(Messages.getString("Sequence.5")) + String.valueOf(this.sequencedepth) + Messages.getString("Sequence.6"));
            }
            if (this.initial.length > this.sequencedepth) {
                if (this.sequencedepth > 1) {
                    throw new InputException(String.valueOf(Messages.getString("Sequence.7")) + String.valueOf(this.sequencedepth) + Messages.getString("Sequence.8"));
                }
                throw new InputException(Messages.getString("Sequence.9"));
            }
        } else if (this.initial != null) {
            throw new InputException(Messages.getString("Sequence.10"));
        }
    }

    public String getFormula() {
        return this.formula.toString();
    }

    public double[] compute(double[] initials, int startindex, int endindex) throws Exception {
        int i;
        int pos;
        this.initial = initials;
        this.startindex = startindex;
        this.endindex = endindex;
        this.check();
        double[] sequence = null;
        if (this.sequencedepth > 0) {
            if (endindex > this.maxlengthsequence) {
                throw new Exception(String.valueOf(Messages.getString("Sequence.11")) + this.maxlengthsequence);
            }
            if (endindex < this.sequencedepth) {
                sequence = new double[endindex + 1];
                int i2 = 0;
                while (i2 < endindex + 1) {
                    sequence[i2] = this.initial[i2];
                    ++i2;
                }
                return sequence;
            }
            pos = this.sequencedepth;
            sequence = new double[endindex + 1];
            i = 0;
            while (i < pos) {
                sequence[i] = this.initial[i];
                ++i;
            }
            while (pos < endindex + 1) {
                ((Variable)this.variables.get("n")).setValue(pos);
                i = 0;
                while (i < this.rekindices.size()) {
                    String varName = "a(n-" + String.valueOf(this.rekindices.elementAt(i)) + ")";
                    Variable v = (Variable)this.variables.get(varName);
                    Integer k = (Integer)this.rekindices.elementAt(i);
                    double a = sequence[pos - k];
                    v.setValue(a);
                    ++i;
                }
                sequence[pos] = this.formula.value();
                ++pos;
            }
        } else {
            if (endindex - startindex > this.maxlengthsequence) {
                throw new Exception(String.valueOf(Messages.getString("Sequence.15")) + this.maxlengthsequence);
            }
            sequence = new double[endindex - startindex + 1];
            pos = 0;
            while (pos < endindex - startindex + 1) {
                ((Variable)this.variables.get("n")).setValue(pos + startindex);
                sequence[pos] = this.formula.value();
                ++pos;
            }
        }
        int i3 = 0;
        while (i3 < sequence.length) {
            if (Double.isInfinite(sequence[i3])) {
                throw new ComputationException(String.valueOf(Messages.getString("Sequence.17")) + Messages.getString("Sequence.18"));
            }
            if (Double.isNaN(sequence[i3])) {
                throw new ComputationException(Messages.getString("Sequence.19"));
            }
            ++i3;
        }
        if (this.sequencedepth > 0) {
            double[] vals = new double[endindex - startindex + 1];
            i = startindex;
            while (i <= endindex) {
                vals[i - startindex] = sequence[i];
                ++i;
            }
            return vals;
        }
        return sequence;
    }

    public int getType() {
        return this.sequencedepth > 0 ? 0 : 1;
    }
}

