/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.swing.appletbase;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JToolBar;
import uibk.mtk.swing.appletbase.AppletBase;
import uibk.mtk.swing.appletbase.Messages;
import uibk.mtk.swing.base.ButtonNoFocus;

class NavigationBar
extends JToolBar
implements ActionListener {
    protected ButtonNoFocus buttonInfo;
    protected ButtonNoFocus buttonHome;
    protected ButtonNoFocus buttonHelp;
    AppletBase applet;
    JLabel labelReport;
    protected String strcopyright = Messages.getString("Copyright");
    protected String strauthor = Messages.getString("Autor");
    private String labelinfo = Messages.getString("Info");
    private String labelhome = Messages.getString("Home");
    private String labelhelp = Messages.getString("Help");
    private String labeltheory = Messages.getString("Theory");

    public NavigationBar(AppletBase applet, String info, String home, String help, String theory) {
        this.labelinfo = info;
        this.labelhelp = help;
        this.labeltheory = theory;
        this.labelhome = home;
        this.applet = applet;
        this.initComponents();
    }

    public NavigationBar(AppletBase applet) {
        this.applet = applet;
        this.initComponents();
    }

    ButtonNoFocus createButton(String stringurl, String text, String tooltip, String actioncommand) {
        URL url = this.getClass().getResource(stringurl);
        ButtonNoFocus button = new ButtonNoFocus(text, new ImageIcon(url));
        if (text != null && !text.equals("")) {
            button.setVerticalTextPosition(3);
            button.setHorizontalTextPosition(0);
            button.setFont(new Font("Arial", 0, 10));
        }
        button.setToolTipText(tooltip);
        button.setActionCommand(actioncommand);
        button.addActionListener(this);
        return button;
    }

    private void initComponents() {
        this.setFloatable(false);
        this.setLayout(new FlowLayout(2, 20, 2));
        this.setMinimumSize(new Dimension(400, 150));
        this.setBorder(BorderFactory.createLineBorder(Color.black));
        this.buttonHome = this.createButton("house.gif", this.labelhome, Messages.getString("Homepage"), "home");
        this.buttonHelp = this.createButton("help.gif", this.labelhelp, Messages.getString("Help"), "help");
        this.add(this.buttonHelp);
        this.add(this.buttonHome);
    }

    public void setReportingLabel(JLabel label) {
        this.labelReport = label;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("info")) {
            if (this.labelReport != null) {
                this.labelReport.setForeground(Color.black);
                this.labelReport.setText(this.strcopyright);
            }
            System.out.println(this.strcopyright);
            System.out.println(this.strauthor);
        }
        if (ev.getActionCommand().equals("home")) {
            try {
                this.applet.getAppletContext().showDocument(new URL(this.applet.getDocumentBase(), "../" + Messages.getHomepage()), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (ev.getActionCommand().equals("help")) {
            try {
                this.applet.getAppletContext().showDocument(new URL(this.applet.getDocumentBase(), String.valueOf(Messages.getHomepage()) + "#help"), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (ev.getActionCommand().equals("theory")) {
            try {
                this.applet.getAppletContext().showDocument(new URL(this.applet.getDocumentBase(), String.valueOf(Messages.getHomepage()) + "#theory"), "_blank");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public void enableInternetButtons(boolean enable) {
        this.buttonHelp.setVisible(enable);
        this.buttonHome.setVisible(enable);
    }

    public void setTextHelp(String text) {
        this.buttonHelp.setText(text);
        this.buttonHelp.setToolTipText(text);
    }

    public void setTextInfo(String text) {
        this.buttonInfo.setText(text);
        this.buttonInfo.setToolTipText(text);
    }

    public void setTextTheory(String text) {
    }

    public void setTextHome(String text) {
        this.buttonHome.setText(text);
        this.buttonHome.setToolTipText(text);
    }

    public void setTextCopyright(String text) {
        this.strcopyright = text;
    }
}

