/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.util;

import java.util.Vector;
import uibk.mtk.draw2d.util.Messages;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.geom.Punkt3D;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.math.functions.ParametricCurve2D;
import uibk.mtk.math.functions.ParametricCurve3D;
import uibk.mtk.util.IntervalIterator;

public final class GraphUtil {
    private GraphUtil() {
    }

    public static Vector compute(ParametricCurve2D curve2d, double paramstart, double paramend, int n) throws Exception {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        IntervalIterator it = new IntervalIterator(paramstart, paramend, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            Punkt2D p = curve2d.calcPoint(t);
            if (!p.isReal()) {
                throw new Exception(Messages.getString("DivsionByZeroOverflow"));
            }
            points.add(p);
        }
        return points;
    }

    public static Vector compute(ParametricCurve3D curve3d, double paramstart, double paramend, int n) throws Exception {
        Vector<Punkt3D> points = new Vector<Punkt3D>();
        IntervalIterator it = new IntervalIterator(paramstart, paramend, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            Punkt3D p = curve3d.calcPoint(t);
            if (!p.isReal()) {
                throw new Exception(Messages.getString("1"));
            }
            points.add(p);
        }
        return points;
    }

    public static Vector compute(Function1D function, double xstart, double xend, int n) throws Exception {
        Vector<Punkt2D> points = new Vector<Punkt2D>();
        IntervalIterator it = new IntervalIterator(xstart, xend, n);
        while (it.hasNext()) {
            double t = it.nextdouble();
            double y = function.getValue(t);
            if (Double.isNaN(y) || Double.isInfinite(y)) {
                throw new Exception(Messages.getString("2"));
            }
            points.add(new Punkt2D(t, y));
        }
        return points;
    }
}

