/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.lang.ToolTipable;

public class MathPoint2D
extends Drawable2D
implements ToolTipable {
    protected double x;
    protected double y;
    protected int radius = 1;
    protected boolean tooltipenabled = false;
    protected String toolTip = null;

    public MathPoint2D() {
    }

    public MathPoint2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setCoordinates(double x, double y) {
        this.x = x;
        this.y = y;
    }

    @Override
    public void setToolTipText(String tooltip) {
        this.toolTip = tooltip;
    }

    public void setCoordinates(Punkt2D p) {
        this.x = p.x;
        this.y = p.y;
    }

    @Override
    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    @Override
    public void enableToolTip(boolean b) {
        this.tooltipenabled = b;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    @Override
    public boolean tooltipcontains(int xm, int ym) {
        int yp;
        int xp = this.scene2d.xToPixel(this.x);
        return (xm - xp) * (xm - xp) + (ym - (yp = this.scene2d.yToPixel(this.y))) * (ym - yp) <= this.radius * this.radius;
    }

    public Punkt2D getPunkt2D() {
        return new Punkt2D(this.x, this.y);
    }

    @Override
    public String getToolTipText(MouseEvent ev) {
        if (this.toolTip == null) {
            String str = "(" + String.valueOf(this.x) + "," + String.valueOf(this.y) + ")";
            return str;
        }
        return this.toolTip;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        g2.fillOval(this.scene2d.xToPixel(this.x) - this.radius, this.scene2d.yToPixel(this.y) - this.radius, 2 * this.radius + 1, 2 * this.radius + 1);
    }
}

