/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.GeomUtil;
import uibk.mtk.geom.Punkt2D;

public class Graph2D
extends Drawable2D {
    protected Stroke stroke;
    protected Vector points = new Vector();
    protected CoordinateRect2D limits = new CoordinateRect2D();
    protected boolean limitsdirty = true;

    public Graph2D() {
        this.color = Color.red;
        this.stroke = new BasicStroke();
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }

    public void setPoints(Vector points) {
        this.points = points;
        this.limitsdirty = true;
    }

    public void addPoint(Punkt2D p) {
        this.points.add(p);
        this.limitsdirty = true;
    }

    public void addPoint(double x, double y) {
        this.points.add(new Punkt2D(x, y));
        this.limitsdirty = true;
    }

    protected void recalcLimits() {
        this.limits = this.points != null && this.points.size() > 0 ? GeomUtil.getLimits2D(this.points) : new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public void clearpoints() {
        this.points.clear();
        this.limits = new CoordinateRect2D(-1.0, 1.0, -1.0, 1.0);
    }

    public Vector getPoints() {
        return this.points;
    }

    public int getNumberPoints() {
        return this.points.size();
    }

    public CoordinateRect2D getLimits() {
        if (this.limitsdirty) {
            this.recalcLimits();
        }
        return (CoordinateRect2D)this.limits.clone();
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(this.stroke);
        g2.setColor(this.color);
        int i = 0;
        while (i < this.points.size() - 1) {
            Punkt2D start = (Punkt2D)this.points.elementAt(i);
            Punkt2D end = (Punkt2D)this.points.elementAt(i + 1);
            if (start != null && end != null) {
                int startx = this.scene2d.xToPixel(start.x);
                int starty = this.scene2d.yToPixel(start.y);
                int endx = this.scene2d.xToPixel(end.x);
                int endy = this.scene2d.yToPixel(end.y);
                g2.setColor(this.color);
                g2.drawLine(startx, starty, endx, endy);
            }
            ++i;
        }
        g2.setStroke(oldStroke);
    }
}

