/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.draw2d.axes2d;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Vector;
import uibk.mtk.draw2d.axes2d.Axes2D;
import uibk.mtk.draw2d.axes2d.Axis;
import uibk.mtk.draw2d.axes2d.Tick;
import uibk.mtk.draw2d.base.Scene2D;
import uibk.mtk.geom.Punkt2D;

class XAxis
extends Axis {
    XAxis(Axes2D axes) {
        super(axes);
    }

    @Override
    void compute(Punkt2D start, Punkt2D end, Punkt2D axisIntersection, int tickAndLabelPos, Graphics2D g2, Scene2D scene2d) {
        if (this.style != 2) {
            Vector tickPositions = this.axes.computeTickPositions(start.x, end.x);
            if (tickPositions != null && tickPositions.size() > 0) {
                this.ticks = this.axes.createTicks(tickPositions, tickAndLabelPos, scene2d.getXPixelScale() / 10.0, start.y, this.axes.formatx);
            }
            if (this.ticks != null) {
                int i = 0;
                while (i < this.ticks.size()) {
                    ((Tick)this.ticks.elementAt(i)).compute(g2, scene2d);
                    ++i;
                }
            }
        }
        int startX = scene2d.xToPixel(start.x);
        int startY = scene2d.yToPixel(start.y);
        int endX = scene2d.xToPixel(end.x);
        int endY = scene2d.yToPixel(end.y);
        if (axisIntersection != null && Math.abs(start.x - axisIntersection.x) > Math.abs(end.x - axisIntersection.x)) {
            this.startPix.x = endX;
            this.startPix.y = endY;
            this.endPix.x = startX;
            this.endPix.y = startY;
            scene2d.requestSpaceLeft(this.endPix.x - ARROWLENGTH);
            if (this.axes.area == 3 || this.axes.area == 18 || this.axes.area == 21) {
                this.startPix.x += ARROWLENGTH;
                scene2d.requestSpaceRight(this.startPix.x);
            }
        } else {
            this.startPix.x = startX;
            this.startPix.y = startY;
            this.endPix.x = endX;
            this.endPix.y = endY;
            scene2d.requestSpaceRight(this.endPix.x + ARROWLENGTH);
            if (this.axes.area == 3 || this.axes.area == 18 || this.axes.area == 21) {
                this.startPix.x -= ARROWLENGTH;
                scene2d.requestSpaceLeft(this.startPix.x);
            }
        }
        FontMetrics metrics = g2.getFontMetrics();
        int length = metrics.stringWidth(this.caption);
        int height = metrics.getHeight();
        this.captionpos.x = this.endPix.x - length / 2;
        this.captionpos.y = tickAndLabelPos == 3 ? this.endPix.y - 4 : this.endPix.y + 4 + height / 2;
        scene2d.requestSpaceTop(this.startPix.y - OFFSETWINGS);
        scene2d.requestSpaceBottom(this.startPix.y + OFFSETWINGS);
    }

    @Override
    void draw(Graphics2D g2, Scene2D coords2d) {
        g2.setColor(this.axes.colorxaxes);
        if (this.axes.style == 1) {
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(this.axes.strokexaxes);
            if (this.startPix.x < this.endPix.x) {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 0);
            } else {
                this.drawArrow(g2, this.endPix.x, this.endPix.y, 1);
            }
            g2.drawLine(this.startPix.x, this.startPix.y, this.endPix.x, this.endPix.y);
            g2.setStroke(oldStroke);
        }
        if (this.ticks != null && this.style != 2) {
            boolean drawLabels = this.style == 1;
            int i = 0;
            while (i < this.ticks.size()) {
                ((Tick)this.ticks.elementAt(i)).draw(g2, coords2d, drawLabels);
                ++i;
            }
        }
        if (this.style == 1 && this.caption != null && !this.caption.equals("") && this.axes.style != 0) {
            g2.drawString(this.caption, this.captionpos.x, this.captionpos.y);
        }
    }
}

