/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.riemann;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import uibk.applets.riemann.AppletRiemann;
import uibk.applets.riemann.Messages;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.math.integration.GaussIntegration;
import uibk.mtk.swing.PanelFunction1D;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelIntegrationControl
extends JPanel
implements ActionListener {
    AppletRiemann main;
    PanelFunction1D panelfunction;
    IntegerTextField textsize;

    public PanelIntegrationControl(AppletRiemann main) {
        this.main = main;
        this.initComponents();
    }

    void createPanelFunction() {
        this.panelfunction = new PanelFunction1D('x');
    }

    public void compute() {
        if (this.panelfunction.getIntervalField().hasChanged() || this.panelfunction.getFunctionField().hasChanged()) {
            try {
                Function1D f = this.panelfunction.getFunction();
                Interval interval = this.panelfunction.getInterval();
                this.main.riemannvis.setFunction(f);
                this.main.riemannvis.setInterval(interval);
                GaussIntegration integrator = new GaussIntegration();
                int s = 5;
                int k = 30;
                double sum = integrator.quadrature(f, interval.a, interval.b, s, k);
                this.main.paneloutput.setExactValue(sum);
            }
            catch (Exception e) {
                this.main.mathpanel2d.reportError(e);
                return;
            }
        }
        try {
            int n = this.textsize.getValue();
            this.main.riemannvis.setNumberSubDivisions(n);
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return;
        }
        try {
            this.main.riemannvis.create();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
        }
        this.main.riemannvis.setVisible(true);
        CoordinateRect2D limits = this.main.riemannvis.getLimits();
        this.main.mathpanel2d.getScene2d().setLimits(limits);
        this.main.paneloutput.createOutput(this.main.riemannvis);
        this.main.mathpanel2d.report(Messages.getString("PanelIntegrationControl.0"));
        this.main.mathpanel2d.repaint();
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.createPanelFunction();
        this.add(this.panelfunction);
        this.add(this.createPanelControl());
    }

    MPanel createPanelControl() {
        TitledPanel panel = new TitledPanel(Messages.getString("PanelIntegrationControl.1"));
        panel.setLayout(new GridBagLayout());
        panel.setMaximumSize(new Dimension(2000, 200));
        this.textsize = new IntegerTextField(10, new Integer(1), new Integer(500), Messages.getString("PanelIntegrationControl.2"));
        this.textsize.setActionCommand("textfield");
        this.textsize.addActionListener(this);
        this.textsize.setText(String.valueOf(5));
        JButton buttonintegrate = new JButton(Messages.getString("PanelIntegrationControl.4"));
        buttonintegrate.setActionCommand("compute");
        buttonintegrate.addActionListener(this);
        panel.add((Component)new JLabel(Messages.getString("PanelIntegrationControl.6")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)this.textsize, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        panel.add((Component)buttonintegrate, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0));
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("compute")) {
            this.compute();
        }
        if (ev.getActionCommand().equals("textfield")) {
            this.compute();
        }
    }
}

