/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.intermediatevalue;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Timer;
import uibk.applets.intermediatevalue.Messages;
import uibk.mtk.draw2d.base.Drawable2D;
import uibk.mtk.draw2d.base.MathPanel2D;
import uibk.mtk.draw2d.objects.Graph2D;
import uibk.mtk.draw2d.objects.MathPoint2D;
import uibk.mtk.draw2d.util.GraphUtil;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.geom.Punkt2D;
import uibk.mtk.math.BisectionMethod;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.Function1D;

public class ZWAnimation
extends Drawable2D {
    boolean paused = false;
    static final int INFINITE_ANIM_PAUSE = 1000;
    boolean endless = false;
    Timer timer;
    Function1D function;
    private double x;
    private double left;
    private double right;
    private double offleft;
    private double offright;
    private MathPoint2D point = new MathPoint2D();
    static final int NUMBEROFPOINTS = 140;
    Interval interval;
    private boolean restarted = false;
    Graph2D graphleft = new Graph2D();
    Graph2D graphright = new Graph2D();
    BisectionMethod bisection = new BisectionMethod();
    ActionListener onEndAction;
    boolean ready = false;
    private Action updateTimerAction = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            ZWAnimation.this.next();
            ZWAnimation.this.panel.repaint();
        }
    };

    public ZWAnimation(int delay) {
        this.timer = new Timer(delay, this.updateTimerAction);
        this.point.setColor(Color.blue);
        this.point.setRadius(2);
        this.point.setVisible(false);
    }

    public void enableendless(boolean b) {
        this.endless = b;
    }

    public boolean isRunning() {
        return this.timer.isRunning();
    }

    void create(Function1D f, Interval interval) throws Exception {
        this.ready = false;
        this.function = f;
        this.interval = interval;
        this.graphleft.clearpoints();
        this.graphright.clearpoints();
        this.point.setVisible(false);
        this.bisection.setInterval(interval);
        this.bisection.setFunction(f);
        this.x = this.bisection.compute();
        this.point.setX(this.x);
        this.point.setY(0.0);
        Vector points = GraphUtil.compute(this.function, interval.a, interval.b, 140);
        Graph2D temp = new Graph2D();
        temp.setPoints(points);
        CoordinateRect2D limits = temp.getLimits();
        this.scene2d.setLimits(new CoordinateRect2D(interval.a, interval.b, limits.ymin, limits.ymax));
        this.left = interval.a;
        this.right = interval.b;
        this.offleft = (this.x - this.left) / 140.0;
        this.offright = (this.right - this.x) / 140.0;
        if (1.0 + this.offleft == 1.0 || 1.0 + this.offright == 1.0) {
            throw new Exception(Messages.getString("ZWAnimation.0"));
        }
        this.ready = true;
    }

    public void setOnEndAction(ActionListener action) {
        this.onEndAction = action;
    }

    private void next() {
        if (this.restarted) {
            this.graphleft.clearpoints();
            this.graphright.clearpoints();
            this.point.setVisible(false);
            this.restarted = false;
        }
        this.right -= this.offright;
        this.left += this.offleft;
        if (this.left <= this.x + this.offleft / 2.0) {
            this.graphleft.addPoint(new Punkt2D(this.left, this.function.getValue(this.left)));
        }
        if (this.right >= this.x - this.offright / 2.0) {
            this.graphright.addPoint(new Punkt2D(this.right, this.function.getValue(this.right)));
        }
        if (this.left > this.x && this.right < this.x) {
            this.point.setVisible(true);
            this.timer.stop();
            this.paused = false;
            if (this.endless) {
                this.left = this.interval.a;
                this.right = this.interval.b;
                this.timer.setInitialDelay(1000);
                this.restarted = true;
                this.timer.start();
            } else if (this.onEndAction != null) {
                this.onEndAction.actionPerformed(new ActionEvent(this, 0, "Ende"));
            }
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        this.graphleft.draw(framebuffer, g2);
        this.graphright.draw(framebuffer, g2);
        if (this.point.isVisible()) {
            this.point.draw(framebuffer, g2);
        }
    }

    @Override
    public void setMathPanel2D(MathPanel2D panel) {
        super.setMathPanel2D(panel);
        this.graphright.setMathPanel2D(panel);
        this.graphleft.setMathPanel2D(panel);
        this.point.setMathPanel2D(panel);
    }

    public void start() {
        if (!this.ready) {
            throw new IllegalStateException(Messages.getString("ZWAnimation.2"));
        }
        this.timer.start();
    }

    public void stop() {
        if (this.timer.isRunning()) {
            this.paused = true;
        }
        this.timer.stop();
    }

    public void pause() {
        this.paused = true;
        this.timer.stop();
    }

    public boolean isPaused() {
        return this.paused;
    }

    public void reset() {
        this.graphleft.clearpoints();
        this.graphright.clearpoints();
        this.point.setVisible(false);
        this.paused = false;
    }

    public void setDelay(int delay) {
        this.timer.setDelay(delay);
    }
}

