/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.intermediatevalue;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.intermediatevalue.AppletIntermediateValue;
import uibk.applets.intermediatevalue.Messages;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.ParsedFunction1D;
import uibk.mtk.math.parsing.Function1DParser;
import uibk.mtk.swing.base.IntervalTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelControl
extends MPanel
implements ActionListener {
    AppletIntermediateValue main;
    JTextField txtFunction;
    IntervalTextField txtInterval;
    JButton buttonStart;
    JButton buttonStop;
    JSlider sliderDelay;
    JCheckBox checkEndless;

    public PanelControl(AppletIntermediateValue main) {
        this.main = main;
        this.initComponents();
    }

    private void start() {
        Interval interval;
        ParsedFunction1D function;
        if (this.main.animation.isRunning()) {
            this.main.animation.stop();
            this.buttonStart.setText(Messages.getString("PanelControl.0"));
            return;
        }
        if (this.main.animation.isPaused()) {
            this.main.animation.start();
            this.buttonStart.setText(Messages.getString("PanelControl.1"));
            return;
        }
        try {
            function = Function1DParser.parse("x", this.txtFunction.getText());
            interval = this.txtInterval.getInterval();
        }
        catch (Exception ex) {
            return;
        }
        this.main.animation.setDelay(this.sliderDelay.getValue());
        try {
            this.main.animation.create(function, interval);
            this.buttonStop.setEnabled(true);
            this.main.animation.setVisible(true);
            this.main.animation.start();
            this.txtFunction.setEnabled(false);
            this.txtInterval.setEnabled(false);
            this.main.mathpanel2d.report(Messages.getString("PanelControl.2"));
            this.buttonStart.setText(Messages.getString("PanelControl.3"));
        }
        catch (Exception ex) {
            this.main.animation.setVisible(false);
            this.main.mathpanel2d.getScene2d().setLimits(-1.0, 1.0, -1.0, 1.0);
            this.main.mathpanel2d.reportError(ex);
            this.main.mathpanel2d.repaint();
            return;
        }
    }

    private void clear() {
        this.main.animation.stop();
        this.main.animation.reset();
        this.main.mathpanel2d.repaint();
        this.buttonStart.setEnabled(true);
        this.buttonStop.setEnabled(true);
        this.txtFunction.setEnabled(true);
        this.txtInterval.setEnabled(true);
        this.buttonStart.setText(Messages.getString("PanelControl.4"));
        this.main.mathpanel2d.report(Messages.getString("PanelControl.5"));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals(Messages.getString("PanelControl.6"))) {
            this.start();
        }
        if (ev.getActionCommand().equals("clear")) {
            this.clear();
        }
        if (ev.getActionCommand().equals("endless")) {
            this.main.animation.enableendless(this.checkEndless.isSelected());
        }
    }

    private MPanel createPanelButtons() {
        MPanel panelButtons = new MPanel();
        panelButtons.setLayout(new GridLayout(1, 2, 30, 5));
        panelButtons.setMaximumSize(new Dimension(2000, 100));
        panelButtons.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.buttonStart = new JButton(Messages.getString("PanelControl.11"));
        this.buttonStart.setActionCommand("start");
        this.buttonStart.addActionListener(this);
        this.buttonStart.setToolTipText(Messages.getString("PanelControl.13"));
        this.buttonStop = new JButton(Messages.getString("PanelControl.14"));
        this.buttonStop.setActionCommand("clear");
        this.buttonStop.addActionListener(this);
        this.buttonStop.setToolTipText(Messages.getString("PanelControl.16"));
        panelButtons.add(this.buttonStart);
        panelButtons.add(this.buttonStop);
        return panelButtons;
    }

    private MPanel createPanelDef() {
        TitledPanel panel = new TitledPanel(Messages.getString("PanelControl.17"));
        panel.setLayout(new GridBagLayout());
        panel.setMaximumSize(new Dimension(2000, 120));
        this.txtFunction = new JTextField(16);
        this.txtFunction.setActionCommand("start");
        this.txtFunction.addActionListener(this);
        this.txtFunction.setToolTipText(Messages.getString("PanelControl.7"));
        this.txtInterval = new IntervalTextField(8, Messages.getString("PanelControl.20"), true);
        this.txtInterval.setActionCommand("start");
        this.txtInterval.addActionListener(this);
        this.txtInterval.setToolTipText(Messages.getString("PanelControl.22"));
        JLabel labelFunction = new JLabel("f(x)=");
        JLabel labelIntervall = new JLabel(Messages.getString("PanelControl.25"));
        panel.add((Component)labelFunction, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.txtFunction, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)labelIntervall, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.txtInterval, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        return panel;
    }

    private MPanel createPanelOpt() {
        TitledPanel panel = new TitledPanel(Messages.getString("PanelControl.26"));
        panel.setLayout(new GridBagLayout());
        panel.setMaximumSize(new Dimension(2000, 120));
        JLabel labelDelay = new JLabel(Messages.getString("PanelControl.27"));
        this.checkEndless = new JCheckBox(Messages.getString("PanelControl.28"));
        this.checkEndless.setActionCommand("endless");
        this.checkEndless.addActionListener(this);
        this.sliderDelay = new JSlider();
        this.sliderDelay.setMaximum(100);
        this.sliderDelay.setMinimum(10);
        this.sliderDelay.setValue(50);
        this.sliderDelay.setInverted(true);
        this.sliderDelay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PanelControl.this.main.animation.setDelay(PanelControl.this.sliderDelay.getValue());
            }
        });
        panel.add((Component)this.checkEndless, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        panel.add((Component)labelDelay, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        panel.add((Component)this.sliderDelay, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 5, 5, 0), 0, 0));
        return panel;
    }

    void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.main.animation.setOnEndAction(new OnEndListener());
        this.add(this.createPanelDef());
        this.add(this.createPanelOpt());
        this.add(Box.createVerticalGlue());
        this.add(this.createPanelButtons());
    }

    private class OnEndListener
    implements ActionListener {
        private OnEndListener() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            PanelControl.this.buttonStart.setEnabled(true);
            PanelControl.this.buttonStop.setEnabled(false);
            PanelControl.this.txtFunction.setEnabled(true);
            PanelControl.this.txtInterval.setEnabled(true);
            PanelControl.this.buttonStart.setText(Messages.getString("PanelControl.9"));
            PanelControl.this.main.mathpanel2d.report(Messages.getString("PanelControl.10"));
        }
    }
}

