/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.integration;

import uibk.mtk.math.functions.Function1D;

public class GaussIntegration {
    private static double EPS = 1.0E-11;

    private static void calcKnotsAndWeights(double a, double b, double[] knots, double[] weights, int s) {
        double xm = 0.5 * (b + a);
        int m = (s + 1) / 2;
        int i = 1;
        while (i <= m) {
            double p2;
            double pp;
            double p1;
            double z1;
            double z = Math.cos(Math.PI * ((double)i - 0.25) / ((double)s + 0.5));
            do {
                p1 = 1.0;
                p2 = 0.0;
                int j = 1;
                while (j <= s) {
                    double p3 = p2;
                    p2 = p1;
                    p1 = ((2.0 * (double)j - 1.0) * z * p2 - ((double)j - 1.0) * p3) / (double)j;
                    ++j;
                }
            } while (Math.abs((z = (z1 = z) - p1 / (pp = (double)s * (z * p1 - p2) / (z * z - 1.0))) - z1) > EPS);
            double xl = 0.5 * (b - a);
            knots[i - 1] = xm - xl * z;
            knots[s - i] = xm + xl * z;
            weights[i - 1] = 2.0 * xl / ((1.0 - z * z) * pp * pp);
            weights[s - i] = weights[i - 1];
            ++i;
        }
    }

    public double quadrature(Function1D f, double lower, double upper, int s, int n) {
        double[] knots = new double[s];
        double[] weights = new double[s];
        double sum = 0.0;
        double tempsum = 0.0;
        GaussIntegration.calcKnotsAndWeights(-1.0, 1.0, knots, weights, s);
        double h = (upper - lower) / (double)n;
        int j = 0;
        while (j < n) {
            double a = lower + (double)j * h;
            double b = lower + (double)(j + 1) * h;
            double xplus = 0.5 * (a + b);
            double xminus = 0.5 * (b - a);
            tempsum = 0.0;
            int i = 0;
            while (i < s) {
                double dx = xminus * knots[i];
                tempsum += weights[i] * f.getValue(xplus + dx);
                ++i;
            }
            sum += (tempsum *= xminus);
            ++j;
        }
        return sum;
    }
}

