/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.integration2d;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.JLabel;
import uibk.applets.integration2d.Messages;
import uibk.mtk.draw2d.objects.Integration2DVisualisation;
import uibk.mtk.swing.base.TitledPanel;

public class PanelOutput
extends TitledPanel {
    DecimalFormat format = new DecimalFormat("0.0000000000", new DecimalFormatSymbols(Locale.US));
    JLabel labelsum = new JLabel("");
    JLabel labelsum2 = new JLabel("");
    JLabel labelexact = new JLabel("");
    JLabel labelerror = new JLabel("");
    private static String FORMATCOLOR = "blue";
    double exactvalue = 0.0;

    public PanelOutput() {
        super(Messages.getString("PanelOutput.0"));
        this.initComponents();
    }

    void initComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.labelsum, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelsum2, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelerror, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.labelexact, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
    }

    public void createOutput(Integration2DVisualisation integrationvis) {
        double sum = integrationvis.getSum();
        if (integrationvis.getMethod() == 5) {
            double sum2 = integrationvis.getSum2();
            this.labelsum.setText(this.makeString(Messages.getString("PanelOutput.1"), this.format.format(sum)));
            this.labelsum2.setText(this.makeString(Messages.getString("PanelOutput.8"), this.format.format(sum2)));
            this.labelerror.setText(this.makeString(Messages.getString("PanelOutput.9"), this.format.format(Math.abs(sum2 - sum))));
        } else {
            this.labelsum2.setText("");
            this.labelsum.setText(this.makeString(Messages.getString("PanelOutput.11"), this.format.format(sum)));
            this.labelerror.setText(this.makeString(Messages.getString("PanelOutput.12"), this.format.format(Math.abs(this.exactvalue - sum))));
        }
        this.labelexact.setText(this.makeString(Messages.getString("PanelOutput.13"), this.format.format(this.exactvalue)));
    }

    public void clear() {
        this.labelsum.setText("");
        this.labelsum2.setText("");
        this.labelsum.setText("");
        this.labelerror.setText("");
        this.labelexact.setText("");
        this.labelsum.setText("");
    }

    String makeString(String name, String value) {
        String str = "<html><font color=" + FORMATCOLOR + ">" + name + ": </font>" + value;
        return str;
    }

    public void setExactValue(double v) {
        this.exactvalue = v;
    }
}

