/*
 * Decompiled with CFR 0.152.
 */
package uibk.applets.integration2d;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uibk.applets.integration2d.AppletIntegration2D;
import uibk.applets.integration2d.Messages;
import uibk.mtk.geom.CoordinateRect2D;
import uibk.mtk.math.Interval;
import uibk.mtk.math.functions.Function1D;
import uibk.mtk.math.integration.GaussIntegration;
import uibk.mtk.swing.PanelFunction1D;
import uibk.mtk.swing.base.IntegerTextField;
import uibk.mtk.swing.base.MPanel;
import uibk.mtk.swing.base.TitledPanel;

public class PanelIntegrationControl
extends JPanel
implements ActionListener {
    AppletIntegration2D main;
    static String[] options = new String[]{Messages.getString("PanelIntegrationControl.0"), Messages.getString("PanelIntegrationControl.1"), Messages.getString("PanelIntegrationControl.2"), Messages.getString("PanelIntegrationControl.3"), Messages.getString("PanelIntegrationControl.4"), Messages.getString("PanelIntegrationControl.5"), Messages.getString("PanelIntegrationControl.6")};
    JSlider slider;
    PanelFunction1D panelfunction;
    IntegerTextField textsize;
    JComboBox comboBoxExamples;

    public PanelIntegrationControl(AppletIntegration2D main) {
        this.main = main;
        this.initComponents();
    }

    protected void initComponents() {
        this.setLayout(new BoxLayout(this, 1));
        this.panelfunction = new PanelFunction1D('x');
        this.add(this.panelfunction);
        this.add(this.createPanelControl());
    }

    MPanel createPanelControl() {
        TitledPanel panel = new TitledPanel(Messages.getString("PanelIntegrationControl.7"));
        panel.setLayout(new GridBagLayout());
        panel.setMaximumSize(new Dimension(2000, 200));
        this.slider = new JSlider();
        this.slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                JSlider slider = (JSlider)evt.getSource();
                int n = slider.getValue();
                if (PanelIntegrationControl.this.textsize != null) {
                    PanelIntegrationControl.this.textsize.setText(String.valueOf(n));
                }
                if (PanelIntegrationControl.this.main.integrationvis.isVisible()) {
                    PanelIntegrationControl.this.compute();
                }
            }
        });
        this.slider.setMinimum(1);
        this.slider.setMaximum(500);
        this.slider.setValue(10);
        this.comboBoxExamples = new JComboBox<String>(options);
        this.comboBoxExamples.setActionCommand("compute");
        this.comboBoxExamples.addActionListener(this);
        this.textsize = new IntegerTextField(10, new Integer(1), new Integer(500), Messages.getString("PanelIntegrationControl.9"));
        this.textsize.setActionCommand("compute");
        this.textsize.addActionListener(this);
        this.textsize.setText(String.valueOf(10));
        JButton buttonintegrate = new JButton(Messages.getString("PanelIntegrationControl.11"));
        buttonintegrate.setActionCommand("compute");
        buttonintegrate.addActionListener(this);
        panel.add((Component)new JLabel(Messages.getString("PanelIntegrationControl.13")), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)this.comboBoxExamples, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 0, 5), 0, 0));
        panel.add((Component)new JLabel(Messages.getString("PanelIntegrationControl.14")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)this.textsize, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 5, 5, 0), 0, 0));
        panel.add((Component)this.slider, new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 5, 5), 0, 0));
        panel.add((Component)buttonintegrate, new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 0, new Insets(10, 5, 5, 5), 0, 0));
        return panel;
    }

    private void setMethod() {
        String item = (String)this.comboBoxExamples.getSelectedItem();
        if (item.equals(Messages.getString("PanelIntegrationControl.15"))) {
            this.main.integrationvis.setMethod(3);
        }
        if (item.equals(Messages.getString("PanelIntegrationControl.16"))) {
            this.main.integrationvis.setMethod(4);
        }
        if (item.equals(Messages.getString("PanelIntegrationControl.17"))) {
            this.main.integrationvis.setMethod(1);
        }
        if (item.equals(Messages.getString("PanelIntegrationControl.18"))) {
            this.main.integrationvis.setMethod(0);
        }
        if (item.equals(Messages.getString("PanelIntegrationControl.19"))) {
            this.main.integrationvis.setMethod(5);
        }
        if (item.equals(Messages.getString("PanelIntegrationControl.20"))) {
            this.main.integrationvis.setMethod(7);
        }
        if (item.equals(Messages.getString("PanelIntegrationControl.21"))) {
            this.main.integrationvis.setMethod(6);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("compute")) {
            this.compute();
        }
    }

    public void compute() {
        this.setMethod();
        if (this.panelfunction.getIntervalField().hasChanged() || this.panelfunction.getFunctionField().hasChanged()) {
            try {
                Function1D f = this.panelfunction.getFunction();
                Interval interval = this.panelfunction.getInterval();
                this.main.integrationvis.setFunction(f);
                this.main.integrationvis.setInterval(interval);
                GaussIntegration integrator = new GaussIntegration();
                int s = 5;
                int k = 30;
                double sum = integrator.quadrature(f, interval.a, interval.b, s, k);
                this.main.paneloutput.setExactValue(sum);
            }
            catch (Exception e) {
                this.main.mathpanel2d.reportError(e);
                return;
            }
        }
        try {
            int n = this.textsize.getValue();
            this.slider.setValue(n);
            this.main.integrationvis.setNumberSubDivisions(n);
            this.main.integrationvis.create();
        }
        catch (Exception e) {
            this.main.mathpanel2d.reportError(e);
            return;
        }
        this.main.integrationvis.setVisible(true);
        CoordinateRect2D limits = this.main.integrationvis.getLimits();
        this.main.mathpanel2d.getScene2d().setLimits(limits);
        this.main.paneloutput.createOutput(this.main.integrationvis);
        this.main.mathpanel2d.report(Messages.getString("PanelIntegrationControl.23"));
        this.main.mathpanel2d.repaint();
    }
}

