/*
 * Decompiled with CFR 0.152.
 */
package uibk.text;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;

public class Formatter
extends DecimalFormat {
    public Formatter() {
        super("0.0", new DecimalFormatSymbols(Locale.US));
    }

    public String format(double x, int n) {
        this.setMaximumFractionDigits(n);
        return this.format(x);
    }

    private String createzeros(int n) {
        String str = "";
        int i = 0;
        while (i < n) {
            str = String.valueOf(str) + "0";
            ++i;
        }
        return str;
    }

    public String entire(double x) {
        this.applyPattern("0");
        return this.format(x);
    }

    public String formatentire(double x, int n) {
        this.applyPattern(String.valueOf(this.createzeros(n)) + "E0");
        String temp = this.format(x);
        this.applyPattern("0.0");
        double d = Double.valueOf(temp);
        return this.format(d);
    }

    public String formatplaces(double x, int places) {
        if (places == 0) {
            return this.entire(x);
        }
        this.applyPattern("0." + this.createzeros(places));
        return this.format(x);
    }

    public int getExp(double x) {
        this.applyPattern("0E0");
        String temp = this.format(x);
        int pos = temp.indexOf("E");
        return Integer.parseInt(temp.substring(pos + 1));
    }

    public String roundtoleadingdec(double x) {
        this.applyPattern("0.E0");
        String temp = this.format(x);
        int pos = temp.indexOf("E");
        int exponent = Integer.parseInt(temp.substring(pos + 1));
        int leading = Integer.parseInt(temp.substring(0, pos));
        if (exponent < 0) {
            return "0." + this.createzeros(Math.abs(exponent + 1)) + leading;
        }
        return String.valueOf(leading) + this.createzeros(exponent);
    }

    public String formatdistance(double x, double distance) {
        if (distance > 1.0) {
            int i = 0;
            double temp = 0.5;
            while (temp < distance) {
                temp *= 10.0;
                ++i;
            }
            int n = this.getExp(x) - i;
            if (n < 1) {
                return this.entire(x);
            }
            return this.formatentire(x, n);
        }
        int i = 0;
        double temp = 0.5;
        while (temp > distance) {
            temp /= 10.0;
            ++i;
        }
        return this.formatplaces(x, i);
    }

    public String commonformat(double x, double dist) {
        return String.valueOf(Double.parseDouble(this.formatdistance(x, dist)));
    }
}

