/*
 * Decompiled with CFR 0.152.
 */
package uibk.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import uibk.draw3d.base.MathPanel3D;
import uibk.swing.ButtonNoFocus;
import uibk.swing.Label;
import uibk.swing.Panel;
import uibk.swing.RadioButton;

public class PanelScale3D
extends Panel
implements ActionListener {
    RadioButton jRadioEqual;
    RadioButton jRadioIndependent;
    ButtonGroup groupOpt = new ButtonGroup();
    ButtonNoFocus jButtonXScaleUp;
    ButtonNoFocus jButtonXScaleDown;
    ButtonNoFocus jButtonYScaleUp;
    ButtonNoFocus jButtonYScaleDown;
    ButtonNoFocus jButtonZScaleUp;
    ButtonNoFocus jButtonZScaleDown;
    ButtonNoFocus jButtonScaleUp;
    ButtonNoFocus jButtonScaleDown;
    MathPanel3D mathpanel3d;
    private String strequal = "gemeinsam skalieren";
    private String strindependent = "unabh\u00e4ngig skalieren";
    private String strtitle = "Skalierung";
    private String strxaxis = "x-Achse";
    private String stryaxis = "y-Achse";
    private String strzaxis = "z-Achse";
    private double scalefactor = 1.1;
    public static final int SCALE_EQUAL = 0;
    public static final int SCALE_INDEPENDENT = 1;
    int mode;

    public void setScaleFaktor(double factor) {
        this.scalefactor = factor;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.jRadioIndependent.setEnabled(true);
            this.jRadioEqual.setEnabled(true);
            this.setMode(this.mode);
        } else {
            this.jButtonXScaleUp.setEnabled(false);
            this.jButtonXScaleDown.setEnabled(false);
            this.jButtonYScaleUp.setEnabled(false);
            this.jButtonYScaleDown.setEnabled(false);
            this.jButtonZScaleUp.setEnabled(false);
            this.jButtonZScaleDown.setEnabled(false);
            this.jButtonScaleUp.setEnabled(false);
            this.jButtonScaleDown.setEnabled(false);
        }
    }

    public void setMode(int mode) {
        if (mode == 0) {
            this.jButtonXScaleUp.setEnabled(false);
            this.jButtonXScaleDown.setEnabled(false);
            this.jButtonYScaleUp.setEnabled(false);
            this.jButtonYScaleDown.setEnabled(false);
            this.jButtonZScaleUp.setEnabled(false);
            this.jButtonZScaleDown.setEnabled(false);
            this.jButtonScaleUp.setEnabled(true);
            this.jButtonScaleDown.setEnabled(true);
            this.jRadioEqual.setSelected(true);
            this.mode = mode;
        }
        if (mode == 1) {
            this.jButtonXScaleUp.setEnabled(true);
            this.jButtonXScaleDown.setEnabled(true);
            this.jButtonYScaleUp.setEnabled(true);
            this.jButtonYScaleDown.setEnabled(true);
            this.jButtonZScaleUp.setEnabled(true);
            this.jButtonZScaleDown.setEnabled(true);
            this.jButtonScaleUp.setEnabled(false);
            this.jButtonScaleDown.setEnabled(false);
            this.jRadioIndependent.setSelected(true);
            this.mode = mode;
        }
    }

    public PanelScale3D(MathPanel3D mathpanel3d) {
        this.mathpanel3d = mathpanel3d;
        this.initComponents();
    }

    void initComponents() {
        TitledBorder border = BorderFactory.createTitledBorder(this.strtitle);
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        this.setBorder(border);
        this.setLayout(new GridBagLayout());
        this.setMaximumSize(new Dimension(2000, 210));
        this.setPreferredSize(new Dimension(2000, 210));
        URL urlIconPlus = this.getClass().getResource("res/plus.gif");
        URL urlIconMinus = this.getClass().getResource("res/minus.gif");
        this.jButtonXScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonXScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonXScaleUp.setActionCommand("xscaleup");
        this.jButtonXScaleDown.setActionCommand("xscaledown");
        this.jButtonYScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonYScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonYScaleUp.setActionCommand("yscaleup");
        this.jButtonYScaleDown.setActionCommand("yscaledown");
        this.jButtonZScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonZScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonZScaleUp.setActionCommand("zscaleup");
        this.jButtonZScaleDown.setActionCommand("zscaledown");
        this.jButtonScaleUp = new ButtonNoFocus(new ImageIcon(urlIconPlus));
        this.jButtonScaleUp.setActionCommand("scaleup");
        this.jButtonScaleDown = new ButtonNoFocus(new ImageIcon(urlIconMinus));
        this.jButtonScaleDown.setActionCommand("scaledown");
        this.jButtonXScaleUp.setBorder(null);
        this.jButtonXScaleDown.setBorder(null);
        this.jButtonYScaleUp.setBorder(null);
        this.jButtonYScaleDown.setBorder(null);
        this.jButtonZScaleUp.setBorder(null);
        this.jButtonZScaleDown.setBorder(null);
        this.jButtonScaleDown.setBorder(null);
        this.jButtonScaleUp.setBorder(null);
        this.jButtonXScaleUp.addActionListener(this);
        this.jButtonXScaleDown.addActionListener(this);
        this.jButtonYScaleUp.addActionListener(this);
        this.jButtonYScaleDown.addActionListener(this);
        this.jButtonZScaleUp.addActionListener(this);
        this.jButtonZScaleDown.addActionListener(this);
        this.jButtonScaleUp.addActionListener(this);
        this.jButtonScaleDown.addActionListener(this);
        this.jRadioEqual = new RadioButton(this.strequal);
        this.jRadioIndependent = new RadioButton(this.strindependent);
        this.jRadioEqual.addActionListener(this);
        this.jRadioIndependent.addActionListener(this);
        this.jRadioEqual.setActionCommand("scaleequal");
        this.jRadioIndependent.setActionCommand("scaleindependet");
        if (this.mathpanel3d.getScene3D().getScalingMode() == 0) {
            this.setMode(0);
        } else {
            this.setMode(1);
        }
        this.groupOpt.add(this.jRadioEqual);
        this.groupOpt.add(this.jRadioIndependent);
        this.setEnabled(true);
        this.add((Component)this.jRadioIndependent, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)new Label(this.strxaxis), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add((Component)this.jButtonXScaleDown, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonXScaleUp, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)new Label(this.stryaxis), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add((Component)this.jButtonYScaleDown, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonYScaleUp, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)new Label(this.strzaxis), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 30, 5, 0), 0, 0));
        this.add((Component)this.jButtonZScaleDown, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonZScaleUp, new GridBagConstraints(2, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.jRadioEqual, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.jButtonScaleDown, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
        this.add((Component)this.jButtonScaleUp, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 5, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        double scaley;
        double scalex;
        double scalez;
        double scale;
        if (ev.getActionCommand().equals("xscaleup")) {
            scale = this.mathpanel3d.getScene3D().getXScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scale * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("xscaledown")) {
            scale = this.mathpanel3d.getScene3D().getXScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scale / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("yscaleup")) {
            scale = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setYScaleFactor(scale * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("yscaledown")) {
            scale = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setYScaleFactor(scale / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("zscaleup")) {
            scale = this.mathpanel3d.getScene3D().getZScaleFactor();
            this.mathpanel3d.getScene3D().setZScaleFactor(scale * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("zscaledown")) {
            scale = this.mathpanel3d.getScene3D().getZScaleFactor();
            this.mathpanel3d.getScene3D().setZScaleFactor(scale / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaleup")) {
            scalez = this.mathpanel3d.getScene3D().getZScaleFactor();
            scalex = this.mathpanel3d.getScene3D().getXScaleFactor();
            scaley = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scalex * this.scalefactor);
            this.mathpanel3d.getScene3D().setYScaleFactor(scaley * this.scalefactor);
            this.mathpanel3d.getScene3D().setZScaleFactor(scalez * this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaledown")) {
            scalez = this.mathpanel3d.getScene3D().getZScaleFactor();
            scalex = this.mathpanel3d.getScene3D().getXScaleFactor();
            scaley = this.mathpanel3d.getScene3D().getYScaleFactor();
            this.mathpanel3d.getScene3D().setXScaleFactor(scalex / this.scalefactor);
            this.mathpanel3d.getScene3D().setYScaleFactor(scaley / this.scalefactor);
            this.mathpanel3d.getScene3D().setZScaleFactor(scalez / this.scalefactor);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaleequal")) {
            this.setMode(0);
            this.mathpanel3d.getScene3D().setScalingMode(0);
            this.mathpanel3d.repaint();
        }
        if (ev.getActionCommand().equals("scaleindependet")) {
            this.setMode(1);
            this.mathpanel3d.getScene3D().setScalingMode(1);
            this.mathpanel3d.repaint();
        }
    }
}

