/*
 * Decompiled with CFR 0.152.
 */
package uibk.swing;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.border.TitledBorder;
import uibk.draw2d.base.MathPanel2D;
import uibk.geom.CoordinateRect2D;
import uibk.swing.ButtonNoFocus;
import uibk.swing.Panel;
import uibk.swing.PanelScale2D;

public class PanelEnlargeCoords2D
extends Panel
implements ActionListener {
    ButtonNoFocus buttonUp;
    ButtonNoFocus buttonDown;
    ButtonNoFocus buttonLeft;
    ButtonNoFocus buttonRight;
    MathPanel2D mathpanel2d;
    PanelScale2D scaleaxes2d;

    public PanelEnlargeCoords2D(MathPanel2D mathpanel2d) {
        this.mathpanel2d = mathpanel2d;
        this.initComponents();
    }

    void initComponents() {
        TitledBorder border = BorderFactory.createTitledBorder("einseitig vergr\u00f6ssern");
        border.setTitleFont(border.getTitleFont().deriveFont(1));
        this.setBorder(border);
        URL urlIconDown = this.getClass().getResource("res/arrowdown.gif");
        URL urlIconUp = this.getClass().getResource("res/arrowup.gif");
        URL urlIconLeft = this.getClass().getResource("res/arrowleft.gif");
        URL urlIconRight = this.getClass().getResource("res/arrowright.gif");
        this.buttonDown = new ButtonNoFocus(new ImageIcon(urlIconDown));
        this.buttonUp = new ButtonNoFocus(new ImageIcon(urlIconUp));
        this.buttonLeft = new ButtonNoFocus(new ImageIcon(urlIconLeft));
        this.buttonRight = new ButtonNoFocus(new ImageIcon(urlIconRight));
        this.buttonDown.setActionCommand("down");
        this.buttonUp.setActionCommand("up");
        this.buttonLeft.setActionCommand("left");
        this.buttonRight.setActionCommand("right");
        this.buttonDown.setBorder(null);
        this.buttonUp.setBorder(null);
        this.buttonLeft.setBorder(null);
        this.buttonRight.setBorder(null);
        this.buttonDown.addActionListener(this);
        this.buttonUp.addActionListener(this);
        this.buttonLeft.addActionListener(this);
        this.buttonRight.addActionListener(this);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.buttonUp, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 14, 5, 0), 0, 0));
        this.add((Component)this.buttonLeft, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 5), 0, 0));
        this.add((Component)this.buttonRight, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.buttonDown, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 14, 0, 0), 0, 0));
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        CoordinateRect2D coordrect;
        if (ev.getActionCommand().equals("down")) {
            coordrect = this.mathpanel2d.getScene2d().getCoordinates();
            coordrect.ymin -= Math.abs(coordrect.ymax - coordrect.ymin) / 10.0;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (ev.getActionCommand().equals("up")) {
            coordrect = this.mathpanel2d.getScene2d().getCoordinates();
            coordrect.ymax += Math.abs(coordrect.ymax - coordrect.ymin) / 10.0;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (ev.getActionCommand().equals("left")) {
            coordrect = this.mathpanel2d.getScene2d().getCoordinates();
            coordrect.xmin -= Math.abs(coordrect.xmax - coordrect.xmin) / 10.0;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (ev.getActionCommand().equals("right")) {
            coordrect = this.mathpanel2d.getScene2d().getCoordinates();
            coordrect.xmax += Math.abs(coordrect.xmax - coordrect.xmin) / 10.0;
            this.mathpanel2d.getScene2d().setLimits(coordrect);
        }
        if (this.scaleaxes2d != null && this.scaleaxes2d.getMode() == 0) {
            this.mathpanel2d.getScene2d().equalizeCoords();
        }
        this.mathpanel2d.repaint();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.buttonDown.setEnabled(enabled);
        this.buttonUp.setEnabled(enabled);
        this.buttonLeft.setEnabled(enabled);
        this.buttonRight.setEnabled(enabled);
    }

    public void setPanelScaleAxes2D(PanelScale2D panelaxes) {
        this.scaleaxes2d = panelaxes;
    }
}

