/*
 * Decompiled with CFR 0.152.
 */
package uibk.geom;

import uibk.geom.Vector3D;

public class Point3D {
    public double x1;
    public double x2;
    public double x3;
    public double h = 1.0;

    public Point3D(double x, double y, double z) {
        this.x1 = x;
        this.x2 = y;
        this.x3 = z;
    }

    public Point3D() {
    }

    public Point3D(Point3D p) {
        this.x1 = p.x1;
        this.x2 = p.x2;
        this.x3 = p.x3;
    }

    public void toCanonical() {
        this.x1 /= this.h;
        this.x2 /= this.h;
        this.x3 /= this.h;
    }

    public Point3D add(Point3D b) {
        return new Point3D(this.x1 + b.x1, this.x2 + b.x2, this.x3 + b.x3);
    }

    public Point3D sub(Point3D v) {
        return new Point3D(this.x1 - v.x1, this.x2 - v.x2, this.x3 - v.x3);
    }

    public static Point3D inverse(Point3D a) {
        return new Point3D(-a.x1, -a.x2, -a.x3);
    }

    public void setLocation(Point3D p) {
        this.x1 = p.x1;
        this.x2 = p.x2;
        this.x3 = p.x3;
    }

    public void setLocation(double x1, double x2, double x3) {
        this.x1 = x1;
        this.x2 = x2;
        this.x3 = x3;
    }

    public void scale(double s) {
        this.x1 *= s;
        this.x2 *= s;
        this.x3 *= s;
    }

    public static Point3D scale(double s, Point3D p) {
        Point3D a = new Point3D(p.x1 * s, p.x2 * s, p.x3 * s);
        return a;
    }

    public static void scaleself(double s, Point3D p) {
        p.x1 *= s;
        p.x2 *= s;
        p.x3 *= s;
    }

    public static Vector3D crossProd(Point3D a, Point3D b) {
        Vector3D c = new Vector3D();
        c.x1 = a.x2 * b.x3 - a.x3 * b.x2;
        c.x2 = a.x3 * b.x1 - a.x1 * b.x3;
        c.x3 = a.x1 * b.x2 - a.x2 * b.x1;
        return c;
    }

    public static double dotProd(Point3D a, Point3D b) {
        return a.x1 * b.x1 + a.x2 * b.x2 + a.x3 * b.x3;
    }

    public double norm() {
        return Math.sqrt(this.x1 * this.x1 + this.x2 * this.x2 + this.x3 * this.x3);
    }

    public double quadnorm() {
        return this.x1 * this.x1 + this.x2 * this.x2 + this.x3 * this.x3;
    }

    public void normalize() {
        double n = Math.sqrt(this.x1 * this.x1 + this.x2 * this.x2 + this.x3 * this.x3);
        this.x1 /= n;
        this.x2 /= n;
        this.x3 /= n;
    }

    public String toString() {
        return "(" + this.x1 + "," + this.x2 + "," + this.x3 + ")";
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.x1) || Double.isInfinite(this.x2) || Double.isInfinite(this.x3);
    }

    public boolean isNaN() {
        return Double.isNaN(this.x1) || Double.isNaN(this.x2) || Double.isNaN(this.x3);
    }

    public boolean isReal() {
        return !this.isNaN() && !this.isInfinite();
    }
}

