/*
 * Decompiled with CFR 0.152.
 */
package uibk.geom;

import uibk.geom.Punkt2D;

public final class GeomUtil {
    public static final int INTERSECTION_EMPTY = 0;
    public static final int INTERSECTION_POINT = 1;
    public static final int INTESECTION_LINE = 2;

    private GeomUtil() {
    }

    public static int intersectLines(Punkt2D p, Punkt2D dir, Punkt2D u, Punkt2D v, Punkt2D s) {
        double slope1 = dir.y / dir.x;
        double slope2 = (v.y - u.y) / (v.x - u.x);
        if (Double.isInfinite(slope1) && Double.isInfinite(slope2)) {
            if (p.x == u.x) {
                return 2;
            }
            return 0;
        }
        if (Double.isInfinite(slope1) && !Double.isInfinite(slope2)) {
            double d2 = u.y - slope2 * u.x;
            double sy = slope2 * p.x + d2;
            if (sy <= u.y && sy >= v.y || sy >= u.y && sy <= v.y) {
                s.x = p.x;
                s.y = sy;
                return 1;
            }
            return 0;
        }
        if (!Double.isInfinite(slope1) && Double.isInfinite(slope2)) {
            double d1 = p.y - slope1 * p.x;
            double sy = slope1 * u.x + d1;
            if (sy <= u.y && sy >= v.y || sy >= u.y && sy <= v.y) {
                s.x = u.x;
                s.y = sy;
                return 1;
            }
            return 0;
        }
        if (!Double.isInfinite(slope1) && !Double.isInfinite(slope2)) {
            double d1 = p.y - slope1 * p.x;
            double d2 = u.y - slope2 * u.x;
            if (slope1 == slope2) {
                if (d1 == d2) {
                    s.setLocation(u);
                    return 2;
                }
                return 0;
            }
            double sx = (d2 - d1) / (slope1 - slope2);
            double sy = slope2 * sx + d2;
            if ((sy <= u.y && sy >= v.y || sy >= u.y && sy <= v.y) && (sx <= u.x && sx >= v.x || sx >= u.x && sx <= v.x)) {
                s.x = sx;
                s.y = sy;
                return 1;
            }
            return 0;
        }
        return 0;
    }

    public static double distPointLine(double x, double y, double p1x, double p1y, double p2x, double p2y) {
        boolean containsy;
        double ax = x;
        double ay = y;
        double lx = p2x - p1x;
        double ly = p2y - p1y;
        double norm = Math.sqrt(lx * lx + ly * ly);
        double s = (ax -= p1x) * (lx /= norm) + (ay -= p1y) * (ly /= norm);
        lx *= s;
        ly *= s;
        lx += p1x;
        ly += p1y;
        boolean containsx = lx >= p1x && lx <= p2x || lx <= p1x && lx >= p2x;
        boolean bl = containsy = lx >= p1x && lx <= p2x || lx <= p1x && lx >= p2x;
        if (containsx && containsy) {
            return (lx -= x) * lx + (ly -= y) * ly;
        }
        double dist1 = (x - p1x) * (x - p1x) + (y - p1y) * (y - p1y);
        double dist2 = (x - p2x) * (x - p2x) + (y - p2y) * (y - p2y);
        return Math.min(dist1, dist2);
    }
}

