/*
 * Decompiled with CFR 0.152.
 */
package uibk.geom;

import uibk.geom.Punkt2D;

public class CoordinateRect2D {
    public double xmin;
    public double xmax;
    public double ymin;
    public double ymax;

    public CoordinateRect2D(double xmin, double xmax, double ymin, double ymax) {
        this.xmin = xmin;
        this.xmax = xmax;
        this.ymin = ymin;
        this.ymax = ymax;
    }

    public CoordinateRect2D() {
        this(-1.0, 1.0, -1.0, 1.0);
    }

    public boolean containsx(double x) {
        return x <= this.xmax && x >= this.xmin;
    }

    public boolean contains(CoordinateRect2D rect) {
        return !(rect.xmin < this.xmin || rect.ymin < this.ymin || rect.xmax > this.xmax) && !(rect.ymax > this.ymax);
    }

    public boolean containsy(double y) {
        return y <= this.ymax && y >= this.ymin;
    }

    public boolean contains(Punkt2D p) {
        return this.containsx(p.x) && this.containsy(p.y);
    }

    public boolean contains(double x, double y) {
        return this.containsx(x) && this.containsy(y);
    }

    public double getXRange() {
        return this.xmax - this.xmin;
    }

    public double getYRange() {
        return this.ymax - this.ymin;
    }

    public String toString() {
        return "[xmin=" + this.xmin + ", xmax=" + this.xmax + ", ymin=" + this.ymin + ", ymax=" + this.ymax + "]";
    }

    public CoordinateRect2D combine(CoordinateRect2D s) {
        double newxmin = this.xmin < s.xmin ? this.xmin : s.xmin;
        double newxmax = this.xmax > s.xmax ? this.xmax : s.xmax;
        double newymin = this.ymin < s.ymin ? this.ymin : s.ymin;
        double newymax = this.ymax > s.ymax ? this.ymax : s.ymax;
        return new CoordinateRect2D(newxmin, newxmax, newymin, newymax);
    }
}

