/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.surface3d;

import java.awt.Graphics2D;
import uibk.draw3d.surface3d.AdditionalRendering;
import uibk.draw3d.surface3d.Surface3D;
import uibk.draw3d.surface3d.Triangle;
import uibk.geom.GeomUtil;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.math.MathUtil;

public class SurfaceWithLines
extends Surface3D {
    private boolean drawcoordlinex = false;
    private boolean drawcoordliney = false;
    private boolean drawcoordline = false;

    public void enableCoordLineX(boolean enable) {
        this.drawcoordlinex = enable;
    }

    public SurfaceWithLines() {
        this.setAdditionalRendering(new AddRender());
    }

    public void enableCoordLineY(boolean enable) {
        this.drawcoordliney = enable;
    }

    public void enableCoordLine(boolean enable) {
        this.drawcoordline = enable;
    }

    private void drawCoordLines(Triangle triangle, Graphics2D g2) {
        if (this.drawcoordlinex) {
            this.drawCoordLine(triangle, g2, this.base, Vector2D.E1);
        }
        if (this.drawcoordliney) {
            this.drawCoordLine(triangle, g2, this.base, Vector2D.E2);
        }
        if (this.drawcoordline) {
            this.drawCoordLine(triangle, g2, this.base, this.dir);
        }
    }

    void drawCoordLine(Triangle t, Graphics2D g2, Punkt2D point, Vector2D direction) {
        Point3D p = new Point3D();
        Point3D q = new Point3D();
        Punkt2D p1 = new Punkt2D(t.p1.mc.x1, t.p1.mc.x2);
        Punkt2D p2 = new Punkt2D(t.p2.mc.x1, t.p2.mc.x2);
        Punkt2D p3 = new Punkt2D(t.p3.mc.x1, t.p3.mc.x2);
        double zp1 = t.p1.mc.x3;
        double zp2 = t.p2.mc.x3;
        double zp3 = t.p3.mc.x3;
        Punkt2D s1 = new Punkt2D();
        Punkt2D s2 = new Punkt2D();
        Punkt2D s3 = new Punkt2D();
        int ret1 = GeomUtil.intersectLines(point, direction, p1, p2, s1);
        int ret2 = GeomUtil.intersectLines(point, direction, p2, p3, s2);
        int ret3 = GeomUtil.intersectLines(point, direction, p3, p1, s3);
        boolean drawcurve = false;
        if (ret1 == 2) {
            p.setLocation(p1.x, p1.y, zp1);
            q.setLocation(p2.x, p2.y, zp2);
            drawcurve = true;
        }
        if (ret2 == 2) {
            p.setLocation(p3.x, p3.y, zp3);
            q.setLocation(p2.x, p2.y, zp2);
            drawcurve = true;
        }
        if (ret3 == 2) {
            p.setLocation(p1.x, p1.y, zp1);
            q.setLocation(p3.x, p3.y, zp3);
            drawcurve = true;
        }
        if (!drawcurve) {
            double z2;
            double z1;
            if (ret2 == 1 && ret3 == 1 && !s2.equals(s3)) {
                z1 = MathUtil.interpolate((Punkt2D)p2, (Punkt2D)p3, (double)zp2, (double)zp3, (Punkt2D)s2);
                z2 = MathUtil.interpolate((Punkt2D)p3, (Punkt2D)p1, (double)zp3, (double)zp1, (Punkt2D)s3);
                p.setLocation(s2.x, s2.y, z1);
                q.setLocation(s3.x, s3.y, z2);
                drawcurve = true;
            }
            if (ret1 == 1 && ret3 == 1 && !s1.equals(s3)) {
                z1 = MathUtil.interpolate((Punkt2D)p1, (Punkt2D)p2, (double)zp1, (double)zp2, (Punkt2D)s1);
                z2 = MathUtil.interpolate((Punkt2D)p1, (Punkt2D)p3, (double)zp1, (double)zp3, (Punkt2D)s3);
                p.setLocation(s1.x, s1.y, z1);
                q.setLocation(s3.x, s3.y, z2);
                drawcurve = true;
            }
            if (ret1 == 1 && ret2 == 1 && !s1.equals(s2)) {
                z1 = MathUtil.interpolate((Punkt2D)p1, (Punkt2D)p2, (double)zp1, (double)zp2, (Punkt2D)s1);
                z2 = MathUtil.interpolate((Punkt2D)p2, (Punkt2D)p3, (double)zp2, (double)zp3, (Punkt2D)s2);
                p.setLocation(s1.x, s1.y, z1);
                q.setLocation(s2.x, s2.y, z2);
                drawcurve = true;
            }
        }
        if (!drawcurve) {
            return;
        }
        Punkt2D a = this.scene3d.project(p);
        Punkt2D b = this.scene3d.project(q);
        g2.setColor(this.colorlines);
        this.rasterizer.drawLine((int)a.x, (int)a.y, (int)b.x, (int)b.y);
    }

    public void setBase(Punkt2D p) {
        this.base.setLocation(p);
    }

    public void setDirection(Vector2D direction) {
        this.dir.setLocation(direction);
    }

    class AddRender
    implements AdditionalRendering {
        AddRender() {
        }

        @Override
        public void render(Triangle tri, Graphics2D g2) {
            SurfaceWithLines.this.drawCoordLines(tri, g2);
        }
    }
}

