/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.surface3d;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.Vector;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.base.Rasterable3D;
import uibk.draw3d.rasterizer.Rasterizer;
import uibk.draw3d.surface3d.AdditionalRendering;
import uibk.draw3d.surface3d.ColorModel;
import uibk.draw3d.surface3d.ColorModelXYZ;
import uibk.draw3d.surface3d.Mesh;
import uibk.draw3d.surface3d.Triangle;
import uibk.draw3d.surface3d.Vertex3D;
import uibk.geom.CoordinateCube3D;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.geom.Vector3D;
import uibk.lang.PrepaintComputable;

public class Surface3D
extends Drawable3D
implements PrepaintComputable,
Rasterable3D {
    Mesh mesh;
    AdditionalRendering addrendering;
    static final Color COLORMESH = new Color(255, 0, 0, 120);
    static final Color COLORPATCHMESH = new Color(0, 0, 0, 120);
    Color colorlines = new Color(200, 200, 200, 200);
    Punkt2D base = new Punkt2D();
    Vector2D dir = new Vector2D();
    static final Color COLORFRONT = new Color(255, 0, 0);
    static final Color COLORBACK = new Color(0, 0, 255);
    ColorModel colormodel = new ColorModelXYZ();
    static final Color COLORBACKGROUND = Color.white;
    protected int colormode = 1;
    public static final int FRONTBACK = 0;
    public static final int VERTEXCOLORS = 1;
    int drawmode = 2;
    public static final int DRAW_WIREFRAME = 0;
    public static final int DRAW_VISIBLE_WIREFRAME = 1;
    public static final int DRAW_PATCH_WIREFRAME = 2;
    public static final int DRAW_PATCH = 3;
    Rasterizer rasterizer;

    @Override
    public void setRasterizer(Rasterizer rasterizer) {
        this.rasterizer = rasterizer;
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
        this.calcColors();
    }

    public Mesh getMesh() {
        return this.mesh;
    }

    public void setDrawMode(int mode) {
        this.drawmode = mode;
    }

    public int getDrawMode() {
        return this.drawmode;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (this.mesh == null) {
            return;
        }
        this.rasterizer.enableZBuffer(true);
        switch (this.drawmode) {
            case 0: {
                this.drawmesh(g2);
                break;
            }
            case 1: {
                this.drawVisibleMesh(g2);
                break;
            }
            case 2: {
                this.drawpatchwireframe(g2);
                break;
            }
            case 3: {
                this.drawpatch(g2);
                break;
            }
        }
    }

    private void drawpatch(Graphics2D g2) {
        Vector triangles = this.mesh.getTriangles();
        switch (this.colormode) {
            case 1: {
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    this.rasterizer.setColor(tri.p1.color);
                    this.rasterizer.renderTriangle(tri);
                    this.additionalRendering(tri, g2);
                    ++i;
                }
                break;
            }
            case 0: {
                int savemode = this.rasterizer.getShadingMode();
                this.rasterizer.setShadingMode(0);
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    Point3D cam = this.panel.getScene3D().getCamera();
                    if (Vector3D.dotProd(cam.sub(tri.p1.wc), tri.normal) < 0.0) {
                        this.rasterizer.setColor(COLORFRONT);
                    } else {
                        this.rasterizer.setColor(COLORBACK);
                    }
                    this.rasterizer.renderTriangle(tri);
                    ++i;
                }
                this.rasterizer.setShadingMode(savemode);
                break;
            }
        }
    }

    void drawpatchwireframe(Graphics2D g2) {
        Vector triangles = this.mesh.getTriangles();
        switch (this.colormode) {
            case 1: {
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    this.rasterizer.setColor(tri.p1.color);
                    this.rasterizer.renderTriangle(tri);
                    this.rasterizer.setColor(COLORPATCHMESH);
                    this.rasterizer.drawLine((int)tri.p1.dc.x, (int)tri.p1.dc.y, (int)tri.p2.dc.x, (int)tri.p2.dc.y);
                    this.rasterizer.drawLine((int)tri.p3.dc.x, (int)tri.p3.dc.y, (int)tri.p1.dc.x, (int)tri.p1.dc.y);
                    this.additionalRendering(tri, g2);
                    ++i;
                }
                break;
            }
            case 0: {
                this.rasterizer.setShadingMode(0);
                int i = 0;
                while (i < triangles.size()) {
                    Triangle tri = (Triangle)triangles.elementAt(i);
                    Point3D cam = this.panel.getScene3D().getCamera();
                    if (Vector3D.dotProd(cam.sub(tri.p1.wc), tri.normal) < 0.0) {
                        this.rasterizer.setColor(COLORFRONT);
                    } else {
                        this.rasterizer.setColor(COLORBACK);
                    }
                    this.rasterizer.renderTriangle(tri);
                    this.rasterizer.setColor(COLORPATCHMESH);
                    this.rasterizer.drawLine((int)tri.p1.dc.x, (int)tri.p1.dc.y, (int)tri.p2.dc.x, (int)tri.p2.dc.y);
                    this.rasterizer.drawLine((int)tri.p3.dc.x, (int)tri.p3.dc.y, (int)tri.p1.dc.x, (int)tri.p1.dc.y);
                    this.additionalRendering(tri, g2);
                    ++i;
                }
                break;
            }
        }
    }

    private void computenormals() {
        Vector triangles = this.mesh.getTriangles();
        int i = 0;
        while (i < triangles.size()) {
            Vector3D n;
            Triangle tri = (Triangle)triangles.elementAt(i);
            Point3D p1 = tri.p1.wc;
            Point3D p2 = tri.p2.wc;
            Point3D p3 = tri.p3.wc;
            tri.normal = n = Point3D.crossProd(p2.sub(p1), p3.sub(p2));
            ++i;
        }
    }

    void drawVisibleMesh(Graphics2D g2) {
        this.rasterizer.setShadingMode(0);
        this.rasterizer.setColor(COLORBACKGROUND);
        Vector triangles = this.mesh.getTriangles();
        int i = 0;
        while (i < triangles.size()) {
            Triangle tri = (Triangle)triangles.elementAt(i);
            this.rasterizer.setColor(COLORBACKGROUND);
            this.rasterizer.renderTriangle(tri);
            this.rasterizer.setColor(COLORMESH);
            this.rasterizer.drawLine((int)tri.p1.dc.x, (int)tri.p1.dc.y, (int)tri.p2.dc.x, (int)tri.p2.dc.y);
            this.rasterizer.drawLine((int)tri.p3.dc.x, (int)tri.p3.dc.y, (int)tri.p1.dc.x, (int)tri.p1.dc.y);
            this.additionalRendering(tri, g2);
            ++i;
        }
    }

    @Override
    public void prepaintcompute() {
        Vertex3D vertex;
        if (this.mesh == null) {
            return;
        }
        Vector triangles = this.mesh.getTriangles();
        Vector vertices = this.mesh.getVertices();
        int i = 0;
        while (i < vertices.size()) {
            vertex = (Vertex3D)vertices.elementAt(i);
            vertex.dc = this.scene3d.project(vertex.mc);
            vertex.wc = this.scene3d.getWC(vertex.mc);
            ++i;
        }
        i = 0;
        while (i < vertices.size()) {
            vertex = (Vertex3D)vertices.elementAt(i);
            vertex.distance = this.scene3d.calcdepth(vertex.wc);
            ++i;
        }
        i = 0;
        while (i < triangles.size()) {
            Triangle tri = (Triangle)triangles.elementAt(i);
            Point3D a = tri.p1.wc;
            Point3D b = tri.p2.wc;
            Point3D c = tri.p3.wc;
            Point3D center = a.add(b).add(c);
            center.scale(0.3333333333333333);
            tri.distance = this.scene3d.calcdepth(center);
            ++i;
        }
        if (this.colormode == 0) {
            this.computenormals();
        }
        if (this.drawmode != 0) {
            Collections.sort(triangles);
        }
    }

    public void setVertexColorModel(ColorModel model) {
        this.colormodel = model;
        this.calcColors();
    }

    public void setColorMode(int mode) {
        this.colormode = mode;
        if (this.colormode == 1) {
            this.calcColors();
        }
    }

    protected void calcColors() {
        if (this.mesh == null) {
            return;
        }
        CoordinateCube3D limits = this.mesh.getBoundingBox();
        Vector vertices = this.mesh.getVertices();
        this.colormodel.colorVertices(vertices.iterator(), limits);
    }

    private void drawmesh(Graphics2D g2) {
        this.rasterizer.setColor(COLORMESH);
        Vector triangles = this.mesh.getTriangles();
        this.rasterizer.setColor(COLORMESH);
        int i = 0;
        while (i < triangles.size()) {
            Triangle tri = (Triangle)triangles.elementAt(i);
            this.rasterizer.drawLine((int)tri.p1.dc.x, (int)tri.p1.dc.y, (int)tri.p2.dc.x, (int)tri.p2.dc.y);
            this.rasterizer.drawLine((int)tri.p3.dc.x, (int)tri.p3.dc.y, (int)tri.p1.dc.x, (int)tri.p1.dc.y);
            this.additionalRendering(tri, g2);
            ++i;
        }
    }

    public CoordinateCube3D getBoundingBox() {
        if (this.mesh == null) {
            return null;
        }
        return this.mesh.getBoundingBox();
    }

    public CoordinateRect2D getXYLimits() {
        if (this.mesh == null) {
            return null;
        }
        CoordinateCube3D cube = this.mesh.getBoundingBox();
        return new CoordinateRect2D(cube.xmin, cube.xmax, cube.ymin, cube.ymax);
    }

    protected void setAdditionalRendering(AdditionalRendering add) {
        this.addrendering = add;
    }

    private void additionalRendering(Triangle tri, Graphics2D g2) {
        if (this.addrendering != null) {
            this.addrendering.render(tri, g2);
        }
    }
}

