/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.surface3d;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.draw3d.base.Rasterable3D;
import uibk.draw3d.objects.MathArrow3D;
import uibk.draw3d.rasterizer.Rasterizer;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;

public class ArrowZ3D
extends MathArrow3D
implements Rasterable3D {
    Rasterizer rasterizer;

    public ArrowZ3D() {
        this.offsetwings = 3;
        this.lengtharrowhead = 6;
    }

    @Override
    public void setRasterizer(Rasterizer rasterizer) {
        this.rasterizer = rasterizer;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        double depthbase = this.scene3d.calcdepth(this.scene3d.getWC(this.base));
        double depthhead = this.scene3d.calcdepth(this.scene3d.getWC(this.head));
        Punkt2D pBase = this.scene3d.project(this.base);
        Punkt2D pHead = this.scene3d.project(this.head);
        this.drawArrow(pBase, pHead, depthbase, depthhead, this.lengtharrowhead, this.offsetwings);
    }

    private void drawArrow(Punkt2D base, Punkt2D head, double depthbase, double depthhead, int offsetarrow, int offsetwings) {
        this.rasterizer.enableZBuffer(true);
        if (base.equals(head) || !base.isReal() || !head.isReal()) {
            return;
        }
        Vector2D dir = base.sub(head).toVector();
        dir.normalize();
        Vector2D n = dir.normaldir();
        dir.scaleself(offsetarrow);
        n.scaleself(offsetwings);
        Punkt2D s = head.add(dir);
        Punkt2D left = s.add(n);
        Punkt2D right = s.add(Punkt2D.inverse(n));
        this.rasterizer.enableZBuffer(true);
        int c = this.color.getRGB();
        this.rasterizer.plotline(base, head, depthbase, depthhead, c);
        this.rasterizer.plotline(left, head, depthhead, depthhead, c);
        this.rasterizer.plotline(right, head, depthhead, depthhead, c);
    }
}

