/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.rasterizer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.image.BufferedImage;
import uibk.draw3d.rasterizer.Farbe;
import uibk.draw3d.surface3d.Triangle;
import uibk.geom.Punkt2D;
import uibk.lang.Options;
import uibk.math.MathUtil;

public class Rasterizer {
    BufferedImage framebuffer;
    double[][] zbuffer;
    Graphics2D g2;
    public static final int FLAT = 0;
    public static final int GOUROUD = 1;
    int shadingmode = 1;
    int color;
    private boolean usezbuffer;
    private int scanline;
    private double xleft;
    private double xright;
    private Farbe colorleft = new Farbe();
    private Farbe colorright = new Farbe();
    private Farbe currentcolor = new Farbe();
    private Farbe dcolorL = new Farbe();
    private Farbe dcolorR = new Farbe();
    private double depthR;
    private double depthL;
    int a;
    int b;
    Farbe colorL;
    Farbe colorR;
    double dD;
    double depth;
    double ddepthR;
    double ddepthL;
    private Punkt2D top;
    private Punkt2D middle;
    private Punkt2D bottom;
    private Farbe colortop;
    private Farbe colormiddle;
    private Farbe colorbottom;
    private double depthtop;
    private double depthmiddle;
    private double depthbottom;
    int renderhint = 1;
    public static final int RENDER_HINT_SPEED = 0;
    public static final int RENDER_HINT_QUALITY = 1;
    Color col;
    public double maxd;

    public void setShadingMode(int mode) {
        this.shadingmode = mode;
    }

    public int getShadingMode() {
        return this.shadingmode;
    }

    public void setColor(Color color) {
        this.col = color;
        this.color = this.col.getRGB();
    }

    public void setRenderingHint(int hint) {
        if (hint > 1 || hint < 0) {
            throw new IllegalArgumentException("rendering hint not specified");
        }
        this.renderhint = hint;
    }

    public int getRenderingHint() {
        return this.renderhint;
    }

    public void setBuffers(BufferedImage framebuffer, double[][] zbuffer) {
        this.zbuffer = zbuffer;
        this.framebuffer = framebuffer;
        this.g2 = framebuffer.createGraphics();
        Options.setRenderingHints(this.g2);
    }

    public void enableZBuffer(boolean enable) {
        this.usezbuffer = enable;
    }

    private void sortEdges(Triangle triangle) {
        Farbe tempC;
        double tempdepth;
        Punkt2D temp;
        this.top = triangle.p1.dc;
        this.middle = triangle.p2.dc;
        this.bottom = triangle.p3.dc;
        this.colortop = new Farbe(triangle.p1.color);
        this.colormiddle = new Farbe(triangle.p2.color);
        this.colorbottom = new Farbe(triangle.p3.color);
        this.depthtop = triangle.p1.distance;
        this.depthmiddle = triangle.p2.distance;
        this.depthbottom = triangle.p3.distance;
        if (this.top.y > this.middle.y) {
            temp = this.middle;
            this.middle = this.top;
            this.top = temp;
            tempdepth = this.depthmiddle;
            this.depthmiddle = this.depthtop;
            this.depthtop = tempdepth;
            tempC = this.colormiddle;
            this.colormiddle = this.colortop;
            this.colortop = tempC;
        }
        if (this.middle.y > this.bottom.y) {
            temp = this.middle;
            this.middle = this.bottom;
            this.bottom = temp;
            tempdepth = this.depthmiddle;
            this.depthmiddle = this.depthbottom;
            this.depthbottom = tempdepth;
            tempC = this.colormiddle;
            this.colormiddle = this.colorbottom;
            this.colorbottom = tempC;
        }
        if (this.top.y > this.middle.y) {
            temp = this.middle;
            this.middle = this.top;
            this.top = temp;
            tempdepth = this.depthmiddle;
            this.depthmiddle = this.depthtop;
            this.depthtop = tempdepth;
            tempC = this.colormiddle;
            this.colormiddle = this.colortop;
            this.colortop = tempC;
        }
    }

    public void renderTriangle(Triangle tri) {
        double dxR;
        double dxL;
        this.sortEdges(tri);
        int n = this.scanline = (int)this.top.y >= 0 ? (int)this.top.y : 0;
        if ((int)this.top.y == (int)this.middle.y && (int)this.bottom.y == (int)this.top.y) {
            this.xleft = Math.min(Math.min(this.top.x, this.middle.x), this.bottom.x);
            this.xright = Math.max(Math.max(this.top.x, this.middle.x), this.bottom.x);
            if (this.xleft == this.top.x) {
                this.colorleft.set(this.colortop);
                this.depthL = this.depthtop;
            }
            if (this.xleft == this.bottom.x) {
                this.colorleft.set(this.colorbottom);
                this.depthL = this.depthbottom;
            }
            if (this.xleft == this.middle.x) {
                this.colorleft.set(this.colormiddle);
                this.depthL = this.depthmiddle;
            }
            if (this.xright == this.top.x) {
                this.colorright.set(this.colortop);
                this.depthR = this.depthtop;
            }
            if (this.xright == this.bottom.x) {
                this.colorright.set(this.colorbottom);
                this.depthR = this.depthbottom;
            }
            if (this.xright == this.middle.x) {
                this.colorright.set(this.colormiddle);
                this.depthR = this.depthmiddle;
            }
            this.renderline();
            return;
        }
        if (this.middle.y != this.top.y) {
            dxL = (this.middle.x - this.top.x) / (this.middle.y - this.top.y);
            dxR = (this.bottom.x - this.top.x) / (this.bottom.y - this.top.y);
            this.dcolorL = Farbe.sub(this.colormiddle, this.colortop);
            this.dcolorL.mult((float)(1.0 / (this.middle.y - this.top.y)));
            this.dcolorR = Farbe.sub(this.colorbottom, this.colortop);
            this.dcolorR.mult((float)(1.0 / (this.bottom.y - this.top.y)));
            this.xleft = this.top.x;
            this.xright = this.top.x;
            this.colorright.set(this.colortop);
            this.colorleft.set(this.colortop);
            this.depthR = this.depthtop;
            this.depthL = this.depthtop;
            this.ddepthL = (this.depthmiddle - this.depthtop) / (this.middle.y - this.top.y);
            this.ddepthR = (this.depthbottom - this.depthtop) / (this.bottom.y - this.top.y);
            while ((double)this.scanline <= this.middle.y) {
                this.renderline();
                this.xleft += dxL;
                this.xright += dxR;
                this.colorright.add(this.dcolorR);
                this.colorleft.add(this.dcolorL);
                this.depthR += this.ddepthR;
                this.depthL += this.ddepthL;
                ++this.scanline;
            }
        }
        if (this.middle.y != this.bottom.y) {
            this.scanline = (int)this.middle.y;
            dxL = (this.middle.x - this.bottom.x) / (this.middle.y - this.bottom.y);
            dxR = (this.top.x - this.bottom.x) / (this.top.y - this.bottom.y);
            this.dcolorL = Farbe.sub(this.colormiddle, this.colorbottom);
            this.dcolorL.mult((float)(1.0 / (this.middle.y - this.bottom.y)));
            this.dcolorR = Farbe.sub(this.colortop, this.colorbottom);
            this.dcolorR.mult((float)(1.0 / (this.top.y - this.bottom.y)));
            this.xleft = this.middle.x;
            this.xright = this.bottom.x + ((double)this.scanline - this.bottom.y) * dxR;
            this.colorleft.set(this.colormiddle);
            this.colorright = Farbe.interpolate((float)this.top.y, (float)this.bottom.y, this.colortop, this.colorbottom, this.scanline);
            this.ddepthL = (this.depthmiddle - this.depthbottom) / (this.middle.y - this.bottom.y);
            this.ddepthR = (this.depthtop - this.depthbottom) / (this.top.y - this.bottom.y);
            this.depthL = this.depthmiddle;
            this.depthR = this.depthbottom + ((double)this.scanline - this.bottom.y) * this.ddepthR;
            while ((double)this.scanline <= this.bottom.y) {
                this.renderline();
                this.xleft += dxL;
                this.xright += dxR;
                this.colorright.add(this.dcolorR);
                this.colorleft.add(this.dcolorL);
                this.depthR += this.ddepthR;
                this.depthL += this.ddepthL;
                ++this.scanline;
            }
        }
    }

    private void renderline() {
        this.a = (int)this.xleft;
        this.b = (int)this.xright;
        if (this.scanline > this.framebuffer.getHeight() - 1 || this.scanline < 0) {
            return;
        }
        this.colorL = new Farbe(this.colorleft);
        this.colorR = new Farbe(this.colorright);
        if (this.a > this.b) {
            int temp = this.a;
            this.a = this.b;
            this.b = temp;
            double tempdepth = this.depthL;
            this.depthL = this.depthR;
            this.depthR = tempdepth;
            Farbe colortemp = this.colorL;
            this.colorL = this.colorR;
            this.colorR = colortemp;
        }
        if (this.a < 0) {
            this.a = 0;
        }
        if (this.b >= this.framebuffer.getWidth()) {
            this.b = this.framebuffer.getWidth() - 1;
        }
        this.dD = 0.0;
        this.depth = this.depthL;
        if (this.b - this.a != 0) {
            this.dD = (this.depthR - this.depthL) / (double)(this.b - this.a);
        }
        if (this.shadingmode == 0) {
            this.renderlineFlat();
        }
        if (this.shadingmode == 1) {
            this.renderlineGouroud();
        }
    }

    private void renderlineGouroud() {
        int x = this.a;
        this.currentcolor.set(this.colorL);
        Farbe dcolor = new Farbe(0.0f, 0.0f, 0.0f);
        if (this.b - this.a != 0) {
            dcolor.set(Farbe.sub(this.colorR, this.colorL));
            dcolor.mult((float)(1.0 / (double)Math.abs(this.b - this.a)));
        }
        while (x <= this.b) {
            if (!this.usezbuffer || this.depth > this.zbuffer[x][this.scanline]) {
                if (this.depth > this.zbuffer[x][this.scanline]) {
                    this.zbuffer[x][this.scanline] = this.depth;
                }
                this.framebuffer.setRGB(x, this.scanline, this.currentcolor.toInteger());
            }
            this.depth += this.dD;
            this.currentcolor.add(dcolor);
            ++x;
        }
    }

    private void renderlineFlat() {
        int x = this.a;
        while (x <= this.b) {
            if (!this.usezbuffer || this.depth > this.zbuffer[x][this.scanline]) {
                if (this.depth > this.zbuffer[x][this.scanline]) {
                    this.zbuffer[x][this.scanline] = this.depth;
                }
                this.framebuffer.setRGB(x, this.scanline, this.color);
            }
            ++x;
            this.depth += this.dD;
        }
    }

    public void plotline(Punkt2D p1, Punkt2D p2, double pdistance, double qdistance, int color) {
        Point p = new Point((int)p1.x, (int)p1.y);
        Point q = new Point((int)p2.x, (int)p2.y);
        int width = this.framebuffer.getWidth();
        int height = this.framebuffer.getHeight();
        int dx = q.x - p.x;
        int dy = q.y - p.y;
        int incx = dx > 0 ? 1 : -1;
        int incy = dy > 0 ? 1 : -1;
        if (Math.abs(dy) < Math.abs(dx)) {
            int error = -Math.abs(dx);
            int delta = 2 * Math.abs(dy);
            int schwelle = 2 * error;
            while (p.x != q.x) {
                if (p.x >= 0 && p.x < width && p.y >= 0 && p.y < height) {
                    double depth = MathUtil.interpolate((Punkt2D)p1, (Punkt2D)p2, (double)pdistance, (double)qdistance, (Punkt2D)new Punkt2D(p.x, p.y));
                    if (!this.usezbuffer || depth >= this.zbuffer[p.x][p.y]) {
                        this.framebuffer.setRGB(p.x, p.y, color);
                    }
                }
                p.x += incx;
                if ((error += delta) <= 0) continue;
                p.y += incy;
                error += schwelle;
            }
        } else {
            int error = -Math.abs(dy);
            int delta = 2 * Math.abs(dx);
            int schwelle = 2 * error;
            while (p.y != q.y) {
                double depth = MathUtil.interpolate((Punkt2D)p1, (Punkt2D)p2, (double)pdistance, (double)qdistance, (Punkt2D)new Punkt2D(p.x, p.y));
                if (p.x >= 0 && p.x < width && p.y >= 0 && p.y < height && (!this.usezbuffer || depth >= this.zbuffer[p.x][p.y])) {
                    this.framebuffer.setRGB(p.x, p.y, color);
                }
                p.y += incy;
                if ((error += delta) <= 0) continue;
                p.x += incx;
                error += schwelle;
            }
        }
    }

    private void plotline(int px, int py, int qx, int qy) {
        int dx = qx - px;
        int dy = qy - py;
        int incx = dx > 0 ? 1 : -1;
        int incy = dy > 0 ? 1 : -1;
        if (Math.abs(dy) < Math.abs(dx)) {
            int error = -Math.abs(dx);
            int delta = 2 * Math.abs(dy);
            int schwelle = 2 * error;
            while (px != qx) {
                this.framebuffer.setRGB(px, py, this.color);
                px += incx;
                if ((error += delta) <= 0) continue;
                py += incy;
                error += schwelle;
            }
        } else {
            int error = -Math.abs(dy);
            int delta = 2 * Math.abs(dx);
            int schwelle = 2 * error;
            while (py != qy) {
                this.framebuffer.setRGB(px, py, this.color);
                py += incy;
                if ((error += delta) <= 0) continue;
                px += incx;
                error += schwelle;
            }
        }
    }

    public void drawLine(int px, int py, int qx, int qy) {
        switch (this.renderhint) {
            case 0: {
                this.plotline(px, py, qx, qy);
                break;
            }
            case 1: {
                this.g2.setColor(this.col);
                this.g2.drawLine(px, py, qx, qy);
                break;
            }
        }
    }
}

