/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.util.LineClipping2D;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.util.LineClipping3D;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector3D;
import uibk.lang.PrepaintComputable;

public class Polyeder3D
extends Drawable3D
implements PrepaintComputable {
    Color colorhiddenedge = new Color(100, 100, 100, 100);
    Color colorvisibleedge = Color.black;
    Stroke strokehiddenedge;
    Stroke strokevisibleedge = new BasicStroke();
    protected Point3D[] wc_vertices;
    boolean drawhiddenedges = true;
    protected Point3D[] mc_vertices;
    protected Punkt2D[] dc_vertices;
    protected Edge[] edges;
    protected Face[] faces;

    Polyeder3D(Point3D[] vertices, Edge[] edges, Face[] faces) {
        this();
        this.mc_vertices = vertices;
        this.edges = edges;
        this.faces = faces;
    }

    Polyeder3D(double[][] vertices, int[][] e, int[][] f) {
        this();
        int nedges = e.length;
        this.edges = new Edge[nedges];
        int i = 0;
        while (i < nedges) {
            this.edges[i] = new Edge(e[i][0], e[i][1]);
            ++i;
        }
        int nfaces = f.length;
        this.faces = new Face[nfaces];
        int i2 = 0;
        while (i2 < nfaces) {
            this.faces[i2] = new Face();
            int j = 0;
            while (j < f[i2].length) {
                this.faces[i2].addPoint(f[i2][j]);
                ++j;
            }
            ++i2;
        }
        int nvertices = vertices.length;
        this.mc_vertices = new Point3D[nvertices];
        int i3 = 0;
        while (i3 < nvertices) {
            this.mc_vertices[i3] = new Point3D(vertices[i3][0], vertices[i3][1], vertices[i3][2]);
            ++i3;
        }
    }

    Polyeder3D() {
        float[] dash = new float[]{10.0f};
        this.strokehiddenedge = new BasicStroke(1.0f, 0, 0, 10.0f, dash, 0.0f);
    }

    @Override
    public void prepaintcompute() {
        if (this.wc_vertices == null) {
            this.wc_vertices = new Point3D[this.mc_vertices.length];
        }
        if (this.dc_vertices == null) {
            this.dc_vertices = new Punkt2D[this.mc_vertices.length];
        }
        int i = 0;
        while (i < this.mc_vertices.length) {
            this.wc_vertices[i] = this.scene3d.getWC(this.mc_vertices[i]);
            ++i;
        }
        i = 0;
        while (i < this.mc_vertices.length) {
            this.dc_vertices[i] = this.scene3d.project(this.mc_vertices[i]);
            ++i;
        }
        Point3D camera = this.scene3d.getCamera();
        int i2 = 0;
        while (i2 < this.faces.length) {
            this.faces[i2].checkVisibility(camera);
            ++i2;
        }
        i2 = 0;
        while (i2 < this.edges.length) {
            this.edges[i2].checkVisibility();
            ++i2;
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        Stroke old = g2.getStroke();
        Rectangle clippingrect = new Rectangle(0, 0, this.panel.getWidth(), this.panel.getHeight());
        double yc = this.scene3d.getClippingPlane();
        Point3D ca = new Point3D();
        Point3D cb = new Point3D();
        Point p = new Point();
        Point q = new Point();
        int i = 0;
        while (i < this.edges.length) {
            Edge e = this.edges[i];
            if (!e.hidden || this.drawhiddenedges) {
                Point p2;
                Point p1;
                if (e.hidden) {
                    g2.setStroke(this.strokehiddenedge);
                    g2.setColor(this.colorhiddenedge);
                } else {
                    g2.setStroke(this.strokevisibleedge);
                    g2.setColor(this.colorvisibleedge);
                }
                Point3D a = this.wc_vertices[e.p1];
                Point3D b = this.wc_vertices[e.p2];
                if (this.scene3d.isClippingEnabled()) {
                    if (LineClipping3D.clipline3d(a, b, ca, cb, yc) && LineClipping2D.cohensutherland(p1 = this.scene3d.wctoDevice(ca), p2 = this.scene3d.wctoDevice(cb), p, q, clippingrect)) {
                        g2.drawLine(p.x, p.y, q.x, q.y);
                    }
                } else {
                    p1 = this.scene3d.wctoDevice(a);
                    p2 = this.scene3d.wctoDevice(b);
                    g2.drawLine(p1.x, p1.y, p2.x, p2.y);
                }
            }
            ++i;
        }
        g2.setStroke(old);
    }

    public void setSrokeVisibleEdge(Stroke stroke) {
        this.strokevisibleedge = stroke;
    }

    public void setSrokeHiddenEdge(Stroke stroke) {
        this.strokehiddenedge = stroke;
    }

    public void setColorVisibleEdge(Color color) {
        this.colorvisibleedge = color;
    }

    public void setColorHiddenEdge(Color color) {
        this.colorhiddenedge = color;
    }

    public void drawHiddenEdges(boolean draw) {
        this.drawhiddenedges = draw;
    }

    public void setVertices(Point3D[] vertices) {
        this.mc_vertices = vertices;
    }

    public class Edge {
        public int p1;
        public int p2;
        public boolean hidden = true;

        Edge(int p1, int p2) {
            this.p1 = p1;
            this.p2 = p2;
        }

        void checkVisibility() {
            this.hidden = true;
            int i = 0;
            while (i < Polyeder3D.this.faces.length) {
                if (Polyeder3D.this.faces[i].containsEdge(this) && !Polyeder3D.this.faces[i].hidden) {
                    this.hidden = false;
                    break;
                }
                ++i;
            }
        }
    }

    protected class Face {
        boolean hidden = true;
        Vector indices = new Vector();

        protected Face() {
        }

        void addPoint(int i) {
            this.indices.add(new Integer(i));
        }

        public boolean containsEdge(Edge e) {
            int i = 0;
            while (i < this.indices.size()) {
                int j = i < this.indices.size() - 1 ? i + 1 : 0;
                int index_p1 = (Integer)this.indices.elementAt(i);
                int index_p2 = (Integer)this.indices.elementAt(j);
                if (index_p1 == e.p1 && index_p2 == e.p2 || index_p1 == e.p2 && index_p2 == e.p1) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public Vector3D getSurfaceNormalWC() {
            Point3D p1 = Polyeder3D.this.wc_vertices[(Integer)this.indices.elementAt(0)];
            Point3D p2 = Polyeder3D.this.wc_vertices[(Integer)this.indices.elementAt(1)];
            Point3D p3 = Polyeder3D.this.wc_vertices[(Integer)this.indices.elementAt(2)];
            Vector3D n = Vector3D.crossProd(p1.sub(p2), p3.sub(p2));
            n.normalize();
            return n;
        }

        public Vector3D getSurfaceNormalMC() {
            Point3D p1 = Polyeder3D.this.mc_vertices[(Integer)this.indices.elementAt(0)];
            Point3D p2 = Polyeder3D.this.mc_vertices[(Integer)this.indices.elementAt(1)];
            Point3D p3 = Polyeder3D.this.mc_vertices[(Integer)this.indices.elementAt(2)];
            Vector3D n = Vector3D.crossProd(p1.sub(p2), p3.sub(p2));
            n.normalize();
            return n;
        }

        void checkVisibility(Point3D camera) {
            Vector3D n = this.getSurfaceNormalWC();
            Point3D surfacepoint = Polyeder3D.this.wc_vertices[(Integer)this.indices.elementAt(0)];
            this.hidden = Polyeder3D.this.scene3d.getProjectionType() == 0 ? Vector3D.dotProd(camera.sub(surfacepoint), n) < 0.0 : n.x2 < 0.0;
        }
    }
}

