/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.objects;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.draw2d.util.MiscDrawing2D;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.util.LineClipping3D;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;

public class MathArrow3D
extends Drawable3D {
    protected Point3D base = new Point3D();
    protected Point3D head = new Point3D();
    protected int lengtharrowhead = 10;
    protected int offsetwings = 5;

    public void setLengthArrowHead(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("L\u00e4nge muss positiv sein");
        }
        this.lengtharrowhead = length;
    }

    public void setOffsetWings(int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("L\u00e4nge muss positiv sein");
        }
        this.lengtharrowhead = length;
    }

    public MathArrow3D(Point3D base, Point3D head) {
        base.setLocation(base);
        head.setLocation(head);
    }

    public MathArrow3D() {
        this.head.x1 = 1.0;
    }

    public Point3D getHead() {
        return this.head;
    }

    public Point3D getBase() {
        return this.base;
    }

    public void setBase(Point3D base) {
        this.base.setLocation(base);
    }

    public void setHead(Point3D head) {
        this.head.setLocation(head);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        Point3D cbase = new Point3D();
        Point3D chead = new Point3D();
        Point3D wc_base = this.scene3d.getWC(this.base);
        Point3D wc_head = this.scene3d.getWC(this.head);
        if (LineClipping3D.clipline3d(wc_base, wc_head, cbase, chead, this.scene3d.getClippingPlane())) {
            Punkt2D phead = new Punkt2D(this.scene3d.wctoDevice(chead));
            Punkt2D pbase = new Punkt2D(this.scene3d.wctoDevice(cbase));
            MiscDrawing2D.drawArrow(g2, pbase, phead, this.lengtharrowhead, this.offsetwings);
        }
    }
}

