/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.base.MathPanel3D;
import uibk.draw3d.objects.MathArrow3D;
import uibk.draw3d.objects.MathPoint3D;
import uibk.geom.Point3D;
import uibk.geom.Vector3D;
import uibk.lang.PrepaintComputable;
import uibk.math.Interval;
import uibk.math.Settings;
import uibk.math.functions.ParametricCurve3D;
import uibk.mathparsing.Misc;
import uibk.text.Formatter;

public class Dreibein
extends Drawable3D
implements PrepaintComputable {
    Formatter formatter = new Formatter();
    ParametricCurve3D curve;
    double parameterpos = 0.0;
    MathArrow3D arrowVelocity = new MathArrow3D();
    MathArrow3D arrowAcceleration = new MathArrow3D();
    MathArrow3D arrowNormal = new MathArrow3D();
    MathPoint3D basepoint = new MathPoint3D();
    int mode;
    public static final int DRAW_VELOCITY = 0;
    public static final int DRAW_VELOCITY_AND_ACCELERATION = 1;
    public static final int DRAW_DREIBEIN = 2;
    Vector3D velocity = new Vector3D();
    Vector3D acceleration = new Vector3D();
    Vector3D normal = new Vector3D();
    Interval interval;

    public void setMode(int style) {
        this.mode = style;
    }

    public Dreibein(ParametricCurve3D curve) {
        this.curve = curve;
        this.arrowVelocity.setColor(Color.blue);
        this.arrowAcceleration.setColor(Color.green);
        this.arrowNormal.setColor(Color.orange);
        this.basepoint.setColor(Color.blue);
        this.draw = false;
    }

    public int getMode() {
        return this.mode;
    }

    private Vector3D calcVelocityVector() throws Exception {
        Vector3D velocity;
        try {
            velocity = this.curve.velocityVector(this.parameterpos);
        }
        catch (Exception ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
        double normx = Math.sqrt(velocity.x1 * velocity.x1);
        double normy = Math.sqrt(velocity.x2 * velocity.x2);
        double normz = Math.sqrt(velocity.x3 * velocity.x3);
        if (normx <= Settings.getMachinePrecision() * this.scene3d.getBoundingBox().getXRange() && normy <= Settings.getMachinePrecision() * this.scene3d.getBoundingBox().getXRange() && normz <= Settings.getMachinePrecision() * this.scene3d.getBoundingBox().getZRange()) {
            this.draw = false;
            double dist = this.scene3d.getBoundingBox().minBoundingBox() / 1000.0;
            throw new Exception("Singul\u00e4rer Punkt bei t=" + String.valueOf(this.formatter.commonformat(this.parameterpos, dist)));
        }
        return velocity;
    }

    private Vector3D calcAccelerationVector() throws Exception {
        Vector3D acceleration;
        try {
            acceleration = this.curve.accelerationVector(this.parameterpos);
        }
        catch (Exception ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
        return acceleration;
    }

    @Override
    public void prepaintcompute() throws Exception {
        Point3D base = this.curve.calcPoint(this.parameterpos);
        this.draw = true;
        this.basepoint.setCoordinates(base);
        switch (this.mode) {
            case 0: {
                this.velocity = this.calcVelocityVector();
                Point3D headV = base.add(this.velocity);
                this.arrowVelocity.setBase(base);
                this.arrowVelocity.setHead(headV);
                break;
            }
            case 1: {
                this.velocity = this.calcVelocityVector();
                Point3D headV = base.add(this.velocity);
                this.arrowVelocity.setBase(base);
                this.arrowVelocity.setHead(headV);
                this.acceleration = this.calcAccelerationVector();
                Point3D headA = base.add(this.acceleration);
                this.arrowAcceleration.setBase(base);
                this.arrowAcceleration.setHead(headA);
                break;
            }
            case 2: {
                this.velocity = this.calcVelocityVector();
                this.acceleration = this.calcAccelerationVector();
                this.normal = Vector3D.crossProd(this.velocity, this.acceleration);
                this.velocity.normalize();
                this.acceleration.normalize();
                this.normal.normalize();
                double scale = this.scene3d.getBoundingBox().maxBoundingBox() / 2.0;
                this.velocity.scale(scale);
                this.acceleration.scale(scale);
                this.normal.scale(scale);
                Point3D headV = base.add(this.velocity);
                Point3D headA = base.add(this.acceleration);
                Point3D headN = base.add(this.normal);
                this.arrowVelocity.setBase(base);
                this.arrowVelocity.setHead(headV);
                this.arrowAcceleration.setBase(base);
                this.arrowAcceleration.setHead(headA);
                this.arrowNormal.setBase(base);
                this.arrowNormal.setHead(headN);
            }
        }
    }

    public Vector3D getAccelerationVector() {
        return this.acceleration;
    }

    public Vector3D getVelocityVector() {
        return this.velocity;
    }

    public Vector3D getNormalVector() {
        return this.normal;
    }

    public double getParameterPos() {
        return this.parameterpos;
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        switch (this.mode) {
            case 0: {
                this.arrowVelocity.draw(framebuffer, g2);
                break;
            }
            case 1: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.arrowAcceleration.draw(framebuffer, g2);
                break;
            }
            case 2: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.arrowAcceleration.draw(framebuffer, g2);
                this.arrowNormal.draw(framebuffer, g2);
                break;
            }
        }
        this.basepoint.draw(framebuffer, g2);
    }

    @Override
    public void setMathPanel3d(MathPanel3D panel) {
        super.setMathPanel3d(panel);
        this.arrowVelocity.setMathPanel3d(panel);
        this.arrowAcceleration.setMathPanel3d(panel);
        this.arrowNormal.setMathPanel3d(panel);
        this.basepoint.setMathPanel3d(panel);
    }

    public void setParameterPos(double param) {
        this.parameterpos = param;
    }

    public void setParameterPos(String param) throws Exception {
        double pos;
        try {
            pos = Misc.parseConstantExpr((String)param);
        }
        catch (Exception ex) {
            throw new Exception("Parameter t ist keine reelle Zahl");
        }
        if (pos < this.interval.a || pos > this.interval.b) {
            throw new Exception("Der Parameter muss im Intervall " + this.interval.toString() + " liegen");
        }
        this.parameterpos = pos;
    }

    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }
}

