/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw3d.axescube3d;

import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import uibk.draw3d.axescube3d.AxesCube3D;
import uibk.draw3d.base.Drawable3D;
import uibk.draw3d.base.Scene3D;
import uibk.geom.Point3D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.geom.Vector3D;
import uibk.lang.PrepaintComputable;

public class Tick
extends Drawable3D
implements PrepaintComputable {
    Point3D mc_pos;
    Vector3D mc_dir;
    AxesCube3D axes;
    boolean draw = false;
    boolean big = false;
    Punkt2D start;
    Punkt2D end;
    Punkt2D labelpos;
    Scene3D coords3d;
    String label;
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private static final byte BOTTOM = 4;
    private static final byte TOP = 8;

    public Tick(AxesCube3D axes, Scene3D coords3d, Point3D posmc, Vector3D dirmc, boolean big, String label) {
        this.coords3d = coords3d;
        this.mc_pos = posmc;
        this.mc_dir = dirmc;
        this.big = big;
        this.axes = axes;
        this.label = label;
    }

    void drawLabel(Graphics2D g2) {
        g2.drawString(this.label, (int)this.labelpos.x, (int)this.labelpos.y);
    }

    void checkIntersection(Graphics g2) {
        FontMetrics metrics = g2.getFontMetrics();
        int height = metrics.getAscent();
        int length = metrics.stringWidth(this.label);
        Rectangle r = new Rectangle((int)this.labelpos.x, (int)this.labelpos.y - height, length, height);
        this.axes.labelarea.add(r);
        int i = 0;
        while (i < this.axes.labelarea.size() - 1) {
            Rectangle2D rect = (Rectangle2D)this.axes.labelarea.elementAt(i);
            if (r.intersects(rect)) {
                this.draw = false;
                break;
            }
            ++i;
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        g2.setColor(this.color);
        if (this.big && this.visible && this.draw) {
            this.drawLabel(g2);
        }
        g2.drawLine((int)this.start.x, (int)this.start.y, (int)this.end.x, (int)this.end.y);
    }

    @Override
    public void prepaintcompute() {
        this.draw = true;
        this.start = this.coords3d.project(this.mc_pos);
        Point3D start_wc = this.coords3d.getWC(this.mc_pos);
        if (start_wc.x2 > this.scene3d.getClippingPlane()) {
            this.draw = false;
        }
        Vector2D tickdir = this.scene3d.projectVector(this.mc_pos, this.mc_dir);
        double scale = this.big ? 8 : 4;
        this.end = this.start.add(tickdir.scale(scale));
        if (this.big) {
            Graphics2D g2 = (Graphics2D)this.panel.getGraphics();
            FontMetrics metrics = g2.getFontMetrics();
            int height = metrics.getHeight();
            int length = metrics.stringWidth(this.label);
            Punkt2D dirn = new Punkt2D(tickdir);
            dirn.normalize();
            tickdir.normalize();
            byte direction = this.getDirection(tickdir);
            double offsetx = 0.0;
            double offsety = 0.0;
            offsety = (8 & direction) > 0 ? (double)(13 + height) : 13.0;
            offsetx = (2 & direction) > 0 ? 13.0 : (double)(13 + length);
            tickdir.x *= offsetx;
            tickdir.y *= offsety;
            this.labelpos = this.start.add(tickdir);
            this.checkIntersection(g2);
        }
    }

    byte getDirection(Vector2D dir) {
        byte code = 0;
        if (dir.x > 0.0) {
            code = 2;
        }
        if (dir.x < 0.0) {
            code = 1;
        }
        if (dir.y > 0.0) {
            code = (byte)(code | 8);
        }
        if (dir.y < 0.0) {
            code = (byte)(code | 4);
        }
        return code;
    }
}

