/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.util;

import java.awt.Point;
import java.awt.Rectangle;
import uibk.geom.CoordinateRect2D;
import uibk.geom.Punkt2D;

public final class LineClipping2D {
    private static final byte EMPTY = 0;
    private static final byte LEFT = 1;
    private static final byte RIGHT = 2;
    private static final byte BOTTOM = 4;
    private static final byte TOP = 8;

    private LineClipping2D() {
    }

    private static byte regioncode(long px, long py, Rectangle rect) {
        byte code = 0;
        int xmin = rect.x;
        int xmax = rect.x + rect.width;
        int ymin = rect.y;
        int ymax = rect.y + rect.height;
        if (px < (long)xmin) {
            code = 1;
        }
        if (px > (long)xmax) {
            code = 2;
        }
        if (py > (long)ymax) {
            code = (byte)(code | 8);
        }
        if (py < (long)ymin) {
            code = (byte)(code | 4);
        }
        return code;
    }

    private static byte regioncode(Punkt2D p, CoordinateRect2D rect) {
        byte code = 0;
        if (p.x < rect.xmin) {
            code = 1;
        }
        if (p.x > rect.xmax) {
            code = 2;
        }
        if (p.y > rect.ymax) {
            code = (byte)(code | 8);
        }
        if (p.y < rect.ymin) {
            code = (byte)(code | 4);
        }
        return code;
    }

    public static boolean cohensutherland(Point a, Point b, Point p, Point q, Rectangle rect) {
        int count = 0;
        if (Double.isInfinite(a.x) || Double.isNaN(a.y) || Double.isInfinite(b.x) || Double.isNaN(b.y)) {
            return false;
        }
        int xmin = rect.x;
        int xmax = rect.x + rect.width;
        int ymin = rect.y;
        int ymax = rect.y + rect.height;
        long px = a.x;
        long py = a.y;
        long qx = b.x;
        long qy = b.y;
        byte c1 = LineClipping2D.regioncode(px, py, rect);
        byte c2 = LineClipping2D.regioncode(qx, qy, rect);
        boolean finiteslope = px != qx;
        long ax = 0L;
        long ay = 0L;
        double slope = 0.0;
        if (finiteslope) {
            slope = (double)(qy - py) / (double)(qx - px);
        }
        while (c1 != 0 || c2 != 0) {
            byte c;
            if ((c1 & c2) != 0) {
                return false;
            }
            byte by = c = c1 == 0 ? c2 : c1;
            if ((c & 1) != 0) {
                ax = xmin;
                ay = (long)((double)py + (double)(ax - px) * slope);
            }
            if ((c & 2) != 0) {
                ax = xmax;
                ay = (long)((double)py + (double)(ax - px) * slope);
            }
            if ((c & 4) != 0) {
                ay = ymin;
                ax = finiteslope ? (long)((double)px + (double)(ay - py) / slope) : px;
            }
            if ((c & 8) != 0) {
                ay = ymax;
                ax = finiteslope ? (long)((double)px + (double)(ay - py) / slope) : px;
            }
            if (c == c1) {
                px = ax;
                py = ay;
                c1 = LineClipping2D.regioncode(px, py, rect);
            } else {
                qx = ax;
                qy = ay;
                c2 = LineClipping2D.regioncode(qx, qy, rect);
            }
            ++count;
        }
        p.x = (int)px;
        p.y = (int)py;
        q.x = (int)qx;
        q.y = (int)qy;
        return true;
    }

    public static boolean cohensutherland(Punkt2D p, Punkt2D q, Punkt2D u, Punkt2D v, CoordinateRect2D rect) {
        if (Double.isInfinite(u.x) || Double.isNaN(u.y) || Double.isInfinite(v.x) || Double.isNaN(v.x)) {
            return false;
        }
        double xmin = rect.xmin;
        double xmax = rect.xmax;
        double ymin = rect.ymin;
        double ymax = rect.ymax;
        u.x = p.x;
        u.y = p.y;
        v.x = q.x;
        v.y = q.y;
        byte c1 = LineClipping2D.regioncode(u, rect);
        byte c2 = LineClipping2D.regioncode(v, rect);
        boolean finiteslope = u.x != v.x;
        Punkt2D a = new Punkt2D();
        double slope = 0.0;
        if (finiteslope) {
            slope = (v.y - u.y) / (v.x - u.x);
        }
        while (c1 != 0 || c2 != 0) {
            byte c;
            if ((c1 & c2) != 0) {
                return false;
            }
            byte by = c = c1 == 0 ? c2 : c1;
            if ((c & 1) != 0) {
                a.x = xmin;
                a.y = u.y + (a.x - u.x) * slope;
            }
            if ((c & 2) != 0) {
                a.x = xmax;
                a.y = u.y + (a.x - u.x) * slope;
            }
            if ((c & 4) != 0) {
                a.y = ymin;
                a.x = finiteslope ? u.x + (a.y - u.y) / slope : u.x;
            }
            if ((c & 8) != 0) {
                a.y = ymax;
                a.x = finiteslope ? u.x + (a.y - u.y) / slope : u.x;
            }
            if (c == c1) {
                u.x = a.x;
                u.y = a.y;
                c1 = LineClipping2D.regioncode(u, rect);
                continue;
            }
            v.x = a.x;
            v.y = a.y;
            c2 = LineClipping2D.regioncode(v, rect);
        }
        return true;
    }
}

