/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.base.MathPanel2D;
import uibk.draw2d.objects.FixedArrow2D;
import uibk.draw2d.objects.MathArrow2D;
import uibk.draw2d.objects.MathPoint2D;
import uibk.geom.Punkt2D;
import uibk.geom.Vector2D;
import uibk.lang.PrepaintComputable;
import uibk.math.Interval;
import uibk.math.functions.ParametricCurve2D;
import uibk.mathparsing.Misc;
import uibk.text.Formatter;

public class Zweibein
extends Drawable2D
implements PrepaintComputable {
    ParametricCurve2D curve;
    double parameterpos = 0.0;
    Formatter formattter = new Formatter();
    Vector2D velocity = new Vector2D();
    Vector2D acceleration = new Vector2D();
    Vector2D normal = new Vector2D();
    MathArrow2D arrowVelocity = new MathArrow2D();
    MathArrow2D arrowAcceleration = new MathArrow2D();
    FixedArrow2D arrowVelocityFixed = new FixedArrow2D();
    FixedArrow2D arrowNormalFixed = new FixedArrow2D();
    MathPoint2D basepoint = new MathPoint2D();
    int mode;
    public static final int DRAW_VELOCITY = 0;
    public static final int DRAW_ZWEIBEIN = 1;
    public static final int DRAW_VELOCITY_AND_ACCELERATION = 2;
    Interval interval;

    public void setMode(int style) {
        this.mode = style;
    }

    public void setInterval(Interval interval) {
        this.interval = interval;
    }

    public Zweibein(ParametricCurve2D curve) {
        this.curve = curve;
        this.arrowVelocity.setColor(Color.blue);
        this.arrowAcceleration.setColor(Color.green);
        this.arrowVelocityFixed.setColor(Color.blue);
        this.arrowNormalFixed.setColor(Color.green);
        this.basepoint.setColor(Color.blue);
        this.basepoint.setRadius(2);
    }

    public Vector2D getAccelerationVector() {
        return this.acceleration;
    }

    public Vector2D getVelocityVector() {
        return this.velocity;
    }

    public Vector2D getNormalVector() {
        return this.normal;
    }

    private Vector2D calcVelocityVector() throws Exception {
        Vector2D dirV;
        try {
            dirV = this.curve.velocityVector(this.parameterpos);
        }
        catch (Exception ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
        double normx = Math.sqrt(dirV.x * dirV.x);
        double normy = Math.sqrt(dirV.y * dirV.y);
        if (normx <= this.curve.getOrdnungFirstDeriv() * this.scene2d.getXRange() * 100.0 && normy <= this.curve.getOrdnungFirstDeriv() * this.scene2d.getYRange() * 100.0) {
            this.draw = false;
            double dist = this.scene2d.getMinRange() / 1.0E7;
            throw new Exception("Singul\u00e4rer Punkt bei t=" + String.valueOf(this.formattter.commonformat(this.parameterpos, dist)));
        }
        return dirV;
    }

    private Vector2D calcAccelerationVector() throws Exception {
        try {
            return this.curve.accelerationVector(this.parameterpos);
        }
        catch (Exception ex) {
            this.draw = false;
            throw new Exception(ex.getMessage());
        }
    }

    @Override
    public void prepaintcompute() throws Exception {
        this.draw = true;
        Punkt2D base = this.curve.calcPoint(this.parameterpos);
        this.basepoint.setCoordinates(base);
        switch (this.mode) {
            case 0: {
                this.velocity = this.calcVelocityVector();
                this.arrowVelocity.setBase(base);
                Punkt2D headV = base.add(this.velocity);
                this.arrowVelocity.setHead(headV);
                this.arrowVelocity.prepaintcompute();
                break;
            }
            case 2: {
                this.velocity = this.calcVelocityVector();
                this.arrowVelocity.setBase(base);
                Punkt2D headV = base.add(this.velocity);
                this.arrowVelocity.setHead(headV);
                this.arrowVelocity.prepaintcompute();
                this.acceleration = this.calcAccelerationVector();
                Punkt2D headA = base.add(this.acceleration);
                this.arrowAcceleration.setBase(base);
                this.arrowAcceleration.setHead(headA);
                this.arrowAcceleration.prepaintcompute();
                break;
            }
            case 1: {
                this.velocity = this.calcVelocityVector();
                this.arrowVelocityFixed.setBase(base);
                this.arrowVelocityFixed.setDirection(this.velocity);
                this.arrowVelocityFixed.setLength(this.panel.getWidth() / 5);
                this.arrowVelocityFixed.prepaintcompute();
                this.normal = new Vector2D(-this.velocity.y, this.velocity.x);
                this.arrowNormalFixed.setBase(base);
                this.arrowNormalFixed.setDirection(this.normal);
                this.arrowNormalFixed.setLength(this.panel.getWidth() / 5);
                this.arrowNormalFixed.prepaintcompute();
            }
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        if (!this.draw) {
            return;
        }
        switch (this.mode) {
            case 0: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.basepoint.draw(framebuffer, g2);
                break;
            }
            case 2: {
                this.arrowVelocity.draw(framebuffer, g2);
                this.arrowAcceleration.draw(framebuffer, g2);
                this.basepoint.draw(framebuffer, g2);
                break;
            }
            case 1: {
                this.arrowNormalFixed.draw(framebuffer, g2);
                this.arrowVelocityFixed.draw(framebuffer, g2);
                this.basepoint.draw(framebuffer, g2);
                break;
            }
        }
    }

    @Override
    public void setMathPanel2d(MathPanel2D panel) {
        super.setMathPanel2d(panel);
        this.arrowVelocity.setMathPanel2d(panel);
        this.arrowVelocityFixed.setMathPanel2d(panel);
        this.arrowNormalFixed.setMathPanel2d(panel);
        this.arrowAcceleration.setMathPanel2d(panel);
        this.basepoint.setMathPanel2d(panel);
    }

    public void setParameterPos(double param) {
        this.parameterpos = param;
    }

    public void setParameterPos(String param) throws Exception {
        double pos;
        try {
            pos = Misc.parseConstantExpr((String)param);
        }
        catch (Exception ex) {
            throw new Exception("Parameter t ist keine reelle Zahl");
        }
        if (pos < this.interval.a || pos > this.interval.b) {
            throw new Exception("Der Parameter muss im Intervall " + this.interval.toString() + " liegen");
        }
        this.parameterpos = pos;
    }

    public int getMode() {
        return this.mode;
    }

    public double getParameterPos() {
        return this.parameterpos;
    }
}

