/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.base.MathPanel2D;
import uibk.draw2d.objects.MathPoint2D;
import uibk.geom.CoordinateRect2D;
import uibk.lang.ToolTipable;
import uibk.math.MathUtil;

public class PointPlot2D
extends Drawable2D
implements ToolTipable {
    protected Color linecolor;
    protected Color pointcolor;
    protected int pointradius = 2;
    protected boolean tooltipenabled = true;
    protected Vector points = new Vector();
    protected double xmin;
    protected double xmax;
    protected double ymin;
    protected double ymax;
    protected Stroke stroke;
    boolean connectpoints = false;

    public void connectPoints(boolean enable) {
        this.connectpoints = enable;
    }

    public void setPointRadius(int pointradius) {
        this.pointradius = pointradius;
    }

    public void setLineColor(Color linecolor) {
        this.linecolor = linecolor;
    }

    public void setPointColor(Color pointcolor) {
        this.pointcolor = pointcolor;
        int i = 0;
        while (i < this.points.size()) {
            ((MathPoint2D)this.points.elementAt(i)).setColor(pointcolor);
            ++i;
        }
    }

    public void clear() {
        this.points.clear();
    }

    public boolean tooltipcontains(int x, int y) {
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(x, y)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getToolTipText(MouseEvent ev) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            MathPoint2D p = (MathPoint2D)this.points.elementAt(i);
            if (p.tooltipcontains(ev.getX(), ev.getY())) {
                return "(" + p.getX() + "," + p.getY() + ")";
            }
            ++i;
        }
        return null;
    }

    public void setToolTipText(String tooltip) {
    }

    public boolean isToolTipEnabled() {
        return this.tooltipenabled;
    }

    public void enableToolTip(boolean enabled) {
        this.tooltipenabled = enabled;
    }

    @Override
    public void setMathPanel2d(MathPanel2D panel) {
        super.setMathPanel2d(panel);
        int ct = this.points.size();
        int i = 0;
        while (i < ct) {
            ((Drawable2D)this.points.elementAt(i)).setMathPanel2d(panel);
            ++i;
        }
    }

    public PointPlot2D() {
        this.linecolor = Color.blue;
        this.pointcolor = Color.red;
        this.stroke = new BasicStroke(1.0f);
    }

    public void setPoints(double[] x, double[] y) {
        this.points.clear();
        this.ymax = MathUtil.max((double[])y);
        this.ymin = MathUtil.min((double[])y);
        this.xmax = MathUtil.max((double[])x);
        this.xmin = MathUtil.min((double[])x);
        int i = 0;
        while (i < x.length) {
            MathPoint2D temp = new MathPoint2D(x[i], y[i]);
            temp.setMathPanel2d(this.panel);
            temp.setRadius(this.pointradius);
            temp.setColor(this.pointcolor);
            this.points.add(temp);
            ++i;
        }
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int size = this.points.size();
        int i = 0;
        while (i < size) {
            Drawable2D d = (Drawable2D)this.points.elementAt(i);
            if (d.getVisible()) {
                if (i < size - 1) {
                    MathPoint2D start = (MathPoint2D)this.points.elementAt(i);
                    MathPoint2D end = (MathPoint2D)this.points.elementAt(i + 1);
                    g2.setColor(this.linecolor);
                    g2.setStroke(this.stroke);
                    if (this.connectpoints) {
                        g2.drawLine(this.scene2d.xToPixel(start.getX()), this.scene2d.yToPixel(start.getY()), this.scene2d.xToPixel(end.getX()), this.scene2d.yToPixel(end.getY()));
                    }
                }
                d.draw(framebuffer, g2);
            }
            ++i;
        }
    }

    public CoordinateRect2D getLimits() {
        return new CoordinateRect2D(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
    }
}

