/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.objects;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.Vector;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.objects.MathArrow2D;
import uibk.geom.Punkt2D;
import uibk.lang.PrepaintComputable;
import uibk.mathobjects.VectorField2D;
import uibk.util.Grid2D;

public class GraphVectorField2D
extends Drawable2D
implements PrepaintComputable {
    int gridx;
    int gridy;
    VectorField2D vectorfield2d;
    Vector arrows = new Vector();
    public static final int ARROWS_SAME_LENGTH = 0;
    public static final int ARROWS_SCALED_LENGTH = 1;
    private int mode = 0;
    double vectorfield_xmin = -1.0;
    double vectorfield_xmax = 1.0;
    double vectorfield_ymin = -1.0;
    double vectorfield_ymax = -1.0;
    private double xmin;
    private double xmax;
    private double ymin;
    private double ymax;

    public GraphVectorField2D(VectorField2D vectorfield2d) {
        this.vectorfield2d = vectorfield2d;
        this.vectorfield_xmin = -1.0;
        this.vectorfield_xmax = 1.0;
        this.vectorfield_ymin = -1.0;
        this.vectorfield_ymax = 1.0;
        this.xmin = this.vectorfield_xmin;
        this.xmax = this.vectorfield_xmax;
        this.ymin = this.vectorfield_ymin;
        this.ymax = this.vectorfield_ymax;
        this.color = Color.red;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getYmax() {
        return this.ymax;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setGrid(int x, int y) throws Exception {
        this.gridx = x;
        this.gridy = y;
    }

    @Override
    public void setColor(Color color) {
        this.color = color;
        int i = 0;
        while (i < this.arrows.size()) {
            ((MathArrow2D)this.arrows.elementAt(i)).setColor(color);
            ++i;
        }
    }

    public void setLimits(String strXmin, String strXmax, String strYmin, String strYmax) throws Exception {
        try {
            this.vectorfield_xmin = Double.valueOf(strXmin);
        }
        catch (Exception ex) {
            throw new Exception("xmin ist keine reelle Zahl");
        }
        try {
            this.vectorfield_xmax = Double.valueOf(strXmax);
        }
        catch (Exception ex) {
            throw new Exception("xmax ist keine reelle Zahl");
        }
        try {
            this.vectorfield_ymin = Double.valueOf(strYmin);
        }
        catch (Exception ex) {
            throw new Exception("ymin ist keine reelle Zahl");
        }
        try {
            this.vectorfield_ymax = Double.valueOf(strYmax);
        }
        catch (Exception ex) {
            throw new Exception("ymax ist keine reelle Zahl");
        }
        this.xmin = this.vectorfield_xmin;
        this.xmax = this.vectorfield_xmax;
        this.ymin = this.vectorfield_xmin;
        this.ymax = this.vectorfield_xmax;
    }

    protected void addArrow(Punkt2D p, Punkt2D velocity, double max) {
        double newheadY;
        double newheadX;
        double newbaseY;
        double newbaseX;
        double lx = (this.vectorfield_xmax - this.vectorfield_xmin) / (double)(this.gridx + this.gridx / 10);
        double ly = (this.vectorfield_ymax - this.vectorfield_ymin) / (double)(this.gridy + this.gridy / 10);
        double length = Math.min(lx, ly);
        double norm = Math.sqrt(velocity.x * velocity.x + velocity.y * velocity.y);
        Punkt2D velocityE = new Punkt2D(velocity.x / norm, velocity.y / norm);
        if (this.mode == 0) {
            newbaseX = p.x - velocityE.x / 2.0 * length;
            newbaseY = p.y - velocityE.y / 2.0 * length;
            newheadX = p.x + velocityE.x / 2.0 * length;
            newheadY = p.y + velocityE.y / 2.0 * length;
        } else {
            newbaseX = p.x - velocityE.x / 2.0 * norm / max * length;
            newbaseY = p.y - velocityE.y / 2.0 * norm / max * length;
            newheadX = p.x + velocityE.x / 2.0 * norm / max * length;
            newheadY = p.y + velocityE.y / 2.0 * norm / max * length;
        }
        if (Double.isNaN(newbaseX) || Double.isInfinite(newbaseX) || Double.isNaN(newbaseY) || Double.isInfinite(newbaseY) || Double.isNaN(newheadX) || Double.isInfinite(newheadX) || Double.isNaN(newheadY) || Double.isInfinite(newheadY) || newbaseX == newheadX && newbaseY == newheadY) {
            return;
        }
        MathArrow2D arrow = new MathArrow2D(new Punkt2D(newbaseX, newbaseY), new Punkt2D(newheadX, newheadY));
        arrow.setColor(this.color);
        arrow.setMathPanel2d(this.panel);
        if (arrow.getHead().x < this.xmin) {
            this.xmin = arrow.getHead().x;
        }
        if (arrow.getHead().x > this.xmax) {
            this.xmax = arrow.getHead().x;
        }
        if (arrow.getHead().y < this.ymin) {
            this.ymin = arrow.getHead().y;
        }
        if (arrow.getHead().y > this.ymax) {
            this.ymax = arrow.getHead().y;
        }
        if (arrow.getBase().x < this.xmin) {
            this.xmin = arrow.getBase().x;
        }
        if (arrow.getBase().x > this.xmax) {
            this.xmax = arrow.getBase().x;
        }
        if (arrow.getBase().y < this.ymin) {
            this.ymin = arrow.getBase().y;
        }
        if (arrow.getBase().y > this.ymax) {
            this.ymax = arrow.getBase().y;
        }
        this.arrows.add(arrow);
    }

    @Override
    public void prepaintcompute() throws Exception {
        int i = 0;
        while (i < this.arrows.size()) {
            try {
                ((MathArrow2D)this.arrows.elementAt(i)).prepaintcompute();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public void compute() throws Exception {
        Punkt2D p;
        int j;
        this.xmin = this.vectorfield_xmin;
        this.xmax = this.vectorfield_xmax;
        this.ymin = this.vectorfield_ymin;
        this.ymax = this.vectorfield_ymax;
        if (this.xmin >= this.xmax) {
            throw new Exception("Fehler beim Bereich: xmin muss echt kleiner wie xmax sein");
        }
        if (this.ymin >= this.ymax) {
            throw new Exception("Fehler beim Bereich: ymin muss echt kleiner wie ymax sein");
        }
        this.arrows.clear();
        Punkt2D[][] gridpoints = Grid2D.createGrid2D((double)this.vectorfield_xmin, (double)this.vectorfield_xmax, (double)this.vectorfield_ymin, (double)this.vectorfield_ymax, (int)this.gridx, (int)this.gridy);
        if (gridpoints == null) {
            throw new Exception("Gitter konnte nicht erzeugt werden");
        }
        double max = 0.0;
        int i = 0;
        while (i < gridpoints.length) {
            j = 0;
            while (j < gridpoints[0].length) {
                p = gridpoints[i][j];
                Punkt2D velocity = this.vectorfield2d.velocityVectorAt(p);
                double normquad = velocity.quadnorm();
                if (normquad > max) {
                    max = normquad;
                }
                ++j;
            }
            ++i;
        }
        max = Math.sqrt(max);
        i = 0;
        while (i < gridpoints.length) {
            j = 0;
            while (j < gridpoints.length) {
                p = gridpoints[i][j];
                this.addArrow(p, this.vectorfield2d.velocityVectorAt(p), max);
                ++j;
            }
            ++i;
        }
        this.scene2d.setLimits(this.xmin, this.xmax, this.ymin, this.ymax);
    }

    @Override
    public void draw(BufferedImage framebuffer, Graphics2D g2) {
        int i = 0;
        while (i < this.arrows.size()) {
            MathArrow2D arrow = (MathArrow2D)this.arrows.elementAt(i);
            arrow.draw(framebuffer, g2);
            ++i;
        }
    }
}

