/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.base;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.Iterator;
import java.util.Vector;
import uibk.draw2d.base.Drawable2D;
import uibk.draw2d.base.Scene2D;
import uibk.lang.Dragable;
import uibk.lang.Highlightable;
import uibk.lang.Options;
import uibk.lang.PrepaintComputable;
import uibk.lang.ToolTipable;
import uibk.swing.Label;
import uibk.swing.Panel;

public class MathPanel2D
extends Panel
implements ComponentListener {
    public BufferedImage framebuffer;
    protected Vector drawItems = new Vector();
    Dragable dragged = null;
    protected Highlightable highlighted = null;
    boolean listenForDrags = false;
    boolean highlight = false;
    private Scene2D scene2d;
    private Label jLabelReports = null;
    private MyMouseListening mouseListener = new MyMouseListening();
    private HighlightListening highlightListener = new HighlightListening();
    private MyMouseMotionListening mouseMotionListener = new MyMouseMotionListening();

    public void requestRecompute() {
        this.scene2d.changed = true;
    }

    @Override
    public void repaint() {
        if (this.scene2d != null) {
            this.scene2d.changed = true;
        }
        super.repaint();
    }

    public void delete(Drawable2D drawable) {
        Iterator it = this.drawItems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj != drawable) continue;
            it.remove();
        }
    }

    public void deleteexcept(Drawable2D drawable) {
        Iterator it = this.drawItems.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (obj == drawable) continue;
            it.remove();
        }
    }

    public Highlightable getHighLighted() {
        return this.highlighted;
    }

    public void highLight(Highlightable high) {
        this.highlighted = high;
    }

    public MathPanel2D() {
        this.setBackground(Color.white);
        this.scene2d = new Scene2D(-1.0, 1.0, -1.0, 1.0);
        this.scene2d.setPanel(this);
        this.addComponentListener(this);
    }

    public Scene2D getScene2d() {
        return this.scene2d;
    }

    public boolean isPointInCoordsArea(Point point) {
        Insets insets = this.scene2d.getInsets();
        int edge = this.scene2d.getEdge();
        return point.x > insets.left + edge && point.x < this.getWidth() - insets.right - edge && point.y < this.getHeight() - insets.bottom - edge && point.y > insets.top + edge;
    }

    public void setListenForDrags(boolean listenForDrags) {
        if (listenForDrags == this.listenForDrags) {
            return;
        }
        this.listenForDrags = listenForDrags;
        if (listenForDrags) {
            this.addMouseListener(this.mouseListener);
            this.addMouseMotionListener(this.mouseMotionListener);
        } else {
            this.removeMouseListener(this.mouseListener);
            this.removeMouseMotionListener(this.mouseMotionListener);
        }
    }

    public void setHighlightable(Highlightable high) {
        this.highlighted = high;
    }

    public void enableHighLighting(boolean enable) {
        if (this.highlight == enable) {
            return;
        }
        this.highlight = enable;
        if (this.highlight) {
            this.addMouseMotionListener(this.highlightListener);
        } else {
            this.removeMouseMotionListener(this.highlightListener);
        }
    }

    public void add(Object obj) {
        if (obj != null && obj instanceof Drawable2D && !this.drawItems.contains(obj)) {
            Drawable2D draw = (Drawable2D)obj;
            draw.setMathPanel2d(this);
            this.drawItems.addElement(draw);
        }
    }

    void preparebuffer() {
        int w = this.getWidth();
        int h = this.getHeight();
        if (this.framebuffer != null && (this.framebuffer.getWidth() != w || this.framebuffer.getHeight() != h)) {
            this.scene2d.coordsChanged();
        }
        if (this.framebuffer == null || w > this.framebuffer.getWidth() || h > this.framebuffer.getHeight()) {
            this.framebuffer = (BufferedImage)this.createImage(w, h);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.isVisible()) {
            return;
        }
        this.preparebuffer();
        this.scene2d.setPanel(this);
        Graphics2D g2 = this.framebuffer.createGraphics();
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.framebuffer.getWidth(), this.framebuffer.getHeight());
        this.drawDrawables(this.framebuffer, g2);
        g.drawImage(this.framebuffer, 0, 0, null);
    }

    @Override
    public void componentShown(ComponentEvent ev) {
    }

    @Override
    public void componentHidden(ComponentEvent ev) {
    }

    @Override
    public void componentResized(ComponentEvent ev) {
        this.scene2d.changed = true;
        this.repaint();
    }

    @Override
    public void componentMoved(ComponentEvent ev) {
    }

    protected void drawDrawables(BufferedImage framebuffer, Graphics2D g2) {
        int i;
        Options.setRenderingHints(g2);
        int ct = this.drawItems.size();
        this.scene2d.processRequests();
        if (this.scene2d.changed) {
            this.scene2d.resetInsets();
            i = 0;
            while (i < ct) {
                if (this.drawItems.elementAt(i) instanceof PrepaintComputable && ((Drawable2D)this.drawItems.elementAt(i)).getVisible()) {
                    try {
                        ((PrepaintComputable)this.drawItems.elementAt(i)).prepaintcompute();
                    }
                    catch (Exception ex) {
                        this.reportError(ex.getMessage());
                    }
                }
                ++i;
            }
            this.scene2d.processRequests();
            if (this.scene2d.changed) {
                i = 0;
                while (i < ct) {
                    if (this.drawItems.elementAt(i) instanceof PrepaintComputable && ((Drawable2D)this.drawItems.elementAt(i)).getVisible()) {
                        try {
                            ((PrepaintComputable)this.drawItems.elementAt(i)).prepaintcompute();
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            System.err.print("Fehler beim Berechnen");
                        }
                    }
                    ++i;
                }
            }
        }
        i = 0;
        while (i < ct) {
            Drawable2D d = (Drawable2D)this.drawItems.elementAt(i);
            if (d.getVisible()) {
                if (d == this.highlighted) {
                    ((Highlightable)d).highlight(framebuffer, g2);
                } else {
                    d.draw(framebuffer, g2);
                }
            }
            ++i;
        }
        this.scene2d.changed = false;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int ct = this.drawItems.size();
        int i = 0;
        while (i < ct) {
            if (this.drawItems.elementAt(i) instanceof ToolTipable && ((ToolTipable)this.drawItems.elementAt(i)).isToolTipEnabled() && ((ToolTipable)this.drawItems.elementAt(i)).tooltipcontains(event.getX(), event.getY())) {
                return ((ToolTipable)this.drawItems.elementAt(i)).getToolTipText(event);
            }
            ++i;
        }
        return null;
    }

    public void report(String message) {
        this.jLabelReports.setForeground(Color.black);
        this.jLabelReports.setText(message);
    }

    public void reportError(String message) {
        this.jLabelReports.setForeground(new Color(255, 51, 0));
        this.jLabelReports.setText(message);
    }

    public void reportSuccess(String message) {
        this.jLabelReports.setForeground(new Color(0, 200, 0));
        this.jLabelReports.setText(message);
    }

    public void setReportingLabel(Label label) {
        this.jLabelReports = label;
    }

    protected class HighlightListening
    extends MouseMotionAdapter {
        protected HighlightListening() {
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
            Iterator it = MathPanel2D.this.drawItems.iterator();
            Highlightable old = MathPanel2D.this.highlighted;
            MathPanel2D.this.highlighted = null;
            while (it.hasNext()) {
                Object d = it.next();
                if (!(d instanceof Highlightable) || !((Highlightable)d).highlightcontains(ev.getX(), ev.getY())) continue;
                MathPanel2D.this.highlighted = (Highlightable)d;
            }
            if (old != MathPanel2D.this.highlighted) {
                MathPanel2D.this.repaint();
            }
        }
    }

    protected class MyMouseListening
    extends MouseAdapter {
        protected MyMouseListening() {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            int i = MathPanel2D.this.drawItems.size() - 1;
            while (i >= 0) {
                if (MathPanel2D.this.drawItems.elementAt(i) instanceof Dragable && ((Dragable)MathPanel2D.this.drawItems.elementAt(i)).dragcontains(ev.getX(), ev.getY())) {
                    MathPanel2D.this.dragged = (Dragable)MathPanel2D.this.drawItems.elementAt(i);
                    MathPanel2D.this.drawItems.remove(i);
                    MathPanel2D.this.drawItems.add((Drawable2D)MathPanel2D.this.dragged);
                }
                --i;
            }
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            MathPanel2D.this.dragged = null;
        }
    }

    protected class MyMouseMotionListening
    extends MouseMotionAdapter {
        protected MyMouseMotionListening() {
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            if (MathPanel2D.this.dragged == null) {
                return;
            }
            MathPanel2D.this.dragged.drag(ev);
            MathPanel2D.this.repaint();
        }
    }
}

