/*
 * Decompiled with CFR 0.152.
 */
package uibk.draw2d.axes2d;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import uibk.draw2d.axes2d.Axes2D;
import uibk.draw2d.base.Scene2D;

public class Tick {
    public static final int TL_LEFT = 0;
    public static final int TL_RIGHT = 1;
    public static final int TL_TOP = 2;
    public static final int TL_BOTTOM = 3;
    public static final int LABEL_CENTER = 0;
    public static final int LABEL_MOVEUP = 1;
    public static final int LABEL_MOVEDOWN = 2;
    public static final int LABEL_MOVERIGHT = 3;
    public static final int LABEL_MOVELEFT = 4;
    boolean bigTick;
    double tickPosX;
    double tickPosY;
    int labelXPos;
    int labelYPos;
    int labelPos;
    String label;
    int lengthBigTick = 6;
    int lengthSmallTick = 3;
    Axes2D axes;
    int pos;
    int space = 10;

    Tick(int pos, double tickPosX, double tickPosY, boolean bigTick, String label, int labelPos, Axes2D axes) {
        this.pos = pos;
        this.tickPosX = tickPosX;
        this.tickPosY = tickPosY;
        this.bigTick = bigTick;
        this.labelPos = labelPos;
        this.label = label;
        this.axes = axes;
    }

    public void compute(Graphics2D g2, Scene2D coords2d) {
        if (!this.bigTick) {
            return;
        }
        int x = coords2d.xToPixel(this.tickPosX);
        int y = coords2d.yToPixel(this.tickPosY);
        Font oldFont = g2.getFont();
        g2.setFont(this.axes.font);
        FontMetrics metrics = g2.getFontMetrics();
        int length = metrics.stringWidth(this.label);
        int height = metrics.getHeight();
        g2.setFont(oldFont);
        switch (this.pos) {
            case 0: {
                switch (this.labelPos) {
                    case 1: {
                        this.labelYPos = y - this.lengthSmallTick;
                        break;
                    }
                    case 2: {
                        this.labelYPos = y + height / 2 + this.lengthSmallTick;
                        break;
                    }
                    default: {
                        this.labelYPos = y + height / 4;
                    }
                }
                this.labelXPos = x - length - this.space;
                coords2d.requestSpaceLeft(this.labelXPos);
                break;
            }
            case 1: {
                this.labelXPos = x + this.space;
                this.labelYPos = y + height / 4;
                coords2d.requestSpaceRight(this.labelXPos + length);
                break;
            }
            case 2: {
                this.labelXPos = x - length / 2;
                this.labelYPos = y - this.space;
                coords2d.requestSpaceRight(this.labelXPos + length);
                coords2d.requestSpaceLeft(this.labelXPos);
                coords2d.requestSpaceTop(this.labelYPos);
                break;
            }
            case 3: {
                switch (this.labelPos) {
                    case 3: {
                        this.labelXPos = x + this.lengthSmallTick;
                        break;
                    }
                    case 4: {
                        this.labelXPos = x - length - this.lengthSmallTick;
                        break;
                    }
                    default: {
                        this.labelXPos = x - length / 2;
                    }
                }
                this.labelYPos = y + this.space + height / 2;
                coords2d.requestSpaceRight(this.labelXPos + length);
                coords2d.requestSpaceLeft(this.labelXPos);
                coords2d.requestSpaceBottom(this.labelYPos);
            }
        }
    }

    public void drawTick(Graphics2D g2, Scene2D coords2d) {
        Stroke oldStroke = g2.getStroke();
        g2.setStroke(new BasicStroke(0.5f));
        int length = this.bigTick ? this.lengthBigTick : this.lengthSmallTick;
        int x = coords2d.xToPixel(this.tickPosX);
        int y = coords2d.yToPixel(this.tickPosY);
        switch (this.pos) {
            case 0: {
                g2.drawLine(x - length, y, x, y);
                break;
            }
            case 1: {
                g2.drawLine(x + length, y, x, y);
                break;
            }
            case 2: {
                g2.drawLine(x, y - length, x, y);
                break;
            }
            case 3: {
                g2.drawLine(x, y + length, x, y);
                break;
            }
        }
        g2.setStroke(oldStroke);
    }

    public void drawLabel(Graphics2D g2) {
        if (!this.bigTick) {
            return;
        }
        Font oldFont = g2.getFont();
        g2.setFont(this.axes.font);
        if (this.label != null) {
            g2.drawString(this.label, this.labelXPos, this.labelYPos);
        }
        g2.setFont(oldFont);
    }

    public void draw(Graphics2D g2, Scene2D coords2d, boolean drawLabels) {
        this.drawLabel(g2);
        if (drawLabels) {
            this.drawTick(g2, coords2d);
        }
    }
}

