/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import Jama.Matrix;

public class Vektor
extends Matrix {
    public Vektor(int m) {
        super(m, 1);
    }

    public Vektor(double[] c) {
        super(c.length, 1);
        int i = 0;
        while (i < c.length) {
            this.A[i][0] = c[i];
            ++i;
        }
    }

    public Vektor(Vektor v) {
        super(v);
    }

    public Vektor(Matrix X) {
        super(X.m, 1);
        int i = 0;
        while (i < X.m) {
            this.A[i][0] = X.A[i][0];
            ++i;
        }
    }

    public void set(int i, double s) {
        super.set(i, 0, s);
    }

    public void setVektor(int i, int j, Vektor x) {
        int k = i;
        while (k <= j) {
            super.set(k, 0, x.get(k - i));
            ++k;
        }
    }

    public void setVektor(Vektor x) {
        int k = 0;
        while (k < x.getRowDimension()) {
            super.set(k, 0, x.get(k));
            ++k;
        }
    }

    public int getLength() {
        return this.m;
    }

    public String toString() {
        String str = new String("(");
        int i = 0;
        while (i < this.m) {
            str = String.valueOf(str) + this.get(i);
            if (i < this.m - 1) {
                str = String.valueOf(str) + ",";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Vektor) {
            Vektor v = (Vektor)obj;
            if (v.m != this.m) {
                return false;
            }
            int i = 0;
            while (i < this.m) {
                if (v.get(i) != this.get(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public double get(int i) {
        return super.get(i, 0);
    }

    public Vektor getVektor(int i, int j) {
        if (j < i) {
            throw new IllegalArgumentException("index out of bounds");
        }
        Vektor v = new Vektor(j - i + 1);
        int k = i;
        while (k <= j) {
            v.set(k - i, this.get(k));
            ++k;
        }
        return v;
    }

    public static Vektor concat(Vektor v, Vektor w) {
        Vektor z = new Vektor(v.m + v.n);
        int i = 0;
        while (i < v.m) {
            z.set(i, v.get(i));
            ++i;
        }
        i = v.m;
        while (i < z.m) {
            z.set(i, w.get(i));
            ++i;
        }
        return z;
    }

    public double dotprod(Vektor v) {
        if (v.m != this.m) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        double sum = 0.0;
        int i = 0;
        while (i < this.m) {
            sum += v.get(i) * this.get(i);
            ++i;
        }
        return sum;
    }

    public void setMatrixCol(Matrix M, int col) {
        if (M.m != this.m) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        int i = 0;
        while (i < this.m) {
            this.set(i, M.get(i, col));
            ++i;
        }
    }

    public void swap(int i, int j) {
        if (i >= this.m || j >= this.m) {
            throw new IllegalArgumentException("index exceeds dimension");
        }
        double temp = this.get(i);
        this.set(i, this.get(j));
        this.set(j, temp);
    }
}

