/*
 * Decompiled with CFR 0.152.
 */
package jaba.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import jaba.math.Complex;
import jaba.math.Settings;
import jaba.math.Vektor;

public abstract class Function {
    protected int n;
    protected int p;
    protected int m;

    public Function() {
    }

    public Function(int n, int p, int m) {
        this.m = m;
        this.p = p;
        this.n = n;
    }

    public int getParamDim() {
        return this.p;
    }

    public int getNumberVars() {
        return this.n + this.p;
    }

    public int getNumberFunctions() {
        return this.m;
    }

    public boolean getValue(Vektor y, Vektor ret) {
        double[] val = this.getValue(y.getRowPackedCopy());
        if (val == null) {
            return false;
        }
        ret.setVektor(new Vektor(val));
        return true;
    }

    public abstract double[] getValue(double[] var1);

    public Vektor getValue(Vektor y) {
        Vektor ret = new Vektor(this.m);
        if (this.getValue(y, ret)) {
            return ret;
        }
        return null;
    }

    public boolean getJacobian(Vektor x, Matrix J) {
        if (x.getLength() != this.n + this.p) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        if (J.m != this.m || J.n != this.n + this.p) {
            throw new IllegalArgumentException("Matrix has wrong dim.");
        }
        Vektor temp = new Vektor(x);
        double h = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        int j = 0;
        while (j < this.n + this.p) {
            double t = temp.get(j);
            temp.set(j, t + h);
            Vektor forward = this.getValue(temp);
            temp.set(j, t - h);
            Vektor backward = this.getValue(temp);
            temp.set(j, t);
            Matrix centerDiff = forward.minus(backward);
            centerDiff.timesEquals(1.0 / (2.0 * h));
            J.setMatrix(0, this.m - 1, j, j, centerDiff);
            ++j;
        }
        return true;
    }

    public Matrix getJacobianState(Vektor x) {
        Matrix J = this.getJacobian(x);
        return J.getMatrix(0, this.m - 1, 0, this.n - 1);
    }

    public Matrix getJacobianParam(Vektor x) {
        Matrix J = this.getJacobian(x);
        return J.getMatrix(0, this.m - 1, this.n, this.n + this.p - 1);
    }

    public Matrix getJacobian(Vektor x) {
        if (x.getLength() != this.n + this.p) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        Matrix J = new Matrix(this.m, this.n + this.p);
        this.getJacobian(x, J);
        return J;
    }

    public double[][][] getDerivation2(Vektor x) {
        if (x.getLength() != this.n + this.p) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        double h = Math.sqrt(Math.sqrt(Settings.getMachinePrecision()));
        double[][][] ret = new double[this.m][this.n + this.p][this.n + this.p];
        Vektor temp = new Vektor(x);
        int k = 0;
        while (k < this.m) {
            int i = 0;
            while (i < this.n + this.p) {
                int j = 0;
                while (j < this.n + this.p) {
                    if (i == j) {
                        double t = x.get(i);
                        Vektor center = this.getValue(temp);
                        temp.set(i, t + h);
                        Vektor forward = this.getValue(temp);
                        temp.set(i, t - h);
                        Vektor backward = this.getValue(temp);
                        temp.set(i, t);
                        ret[k][i][j] = (forward.get(k) - 2.0 * center.get(k) + backward.get(k)) / (h * h);
                    } else {
                        double t1 = x.get(i);
                        double t2 = x.get(j);
                        temp.set(i, t1 + h);
                        temp.set(j, t2 + h);
                        Vektor ff = this.getValue(temp);
                        temp.set(i, t1 + h);
                        temp.set(j, t2 - h);
                        Vektor fb = this.getValue(temp);
                        temp.set(i, t1 - h);
                        temp.set(j, t2 + h);
                        Vektor bf = this.getValue(temp);
                        temp.set(i, t1 - h);
                        temp.set(j, t2 - h);
                        Vektor bb = this.getValue(temp);
                        temp.set(i, t1);
                        temp.set(j, t2);
                        ret[k][i][j] = (ff.get(k) - fb.get(k) - bf.get(k) + bb.get(k)) / (4.0 * h * h);
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return ret;
    }

    public Vektor getDerivation2(Vektor x, Vektor v, Vektor w) {
        if (this.n + this.p != x.getLength() || this.n + this.p != v.getLength() || this.n + this.p != w.getLength()) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        double[][][] derivs2 = this.getDerivation2(x);
        Vektor ret = new Vektor(this.m);
        double sum = 0.0;
        int i = 0;
        while (i < this.m) {
            sum = 0.0;
            int k = 0;
            while (k < this.n + this.p) {
                int l = 0;
                while (l < this.n + this.p) {
                    sum += derivs2[i][k][l] * v.get(k) * w.get(l);
                    ++l;
                }
                ++k;
            }
            ret.set(i, sum);
            ++i;
        }
        return ret;
    }

    public Complex[] getEigenvalues(Vektor y) {
        EigenvalueDecomposition ed = new EigenvalueDecomposition(this.getJacobianState(y));
        return ed.getEigenvals();
    }
}

