/*
 * Decompiled with CFR 0.152.
 */
package ds.text;

import jaba.math.ODESolver;

public class ODEOutputReport {
    static String print(double[] v) {
        if (v.length == 0) {
            return "";
        }
        String str = "(";
        int i = 0;
        while (i < v.length) {
            str = String.valueOf(str) + String.valueOf(v[i]);
            if (i != v.length - 1) {
                str = String.valueOf(str) + ",";
            }
            ++i;
        }
        str = String.valueOf(str) + ")";
        return str;
    }

    public static String getHTMLReport(ODESolver.ODEReport report) {
        String str = "";
        if (report.integratedforward) {
            str = "<b>forward integration:</b>";
            if (report.successforward) {
                str = String.valueOf(str) + " <font color=green>successful</font>";
                str = String.valueOf(str) + "<br>value at " + report.timeforward + "=" + ODEOutputReport.print(report.valueforward);
            }
            str = String.valueOf(str) + "<br>number of  steps: " + report.stepsforward;
            str = String.valueOf(str) + "<br>number of accepted steps: " + (report.stepsforward - report.stepsrepeatedforward);
            str = String.valueOf(str) + "<br>number of repeated steps: " + report.stepsrepeatedforward;
            if (report.stepsforward != report.stepsrepeatedforward) {
                str = String.valueOf(str) + "<br>min. stepsize: " + report.minstepsizeforward;
                str = String.valueOf(str) + "<br>max. stepsize: " + report.maxstepsizeforward;
            }
            if (report.toomanystepsforward) {
                str = String.valueOf(str) + "<br>at t=" + report.timeforward + "<font color=red> max. number of steps reached</font>";
            }
            if (report.toosmallstepforward) {
                str = String.valueOf(str) + "<br>at t=" + report.timeforward + "<font color=red> stepsize to small</font>";
            }
            if (report.singularityforward) {
                str = String.valueOf(str) + "<br>at t=" + report.timeforward + "<font color=red> singularity or overflow</font>";
            }
        }
        if (report.integratedbackward) {
            str = String.valueOf(str) + "<br><b>backward integration:</b>";
            if (report.successbackward) {
                str = String.valueOf(str) + " <font color=green>successful</font>";
                str = String.valueOf(str) + "<br>value at " + report.timebackward + "=" + ODEOutputReport.print(report.valuebackward);
            }
            str = String.valueOf(str) + "<br>number of  steps:" + report.stepsbackward;
            str = String.valueOf(str) + "<br>number of accepted steps: " + (report.stepsbackward - report.stepsrepeatedbackward);
            str = String.valueOf(str) + "<br>number of repeated steps:" + report.stepsrepeatedbackward;
            if (report.stepsbackward != report.stepsrepeatedbackward) {
                str = String.valueOf(str) + "<br>min. stepsize: " + report.minstepsizebackward;
                str = String.valueOf(str) + "<br>max. stepsize: " + report.maxstepsizebackward;
            }
            if (report.toomanystepsbackward) {
                str = String.valueOf(str) + "<br>at t=" + report.timebackward + "<font color=red> max. number of steps reached</font>";
            }
            if (report.toosmallstepbackward) {
                str = String.valueOf(str) + "<br>at t=" + report.timebackward + "<font color=red> stepsize to small</font>";
            }
            if (report.singularitybackward) {
                str = String.valueOf(str) + "<br>at t=" + report.timebackward + "<font color=red>singularity or overflow</font>";
            }
        }
        return String.valueOf(str) + "<br>";
    }
}

