/*
 * Decompiled with CFR 0.152.
 */
package ds.parsing;

import bacon.parser.Expr;
import bacon.parser.Parser;
import bacon.parser.Variable;
import ds.math.ParsedFunction;
import ds.math.VectorField2D;
import jaba.math.Function;
import jaba.math.Interval;
import jaba.math.Vektor;
import java.util.StringTokenizer;
import uibk.geom.CoordinateRect2D;

public class UtilParser {
    static Parser parser = new Parser();

    public static void parseVectorfield(VectorField2D vectorfield, String varx, String vary, String compX, String compY) throws Exception {
        parser.clearVariables();
        Variable[] var = new Variable[]{new Variable(varx), new Variable(vary)};
        parser.addVariable(var[0]);
        parser.addVariable(var[1]);
        Expr[] expr = new Expr[2];
        if (compX == null || compX.equals("")) {
            throw new Exception("1. component of the vectorfield is not defined");
        }
        if (compY == null || compY.equals("")) {
            throw new Exception("2. component of the vectorfield is not defined");
        }
        try {
            expr[0] = parser.parseString(compX);
        }
        catch (Exception ex) {
            throw new Exception("Error in 1. component " + compX + ": " + ex.getMessage());
        }
        try {
            expr[1] = parser.parseString(compY);
        }
        catch (Exception ex) {
            throw new Exception("Error in 2. component " + compY + ": " + ex.getMessage());
        }
        ParsedFunction function = new ParsedFunction(var, expr);
        vectorfield.setFunction((Function)function);
    }

    public static void parseFunction(ParsedFunction f, String strVars, String strParams, String strSystem) throws Exception {
        String[] vars = UtilParser.split(strVars, ",");
        String[] params = UtilParser.split(strParams, ",");
        String[] funcs = UtilParser.split(strSystem, "\n");
        UtilParser.parseFunction(f, vars, params, funcs);
    }

    public static void parseFunction(ParsedFunction f, String[] strVars, String[] strParams, String[] strFunctions) throws Exception {
        parser.clearVariables();
        int n = strVars.length;
        int p = strParams.length;
        Variable[] statevariables = new Variable[n];
        int i = 0;
        while (i < n) {
            Variable v;
            statevariables[i] = v = new Variable(strVars[i]);
            parser.addVariable(v);
            ++i;
        }
        Variable[] parameters = new Variable[p];
        int i2 = 0;
        while (i2 < p) {
            Variable v;
            parameters[i2] = v = new Variable(strParams[i2]);
            parser.addVariable(v);
            ++i2;
        }
        int m = strFunctions.length;
        Expr[] functions = new Expr[m];
        int i3 = 0;
        while (i3 < m) {
            if (strFunctions[i3] == null || strFunctions[i3].equals("")) {
                throw new Exception(String.valueOf(i3 + 1) + ". component of function not definied");
            }
            functions[i3] = parser.parseString(strFunctions[i3]);
            ++i3;
        }
        f.setFunction(functions);
        f.setStateVariables(statevariables);
        f.setVariables(parameters);
    }

    public static Vektor parseVektor(String strVektor) throws Exception {
        double[] coeff = UtilParser.parseBracketInitalValues(strVektor);
        return new Vektor(coeff);
    }

    public static double parseConstantExpr(String expr) throws Exception {
        Expr e = parser.parseString(expr);
        return e.value();
    }

    public static Interval parseIntervall(String strInterval, String name, boolean trueinterval) throws Exception {
        double end;
        double start;
        if (name == null) {
            name = "";
        }
        if (strInterval == null || strInterval.equals("")) {
            throw new Exception(String.valueOf(name) + ": no interval defined");
        }
        if (!(strInterval = strInterval.trim()).startsWith("[")) {
            throw new Exception(String.valueOf(name) + ": interval has to begin with \"[\" ");
        }
        if (!strInterval.endsWith("]")) {
            throw new Exception(String.valueOf(name) + ": interval has to end with \"[\" ");
        }
        int pos = strInterval.indexOf(",");
        if (pos < 0) {
            throw new Exception(String.valueOf(name) + ": interval must be of the form  [start,end]");
        }
        try {
            start = UtilParser.parseConstantExpr(strInterval.substring(1, pos));
        }
        catch (Exception ex) {
            throw new Exception(String.valueOf(name) + ": interval lower bound is no real number");
        }
        try {
            end = UtilParser.parseConstantExpr(strInterval.substring(pos + 1, strInterval.length() - 1));
        }
        catch (Exception ex) {
            throw new Exception(String.valueOf(name) + ": interval upper bound is no real number");
        }
        if (trueinterval) {
            if (end <= start) {
                throw new Exception(String.valueOf(name) + ": interval upper bound must be greater than interval lower bound");
            }
        } else if (end < start) {
            throw new Exception(String.valueOf(name) + ": interval upper bound must be greater-equal than interval lower bound");
        }
        Interval interval = new Interval(start, end);
        return interval;
    }

    public static double[] parseInitalValues(String strInitials) throws Exception {
        if ((strInitials = strInitials.trim()).charAt(0) == ',' || strInitials.charAt(strInitials.length() - 1) == ',' || strInitials.indexOf(",,") >= 0) {
            throw new Exception("Error in initial values. The initial values must be entered like 3,2,1,.. ");
        }
        String[] strValues = UtilParser.split(strInitials, ",");
        if (strInitials == null || strValues.length == 0) {
            return null;
        }
        double[] values = new double[strValues.length];
        int i = 0;
        while (i < values.length) {
            try {
                values[i] = UtilParser.parseConstantExpr(strValues[i]);
            }
            catch (Exception ex) {
                throw new Exception("Error in initial values. The initial values must be entered like 3,2,1,.. ");
            }
            ++i;
        }
        return values;
    }

    public static double[] parseBracketInitalValues(String strInitials) throws Exception {
        if (strInitials == null || strInitials.equals("")) {
            throw new Exception("No initial value specified");
        }
        if (strInitials.charAt(0) != '(' || strInitials.charAt(strInitials.length() - 1) != ')') {
            try {
                double[] ret = new double[]{UtilParser.parseConstantExpr(strInitials)};
                return ret;
            }
            catch (Exception ex) {
                throw new Exception("Initial values error");
            }
        }
        strInitials = strInitials.substring(1, strInitials.length() - 1);
        return UtilParser.parseInitalValues(strInitials);
    }

    public static String[] split(String aString, String delimiter) {
        StringTokenizer st = new StringTokenizer(aString, delimiter);
        String[] result = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            result[i++] = st.nextToken();
        }
        return result;
    }

    public static double parseValue(String strEps, String name, Double min, Double max, Boolean positive) throws Exception {
        double eps = 0.0;
        if (strEps == null || strEps.equals("")) {
            throw new Exception("You have not entered a " + name);
        }
        try {
            eps = UtilParser.parseConstantExpr(strEps);
        }
        catch (Exception ex) {
            throw new Exception("Entered " + name + " is not a real number");
        }
        if (positive != null && positive.booleanValue() && eps <= 0.0) {
            throw new Exception("Entered " + name + " must be positive");
        }
        if (positive != null && !positive.booleanValue() && eps >= 0.0) {
            throw new Exception("Entered " + name + " must be negative");
        }
        if (max != null && eps > max) {
            throw new Exception("Entered " + name + " must be less or equal than " + max);
        }
        if (min != null && eps < min) {
            throw new Exception("Entered " + name + " must be greater or equal than " + min);
        }
        return eps;
    }

    public static CoordinateRect2D parseRectArea(String strxmin, String strxmax, String strymin, String strymax) throws Exception {
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        if (strxmin == null || strxmin.equals("")) {
            throw new Exception("xmin is not defined");
        }
        if (strxmax == null || strxmax.equals("")) {
            throw new Exception("xmax is not defined");
        }
        if (strymin == null || strymin.equals("")) {
            throw new Exception("ymin is not defined");
        }
        if (strymax == null || strymax.equals("")) {
            throw new Exception("ymax is not defined");
        }
        try {
            xmin = UtilParser.parseConstantExpr(strxmin);
        }
        catch (Exception e) {
            throw new Exception("Error in xmin:" + e.getMessage());
        }
        try {
            xmax = UtilParser.parseConstantExpr(strxmax);
        }
        catch (Exception e) {
            throw new Exception("Error in xmax:" + e.getMessage());
        }
        try {
            ymin = UtilParser.parseConstantExpr(strymin);
        }
        catch (Exception e) {
            throw new Exception("Error in ymin:" + e.getMessage());
        }
        try {
            ymax = UtilParser.parseConstantExpr(strymax);
        }
        catch (Exception e) {
            throw new Exception("Error in ymax:" + e.getMessage());
        }
        if (xmax <= xmin) {
            throw new Exception("xmax must be greater than xmin");
        }
        if (ymax <= ymin) {
            throw new Exception("ymax must be greater than ymin");
        }
        return new CoordinateRect2D(xmin, xmax, ymin, ymax);
    }
}

