/*
 * Decompiled with CFR 0.152.
 */
package ds.math;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;
import bacon.parser.Expr;
import bacon.parser.Variable;
import jaba.math.Complex;
import jaba.math.Function;
import jaba.math.Settings;
import jaba.math.Vektor;
import java.util.Hashtable;

public class ParsedFunction
extends Function {
    Hashtable parameters = new Hashtable();
    Variable[] statevariables;
    Expr[] functions;
    String[] paramnames;
    protected int n;
    protected int activeparams;
    protected int p;
    protected int m;

    public ParsedFunction() {
    }

    @Override
    public int getParamDim() {
        return this.activeparams;
    }

    public void setParameterValue(String name, double s) {
        Parameter param = (Parameter)this.parameters.get(name);
        if (param == null) {
            throw new IllegalArgumentException("No such Parameter");
        }
        param.parameter.setValue(s);
    }

    public double getParameterValue(String name) {
        Parameter param = (Parameter)this.parameters.get(name);
        if (param == null) {
            throw new IllegalArgumentException("No such Parameter");
        }
        return param.parameter.value();
    }

    public void setEnabledParameter(String name, boolean enable) {
        Parameter param = (Parameter)this.parameters.get(name);
        if (param == null) {
            throw new IllegalArgumentException("No such Parameter");
        }
        if (param.active != enable) {
            param.active = enable;
            this.activeparams = !enable ? --this.activeparams : ++this.activeparams;
        }
    }

    public ParsedFunction(Variable[] variables, Expr[] functions) {
        this.setFunction(functions);
        this.setVariables(variables);
    }

    public void setFunction(Expr[] functions) {
        this.functions = functions;
        this.m = functions.length;
    }

    public void setVariables(Variable[] param) {
        this.p = param.length;
        this.paramnames = new String[this.p];
        int i = 0;
        while (i < this.p) {
            this.paramnames[i] = param[i].toString();
            this.parameters.put(param[i].toString(), new Parameter(param[i], true));
            ++i;
        }
        this.activeparams = this.p;
    }

    public void setStateVariables(Variable[] variables) {
        this.statevariables = variables;
        this.n = variables.length;
    }

    @Override
    public int getNumberVars() {
        return this.n + this.activeparams;
    }

    @Override
    public int getNumberFunctions() {
        return this.m;
    }

    @Override
    public boolean getValue(Vektor x, Vektor y) {
        if (x.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Dim does not match");
        }
        if (y.getLength() != this.m) {
            throw new IllegalArgumentException("Dim does not match");
        }
        int i = 0;
        while (i < this.n) {
            this.statevariables[i].setValue(x.get(i));
            ++i;
        }
        if (this.activeparams > 0) {
            int c = this.n;
            int i2 = 0;
            while (i2 < this.p) {
                Parameter param = (Parameter)this.parameters.get(this.paramnames[i2]);
                if (param.active) {
                    param.parameter.setValue(x.get(c));
                    ++c;
                }
                ++i2;
            }
        }
        i = 0;
        while (i < this.m) {
            y.set(i, this.functions[i].value());
            ++i;
        }
        return true;
    }

    @Override
    public double[] getValue(double[] x) {
        if (x.length != this.n + this.activeparams) {
            throw new IllegalArgumentException("Dim does not match");
        }
        double[] y = new double[this.m];
        int i = 0;
        while (i < this.n) {
            this.statevariables[i].setValue(x[i]);
            ++i;
        }
        if (this.activeparams > 0) {
            int c = this.n;
            int i2 = 0;
            while (i2 < this.p) {
                Parameter param = (Parameter)this.parameters.get(this.paramnames[i2]);
                if (param.active) {
                    param.parameter.setValue(x[c]);
                    ++c;
                }
                ++i2;
            }
        }
        i = 0;
        while (i < this.m) {
            y[i] = this.functions[i].value();
            ++i;
        }
        return y;
    }

    @Override
    public Vektor getValue(Vektor y) {
        Vektor ret = new Vektor(this.m);
        if (this.getValue(y, ret)) {
            return ret;
        }
        return null;
    }

    @Override
    public boolean getJacobian(Vektor x, Matrix J) {
        if (x.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        if (J.m != this.m || J.n != this.n + this.activeparams) {
            throw new IllegalArgumentException("Matrix has wrong dim.");
        }
        Vektor temp = new Vektor(x);
        double h = Math.pow(Settings.getMachinePrecision(), 0.3333333333333333);
        int j = 0;
        while (j < this.n + this.activeparams) {
            double t = temp.get(j);
            temp.set(j, t + h);
            Vektor forward = this.getValue(temp);
            temp.set(j, t - h);
            Vektor backward = this.getValue(temp);
            temp.set(j, t);
            Matrix centerDiff = forward.minus(backward);
            centerDiff.timesEquals(1.0 / (2.0 * h));
            J.setMatrix(0, this.m - 1, j, j, centerDiff);
            ++j;
        }
        return true;
    }

    @Override
    public Matrix getJacobianState(Vektor x) {
        Matrix J = this.getJacobian(x);
        return J.getMatrix(0, this.m - 1, 0, this.n - 1);
    }

    @Override
    public Matrix getJacobianParam(Vektor x) {
        Matrix J = this.getJacobian(x);
        return J.getMatrix(0, this.m - 1, this.n, this.n + this.activeparams - 1);
    }

    @Override
    public Matrix getJacobian(Vektor x) {
        if (x.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        Matrix J = new Matrix(this.m, this.n + this.activeparams);
        this.getJacobian(x, J);
        return J;
    }

    @Override
    public double[][][] getDerivation2(Vektor x) {
        if (x.getLength() != this.n + this.activeparams) {
            throw new IllegalArgumentException("Vector has wrong dim.");
        }
        double h = Math.sqrt(Math.sqrt(Settings.getMachinePrecision()));
        double[][][] ret = new double[this.m][this.n + this.activeparams][this.n + this.activeparams];
        Vektor temp = new Vektor(x);
        int k = 0;
        while (k < this.m) {
            int i = 0;
            while (i < this.n + this.activeparams) {
                int j = 0;
                while (j < this.n + this.activeparams) {
                    if (i == j) {
                        double t = x.get(i);
                        Vektor center = this.getValue(temp);
                        temp.set(i, t + h);
                        Vektor forward = this.getValue(temp);
                        temp.set(i, t - h);
                        Vektor backward = this.getValue(temp);
                        temp.set(i, t);
                        ret[k][i][j] = (forward.get(k) - 2.0 * center.get(k) + backward.get(k)) / (h * h);
                    } else {
                        double t1 = x.get(i);
                        double t2 = x.get(j);
                        temp.set(i, t1 + h);
                        temp.set(j, t2 + h);
                        Vektor ff = this.getValue(temp);
                        temp.set(i, t1 + h);
                        temp.set(j, t2 - h);
                        Vektor fb = this.getValue(temp);
                        temp.set(i, t1 - h);
                        temp.set(j, t2 + h);
                        Vektor bf = this.getValue(temp);
                        temp.set(i, t1 - h);
                        temp.set(j, t2 - h);
                        Vektor bb = this.getValue(temp);
                        temp.set(i, t1);
                        temp.set(j, t2);
                        ret[k][i][j] = (ff.get(k) - fb.get(k) - bf.get(k) + bb.get(k)) / (4.0 * h * h);
                    }
                    ++j;
                }
                ++i;
            }
            ++k;
        }
        return ret;
    }

    @Override
    public Vektor getDerivation2(Vektor x, Vektor v, Vektor w) {
        if (this.n + this.activeparams != x.getLength() || this.n + this.activeparams != v.getLength() || this.n + this.activeparams != w.getLength()) {
            throw new IllegalArgumentException("Dim. does not match");
        }
        double[][][] derivs2 = this.getDerivation2(x);
        Vektor ret = new Vektor(this.m);
        double sum = 0.0;
        int i = 0;
        while (i < this.m) {
            sum = 0.0;
            int k = 0;
            while (k < this.n + this.activeparams) {
                int l = 0;
                while (l < this.n + this.activeparams) {
                    sum += derivs2[i][k][l] * v.get(k) * w.get(l);
                    ++l;
                }
                ++k;
            }
            ret.set(i, sum);
            ++i;
        }
        return ret;
    }

    public String toString() {
        String str = new String();
        int i = 0;
        while (i < this.m) {
            str = String.valueOf(str) + this.functions.toString() + "\n";
            ++i;
        }
        return str;
    }

    @Override
    public Complex[] getEigenvalues(Vektor y) {
        EigenvalueDecomposition ed = new EigenvalueDecomposition(this.getJacobianState(y));
        return ed.getEigenvals();
    }

    class Parameter {
        Variable parameter;
        boolean active;

        Parameter(Variable var, boolean active) {
            this.parameter = var;
            this.active = active;
        }
    }
}

