/*
 * Decompiled with CFR 0.152.
 */
package ds.applets.periodic3d;

import ds.applets.periodic3d.AppletPeriodic3D;
import ds.lang.Options;
import ds.parsing.UtilParser;
import ds.swing.JPanelLoadExample;
import ds.text.ODEOutputReport;
import jaba.math.Interval;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.JTextComponent;
import uibk.geom.Point3D;

class JPanelVectorField
extends JPanel
implements ActionListener {
    JButton jButtonCalc;
    JTextField jTxtX = new JTextField();
    JTextField jTxtY = new JTextField();
    JTextField jTxtZ = new JTextField();
    JTextField jTxtInitialCondtion = new JTextField();
    JTextField jTxtIntervall = new JTextField();
    AppletPeriodic3D main;

    public JPanelVectorField(AppletPeriodic3D main) {
        this.main = main;
        this.initComponents();
    }

    private void addPanelDef() {
        JPanel JPanelDef = new JPanel();
        JPanelDef.setBackground(Options.componentsColor);
        TitledBorder b = BorderFactory.createTitledBorder("Define ode");
        JPanelDef.setBorder(b);
        JPanelDef.setLayout(new GridBagLayout());
        this.jTxtX.setPreferredSize(new Dimension(110, 20));
        this.jTxtY.setPreferredSize(new Dimension(110, 20));
        this.jTxtX.setMaximumSize(new Dimension(110, 20));
        this.jTxtY.setMaximumSize(new Dimension(110, 20));
        this.jTxtZ.setMaximumSize(new Dimension(110, 20));
        this.jTxtZ.setPreferredSize(new Dimension(110, 20));
        JPanelDef.add((Component)new JLabel("x'="), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JPanelDef.add((Component)this.jTxtX, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        JPanelDef.add((Component)new JLabel("y'="), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanelDef.add((Component)this.jTxtY, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        JPanelDef.add((Component)new JLabel("z'="), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        JPanelDef.add((Component)this.jTxtZ, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add(JPanelDef);
    }

    private void addPanelSolve() {
        JPanel jPanelSolve = new JPanel();
        this.setBackground(Options.componentsColor);
        TitledBorder b = BorderFactory.createTitledBorder("Initial value problem");
        jPanelSolve.setBorder(b);
        jPanelSolve.setLayout(new GridBagLayout());
        jPanelSolve.setBackground(Options.componentsColor);
        this.setLayout(new BoxLayout(this, 1));
        this.jTxtInitialCondtion.setPreferredSize(new Dimension(80, 20));
        this.jTxtInitialCondtion.setMaximumSize(new Dimension(80, 20));
        this.jTxtIntervall.setPreferredSize(new Dimension(80, 20));
        this.jTxtIntervall.setMaximumSize(new Dimension(80, 20));
        this.jButtonCalc = new JButton("Solve");
        this.jButtonCalc.setActionCommand("solve");
        this.jButtonCalc.addActionListener(this);
        this.jButtonCalc.setBackground(Options.componentsColor);
        this.setBackground(Options.componentsColor);
        jPanelSolve.add((Component)new JLabel("(x(0),y(0),z(0))="), new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanelSolve.add((Component)this.jTxtInitialCondtion, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanelSolve.add((Component)new JLabel("Interval:"), new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        jPanelSolve.add((Component)this.jTxtIntervall, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        jPanelSolve.add((Component)this.jButtonCalc, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add(jPanelSolve);
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("solve")) {
            this.solveDGL();
        }
    }

    void solveDGL() {
        Vector sol = null;
        Vector<Point3D> points = new Vector<Point3D>();
        String[] dgl = new String[]{this.jTxtX.getText(), this.jTxtY.getText(), this.jTxtZ.getText()};
        Interval interval = null;
        double[] init = null;
        try {
            UtilParser.parseFunction(this.main.f, this.main.vars, this.main.params, dgl);
            interval = UtilParser.parseIntervall(this.jTxtIntervall.getText(), "Integration interval", true);
            init = UtilParser.parseBracketInitalValues(this.jTxtInitialCondtion.getText());
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError(e.getMessage());
            return;
        }
        this.main.odesolver.setDGL(this.main.f);
        this.main.odesolver.setInitialCondition(0.0, init);
        this.main.odesolver.setIntegrationInvervall(interval);
        try {
            sol = this.main.odesolver.solve(null);
        }
        catch (Exception ex) {
            this.main.mathpanel3d.reportError(ex.getMessage());
            return;
        }
        if (sol != null) {
            int i = 0;
            while (i < sol.size()) {
                double[] ptemp = (double[])sol.elementAt(i);
                points.add(new Point3D(ptemp[0], ptemp[1], ptemp[2]));
                ++i;
            }
            this.main.graph3d.clearpoints();
            this.main.graph3d.setPoints(points);
            this.main.graph3d.setColor(Color.blue);
            this.main.graph3d.setVisible(true);
            this.main.mathpanel3d.getScene3D().setBoundingBox(this.main.graph3d.getLimits());
        }
        this.main.mathpanel3d.repaint();
        if (this.main.odesolver.integrationSuccess()) {
            this.main.mathpanel3d.reportSuccess("Integration successful");
        } else {
            this.main.mathpanel3d.reportError("Integration not successful (see Output for more info)");
        }
        String r = ODEOutputReport.getHTMLReport(this.main.odesolver.getReport());
        this.main.outputpanel.setOutput(r);
    }

    private void addPanelExample() {
        String[] options = new String[]{"Lorenz", "Isothermal"};
        JTextComponent[] textfields = new JTextField[]{this.jTxtX, this.jTxtY, this.jTxtZ, this.jTxtInitialCondtion, this.jTxtIntervall};
        String[][] values = new String[][]{{" 3(y - x)", "-x*z + 26.5x - y ", "x*y - z", "(0,1,1)", "[0,20]"}, {"x(30-0.25x-y-z)+0.001y^2+0.1", "y(x-0.001y-12)+0.1", "z(16.5-x-0.5z)+0.1", "(15,23,3)", "[0,25]"}};
        JPanelLoadExample loadexample = new JPanelLoadExample("Examples", "Example", options, textfields, values);
        this.add(loadexample);
    }

    private void initComponents() {
        this.addPanelExample();
        this.addPanelDef();
        this.addPanelSolve();
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Options.componentsColor);
    }
}

