/*
 * Decompiled with CFR 0.152.
 */
package ds.applets.periodic3d;

import ds.applets.periodic3d.AppletPeriodic3D;
import ds.lang.Options;
import ds.parsing.UtilParser;
import ds.text.LCOutputReport;
import jaba.limitcylce.LimitCycleLocator;
import jaba.math.Function;
import jaba.math.Interval;
import jaba.math.Vektor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import uibk.geom.Point3D;

class JPanelSearchLC
extends JPanel
implements ActionListener {
    JTextField jTxTPeriod;
    JTextField jTxtY;
    JTextField jTxtEps;
    JTextField jTxtTOLVar;
    JButton jButtonCalc;
    JSlider jSliderGridPoints = new JSlider();
    JLabel jLabelGrid;
    ButtonGroup groupVectorfieldOpt;
    AppletPeriodic3D main;
    Vektor y;
    double period;
    double eps;

    private boolean getPeriod() {
        if (this.jTxTPeriod.getText() == null || this.jTxTPeriod.getText().equals("")) {
            this.main.mathpanel3d.reportError("No initial period entered");
            return false;
        }
        try {
            this.period = UtilParser.parseConstantExpr(this.jTxTPeriod.getText());
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError("Error in initial period: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean getEps() {
        if (this.jTxTPeriod.getText() == null || this.jTxTPeriod.getText().equals("")) {
            this.main.mathpanel3d.reportError("No accuracy entered");
            return false;
        }
        try {
            this.eps = UtilParser.parseConstantExpr(this.jTxtEps.getText());
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError("Error in accuracy" + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean getInitialY() {
        try {
            double[] temp = UtilParser.parseBracketInitalValues(this.jTxtY.getText());
            this.y = new Vektor(temp);
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError("Fehler bei Y: " + e.getMessage());
            return false;
        }
        return true;
    }

    private boolean parsefunction() {
        String[] dgl = new String[]{this.main.panelvectorfield.jTxtX.getText(), this.main.panelvectorfield.jTxtY.getText(), this.main.panelvectorfield.jTxtZ.getText()};
        try {
            UtilParser.parseFunction(this.main.f, this.main.vars, this.main.params, dgl);
        }
        catch (Exception e) {
            this.main.mathpanel3d.reportError("Fehler beim Vektorfeld: " + e.getMessage());
            return false;
        }
        return true;
    }

    private void drawOrbit(Vektor x, double p) {
        this.main.odesolver.setDGL(this.main.f);
        this.main.odesolver.setIntegrationInvervall(new Interval(0.0, p));
        this.main.odesolver.setInitialCondition(0.0, x.getRowPackedCopy());
        Vector sol = null;
        try {
            sol = this.main.odesolver.solve(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        this.main.graph3d.clearpoints();
        int i = 0;
        while (i < sol.size()) {
            double[] temp = (double[])sol.elementAt(i);
            this.main.graph3d.addPoint(new Point3D(temp[0], temp[1], temp[2]));
            ++i;
        }
        this.main.graph3d.recalcLimits();
        this.main.mathpanel3d.getScene3D().setBoundingBox(this.main.graph3d.getLimits());
        this.main.mathpanel3d.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        if (ev.getActionCommand().equals("computelimitcycle")) {
            boolean success = false;
            if (this.parsefunction() && this.getInitialY() && this.getPeriod() && this.getEps()) {
                this.main.limitcyclelocator.setTOL(this.eps);
                this.main.limitcyclelocator.setFunction((Function)this.main.f);
                try {
                    success = this.main.limitcyclelocator.compute(this.y, this.period, null);
                }
                catch (Exception e) {
                    this.main.mathpanel3d.reportError(e.getMessage());
                    String report = LCOutputReport.getHTMLReport((LimitCycleLocator.LCReport)this.main.limitcyclelocator.getReport());
                    this.main.outputpanel.setOutput(report);
                    return;
                }
            }
            if (success) {
                this.main.mathpanel3d.report("Periodic orbit: Point:" + this.main.limitcyclelocator.getPoint() + ", Period:" + this.main.limitcyclelocator.getPeriod());
                this.drawOrbit(this.main.limitcyclelocator.getPoint(), this.main.limitcyclelocator.getPeriod());
            } else {
                this.main.mathpanel3d.report("<html><font color=red>Could not compute periodic orbit</font>");
            }
            String report = LCOutputReport.getHTMLReport((LimitCycleLocator.LCReport)this.main.limitcyclelocator.getReport());
            this.main.outputpanel.setOutput(report);
        }
    }

    public JPanelSearchLC(AppletPeriodic3D main) {
        this.main = main;
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(Options.componentsColor);
        TitledBorder b = BorderFactory.createTitledBorder("Compute limit cycle");
        this.setBorder(b);
        this.setLayout(new GridBagLayout());
        this.jTxTPeriod = new JTextField("7");
        this.jTxtY = new JTextField("(2,0)");
        this.jTxtEps = new JTextField("1E-8");
        this.jTxtTOLVar = new JTextField("1E-8");
        this.jTxTPeriod.setPreferredSize(new Dimension(40, 20));
        this.jTxtY.setPreferredSize(new Dimension(80, 20));
        this.jTxTPeriod.setMinimumSize(new Dimension(40, 20));
        this.jTxtY.setMinimumSize(new Dimension(80, 20));
        this.jTxtEps.setMinimumSize(new Dimension(80, 20));
        this.jTxtEps.setPreferredSize(new Dimension(80, 20));
        this.jTxtTOLVar.setMinimumSize(new Dimension(80, 20));
        this.jTxtTOLVar.setPreferredSize(new Dimension(80, 20));
        this.jButtonCalc = new JButton("Compute");
        this.jButtonCalc.setActionCommand("computelimitcycle");
        this.jButtonCalc.addActionListener(this);
        this.jButtonCalc.setBackground(Options.componentsColor);
        this.setBackground(Options.componentsColor);
        this.jSliderGridPoints.setBackground(Options.componentsColor);
        this.jSliderGridPoints.setMinimum(2);
        this.jSliderGridPoints.setMaximum(40);
        this.jSliderGridPoints.setValue(25);
        this.add((Component)new JLabel("Period guess"), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.jTxTPeriod, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Point guess"), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTxtY, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)new JLabel("Accuracy:"), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.jTxtEps, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.jButtonCalc, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(25, 0, 0, 0), 0, 0));
    }
}

