/*
 * Decompiled with CFR 0.152.
 */
package uibk.mtk.math.parsing;

import uibk.mtk.lang.InputException;
import uibk.mtk.math.parsing.Messages;
import uibk.mtk.math.parsing.Misc;
import uibk.mtk.math.parsing.ParsingResult;
import uibk.mtk.math.parsing.RealExpressionParser;

final class ParametricCurveParser {
    private ParametricCurveParser() {
    }

    public static synchronized ParsingResult parseParametricCurve(char var, String strcurve, int dim) throws Exception {
        if (dim < 2) {
            throw new IllegalArgumentException(Messages.getString("DimMustGreaterEqualToTwo"));
        }
        if (strcurve == null || strcurve.equals("")) {
            throw new InputException(Messages.getString("NoParametrizedCurveGiven"));
        }
        String str = strcurve.trim();
        int posBracketOpen = str.indexOf("(");
        int posBracketClose = str.lastIndexOf(")");
        if (posBracketOpen == -1) {
            throw new InputException(Messages.getString("FormulaMustStartWithParant"));
        }
        if (posBracketClose == -1 || posBracketClose != str.length() - 1) {
            throw new InputException(Messages.getString("FormulaMustEndWithParant"));
        }
        int unmatchedbracket = 0;
        int pos = str.length() - 1;
        int leftbracketPos = 0;
        while (pos >= 0) {
            if (str.charAt(pos) == ')') {
                ++unmatchedbracket;
            }
            if (str.charAt(pos) == '(' && --unmatchedbracket == 0) {
                leftbracketPos = pos;
                break;
            }
            --pos;
        }
        if (unmatchedbracket != 0) {
            throw new Exception(Messages.getString("ErrorWithParant"));
        }
        String strcommon = str.substring(0, leftbracketPos);
        String[] components = Misc.split(str.substring(leftbracketPos + 1, str.length() - 1), ",");
        if (components == null) {
            throw new InputException(Messages.getString("ErrorInFormula"));
        }
        if (components.length != dim) {
            throw new InputException(String.valueOf(Messages.getString("NumberOfComponentsMustBeEqual")) + dim + Messages.getString("Sein"));
        }
        if (!strcommon.equals("") && !strcommon.endsWith("*")) {
            strcommon = String.valueOf(strcommon) + "*";
        }
        int i = 0;
        while (i < dim) {
            components[i] = String.valueOf(strcommon) + components[i];
            ++i;
        }
        return RealExpressionParser.parseFunction(new String[]{String.valueOf(var)}, components);
    }
}

